/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ambari.metrics.core.timeline.availability;

import org.apache.ambari.metrics.core.timeline.aggregators.TimelineMetricAggregator;
import org.apache.ambari.metrics.core.timeline.availability.AggregationTaskRunner;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.helix.NotificationContext;
import org.apache.helix.model.Message;
import org.apache.helix.participant.statemachine.StateModel;
import org.apache.helix.participant.statemachine.StateModelFactory;

public class OnlineOfflineStateModelFactory
extends StateModelFactory<StateModel> {
    private static final Log LOG = LogFactory.getLog(OnlineOfflineStateModelFactory.class);
    private final String instanceName;
    private final AggregationTaskRunner taskRunner;

    public OnlineOfflineStateModelFactory(String instanceName, AggregationTaskRunner taskRunner) {
        this.instanceName = instanceName;
        this.taskRunner = taskRunner;
    }

    public StateModel createNewStateModel(String resourceName, String partition) {
        LOG.info((Object)("Received request to process partition = " + partition + ", for resource = " + resourceName + ", at " + this.instanceName));
        return new OnlineOfflineStateModel();
    }

    public class OnlineOfflineStateModel
    extends StateModel {
        public void onBecomeOnlineFromOffline(Message message, NotificationContext context) {
            String partitionName = message.getPartitionName();
            LOG.info((Object)("Received transition to Online from Offline for partition: " + partitionName));
            TimelineMetricAggregator.AGGREGATOR_TYPE type = AggregationTaskRunner.PARTITION_AGGREGATION_TYPES.get(partitionName);
            OnlineOfflineStateModelFactory.this.taskRunner.setPartitionAggregationFunction(type);
        }

        public void onBecomeOfflineFromOnline(Message message, NotificationContext context) {
            String partitionName = message.getPartitionName();
            LOG.info((Object)("Received transition to Offline from Online for partition: " + partitionName));
            TimelineMetricAggregator.AGGREGATOR_TYPE type = AggregationTaskRunner.PARTITION_AGGREGATION_TYPES.get(partitionName);
            OnlineOfflineStateModelFactory.this.taskRunner.unsetPartitionAggregationFunction(type);
        }

        public void onBecomeDroppedFromOffline(Message message, NotificationContext context) {
            String partitionName = message.getPartitionName();
            LOG.info((Object)("Received transition to Dropped from Offline for partition: " + partitionName));
            TimelineMetricAggregator.AGGREGATOR_TYPE type = AggregationTaskRunner.PARTITION_AGGREGATION_TYPES.get(partitionName);
            OnlineOfflineStateModelFactory.this.taskRunner.unsetPartitionAggregationFunction(type);
        }
    }
}

