/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ambari.metrics.core.timeline.availability;

import org.I0Itec.zkclient.DataUpdater;
import org.apache.ambari.metrics.core.timeline.availability.AggregationTaskRunner;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.helix.AccessOption;
import org.apache.helix.ZNRecord;
import org.apache.helix.store.zk.ZkHelixPropertyStore;
import org.apache.zookeeper.data.Stat;

public class CheckpointManager {
    private final ZkHelixPropertyStore<ZNRecord> propertyStore;
    private static final Log LOG = LogFactory.getLog(CheckpointManager.class);
    static final String ZNODE_FIELD = "checkpoint";
    static final String CHECKPOINT_PATH_PREFIX = "CHECKPOINTS";

    public CheckpointManager(ZkHelixPropertyStore<ZNRecord> propertyStore) {
        this.propertyStore = propertyStore;
    }

    public long readCheckpoint(AggregationTaskRunner.AGGREGATOR_NAME aggregatorName) {
        String path = this.getCheckpointZKPath(aggregatorName);
        LOG.debug((Object)("Reading checkpoint at " + path));
        Stat stat = new Stat();
        ZNRecord znRecord = (ZNRecord)this.propertyStore.get(path, stat, AccessOption.PERSISTENT);
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Stat => " + stat));
        }
        long checkpoint = znRecord != null ? znRecord.getLongField(ZNODE_FIELD, -1L) : -1L;
        LOG.debug((Object)("Checkpoint value = " + checkpoint));
        return checkpoint;
    }

    public boolean writeCheckpoint(AggregationTaskRunner.AGGREGATOR_NAME aggregatorName, long value) {
        String path = this.getCheckpointZKPath(aggregatorName);
        LOG.debug((Object)String.format("Saving checkpoint at %s with value %s", path, value));
        return this.propertyStore.update(path, (DataUpdater)new CheckpointDataUpdater(path, value), AccessOption.PERSISTENT);
    }

    String getCheckpointZKPath(AggregationTaskRunner.AGGREGATOR_NAME aggregatorName) {
        StringBuilder sb = new StringBuilder("/");
        sb.append(CHECKPOINT_PATH_PREFIX);
        sb.append("/");
        sb.append(AggregationTaskRunner.ACTUAL_AGGREGATOR_NAMES.get((Object)aggregatorName));
        return sb.toString();
    }

    static class CheckpointDataUpdater
    implements DataUpdater<ZNRecord> {
        final String path;
        final Long value;

        public CheckpointDataUpdater(String path, Long value) {
            this.path = path;
            this.value = value;
        }

        public ZNRecord update(ZNRecord currentData) {
            if (currentData == null) {
                currentData = new ZNRecord(this.path);
            }
            currentData.setLongField(CheckpointManager.ZNODE_FIELD, this.value.longValue());
            return currentData;
        }
    }
}

