/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ambari.metrics.core.timeline.availability;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.ambari.metrics.core.timeline.aggregators.TimelineMetricAggregator;
import org.apache.ambari.metrics.core.timeline.availability.CheckpointManager;
import org.apache.ambari.metrics.core.timeline.availability.OnlineOfflineStateModelFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.helix.HelixManager;
import org.apache.helix.HelixManagerFactory;
import org.apache.helix.InstanceType;
import org.apache.helix.ZNRecord;
import org.apache.helix.participant.StateMachineEngine;
import org.apache.helix.participant.statemachine.StateModelFactory;
import org.apache.helix.store.zk.ZkHelixPropertyStore;

public class AggregationTaskRunner {
    private final String instanceName;
    private final String zkAddress;
    private final String clusterName;
    private HelixManager manager;
    private static final Log LOG = LogFactory.getLog(AggregationTaskRunner.class);
    private CheckpointManager checkpointManager;
    static final Map<String, TimelineMetricAggregator.AGGREGATOR_TYPE> PARTITION_AGGREGATION_TYPES = new HashMap<String, TimelineMetricAggregator.AGGREGATOR_TYPE>();
    private final AtomicBoolean performsClusterAggregation = new AtomicBoolean(false);
    private final AtomicBoolean performsHostAggregation = new AtomicBoolean(false);
    public static final Map<AGGREGATOR_NAME, String> ACTUAL_AGGREGATOR_NAMES = new HashMap<AGGREGATOR_NAME, String>();

    public AggregationTaskRunner(String instanceName, String zkAddress, String clusterName) {
        this.instanceName = instanceName;
        this.zkAddress = zkAddress;
        this.clusterName = clusterName;
    }

    public void initialize() throws Exception {
        this.manager = HelixManagerFactory.getZKHelixManager((String)this.clusterName, (String)this.instanceName, (InstanceType)InstanceType.PARTICIPANT, (String)this.zkAddress);
        OnlineOfflineStateModelFactory stateModelFactory = new OnlineOfflineStateModelFactory(this.instanceName, this);
        StateMachineEngine stateMach = this.manager.getStateMachineEngine();
        stateMach.registerStateModelFactory("OnlineOffline", (StateModelFactory)stateModelFactory);
        this.manager.connect();
        this.checkpointManager = new CheckpointManager((ZkHelixPropertyStore<ZNRecord>)this.manager.getHelixPropertyStore());
    }

    public boolean performsClusterAggregation() {
        return this.performsClusterAggregation.get();
    }

    public boolean performsHostAggregation() {
        return this.performsHostAggregation.get();
    }

    public CheckpointManager getCheckpointManager() {
        return this.checkpointManager;
    }

    public void setPartitionAggregationFunction(TimelineMetricAggregator.AGGREGATOR_TYPE type) {
        switch (type) {
            case HOST: {
                this.performsHostAggregation.set(true);
                LOG.info((Object)("Set host aggregator function for : " + this.instanceName));
                break;
            }
            case CLUSTER: {
                this.performsClusterAggregation.set(true);
                LOG.info((Object)("Set cluster aggregator function for : " + this.instanceName));
            }
        }
    }

    public void unsetPartitionAggregationFunction(TimelineMetricAggregator.AGGREGATOR_TYPE type) {
        switch (type) {
            case HOST: {
                this.performsHostAggregation.set(false);
                LOG.info((Object)("Unset host aggregator function for : " + this.instanceName));
                break;
            }
            case CLUSTER: {
                this.performsClusterAggregation.set(false);
                LOG.info((Object)("Unset cluster aggregator function for : " + this.instanceName));
            }
        }
    }

    void stop() {
        this.manager.disconnect();
    }

    static {
        ACTUAL_AGGREGATOR_NAMES.put(AGGREGATOR_NAME.METRIC_RECORD_MINUTE, "TimelineMetricHostAggregatorMinute");
        ACTUAL_AGGREGATOR_NAMES.put(AGGREGATOR_NAME.METRIC_RECORD_HOURLY, "TimelineMetricHostAggregatorHourly");
        ACTUAL_AGGREGATOR_NAMES.put(AGGREGATOR_NAME.METRIC_RECORD_DAILY, "TimelineMetricHostAggregatorDaily");
        ACTUAL_AGGREGATOR_NAMES.put(AGGREGATOR_NAME.METRIC_AGGREGATE_SECOND, "TimelineClusterAggregatorSecond");
        ACTUAL_AGGREGATOR_NAMES.put(AGGREGATOR_NAME.METRIC_AGGREGATE_MINUTE, "TimelineClusterAggregatorMinute");
        ACTUAL_AGGREGATOR_NAMES.put(AGGREGATOR_NAME.METRIC_AGGREGATE_HOURLY, "TimelineClusterAggregatorHourly");
        ACTUAL_AGGREGATOR_NAMES.put(AGGREGATOR_NAME.METRIC_AGGREGATE_DAILY, "TimelineClusterAggregatorDaily");
        PARTITION_AGGREGATION_TYPES.put("METRIC_AGGREGATORS_0", TimelineMetricAggregator.AGGREGATOR_TYPE.CLUSTER);
        PARTITION_AGGREGATION_TYPES.put("METRIC_AGGREGATORS_1", TimelineMetricAggregator.AGGREGATOR_TYPE.HOST);
    }

    public static enum AGGREGATOR_NAME {
        METRIC_RECORD_MINUTE,
        METRIC_RECORD_HOURLY,
        METRIC_RECORD_DAILY,
        METRIC_AGGREGATE_SECOND,
        METRIC_AGGREGATE_MINUTE,
        METRIC_AGGREGATE_HOURLY,
        METRIC_AGGREGATE_DAILY;

    }
}

