/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ambari.metrics.core.timeline.aggregators.v2;

import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import org.apache.ambari.metrics.core.timeline.PhoenixHBaseAccessor;
import org.apache.ambari.metrics.core.timeline.aggregators.AbstractTimelineAggregator;
import org.apache.ambari.metrics.core.timeline.availability.AggregationTaskRunner;
import org.apache.ambari.metrics.core.timeline.availability.MetricCollectorHAController;
import org.apache.ambari.metrics.core.timeline.query.Condition;
import org.apache.ambari.metrics.core.timeline.query.EmptyCondition;
import org.apache.hadoop.conf.Configuration;

public class TimelineMetricHostAggregator
extends AbstractTimelineAggregator {
    public TimelineMetricHostAggregator(AggregationTaskRunner.AGGREGATOR_NAME aggregatorName, PhoenixHBaseAccessor hBaseAccessor, Configuration metricsConf, String checkpointLocation, Long sleepIntervalMillis, Integer checkpointCutOffMultiplier, String hostAggregatorDisabledParam, String tableName, String outputTableName, Long nativeTimeRangeDelay, MetricCollectorHAController haController) {
        super(aggregatorName, hBaseAccessor, metricsConf, checkpointLocation, sleepIntervalMillis, checkpointCutOffMultiplier, hostAggregatorDisabledParam, tableName, outputTableName, nativeTimeRangeDelay, haController);
    }

    @Override
    protected void aggregate(ResultSet rs, long startTime, long endTime) throws IOException, SQLException {
        this.LOG.info("Aggregated host metrics for " + this.outputTableName + ", with startTime = " + new Date(startTime) + ", endTime = " + new Date(endTime));
    }

    @Override
    protected Condition prepareMetricQueryCondition(long startTime, long endTime) {
        EmptyCondition condition = new EmptyCondition();
        condition.setDoUpdate(true);
        condition.setStatement(String.format("UPSERT INTO %s (UUID, SERVER_TIME, METRIC_SUM, METRIC_COUNT, METRIC_MAX, METRIC_MIN) SELECT UUID, %s AS SERVER_TIME, SUM(METRIC_SUM), SUM(METRIC_COUNT), MAX(METRIC_MAX), MIN(METRIC_MIN) FROM %s WHERE%s SERVER_TIME >= %s AND SERVER_TIME < %s GROUP BY UUID", this.outputTableName, endTime - 1000L, this.tableName, this.getDownsampledMetricSkipClause(), startTime, endTime));
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("Condition: " + condition.toString());
        }
        return condition;
    }
}

