/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ambari.metrics.core.timeline.aggregators.v2;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ambari.metrics.core.timeline.PhoenixHBaseAccessor;
import org.apache.ambari.metrics.core.timeline.aggregators.v2.TimelineMetricHostAggregator;
import org.apache.ambari.metrics.core.timeline.availability.AggregationTaskRunner;
import org.apache.ambari.metrics.core.timeline.availability.MetricCollectorHAController;
import org.apache.ambari.metrics.core.timeline.discovery.TimelineMetricMetadataManager;
import org.apache.ambari.metrics.core.timeline.query.Condition;
import org.apache.ambari.metrics.core.timeline.query.EmptyCondition;
import org.apache.commons.collections.CollectionUtils;
import org.apache.hadoop.conf.Configuration;

public class TimelineMetricFilteringHostAggregator
extends TimelineMetricHostAggregator {
    private TimelineMetricMetadataManager metricMetadataManager;
    private ConcurrentHashMap<String, Long> postedAggregatedMap;

    public TimelineMetricFilteringHostAggregator(AggregationTaskRunner.AGGREGATOR_NAME aggregatorName, TimelineMetricMetadataManager metricMetadataManager, PhoenixHBaseAccessor hBaseAccessor, Configuration metricsConf, String checkpointLocation, Long sleepIntervalMillis, Integer checkpointCutOffMultiplier, String hostAggregatorDisabledParam, String tableName, String outputTableName, Long nativeTimeRangeDelay, MetricCollectorHAController haController, ConcurrentHashMap<String, Long> postedAggregatedMap) {
        super(aggregatorName, hBaseAccessor, metricsConf, checkpointLocation, sleepIntervalMillis, checkpointCutOffMultiplier, hostAggregatorDisabledParam, tableName, outputTableName, nativeTimeRangeDelay, haController);
        this.metricMetadataManager = metricMetadataManager;
        this.postedAggregatedMap = postedAggregatedMap;
    }

    @Override
    protected Condition prepareMetricQueryCondition(long startTime, long endTime) {
        ArrayList<String> aggregatedHostnames = new ArrayList<String>();
        for (Map.Entry<String, Long> entry : this.postedAggregatedMap.entrySet()) {
            if (entry.getValue() <= startTime || entry.getValue() > endTime) continue;
            aggregatedHostnames.add(entry.getKey());
        }
        List<String> notAggregatedHostnames = this.metricMetadataManager.getNotLikeHostnames(aggregatedHostnames);
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("Already aggregated hostnames based on postedAggregatedMap : " + aggregatedHostnames);
            this.LOG.debug("Hostnames that will be aggregated : " + notAggregatedHostnames);
        }
        List<byte[]> uuids = this.metricMetadataManager.getUuidsForGetMetricQuery(new ArrayList<String>(), notAggregatedHostnames, "", "");
        EmptyCondition condition = new EmptyCondition();
        condition.setDoUpdate(true);
        condition.setStatement(String.format("UPSERT INTO %s (UUID, SERVER_TIME, METRIC_SUM, METRIC_COUNT, METRIC_MAX, METRIC_MIN) SELECT UUID, %s AS SERVER_TIME, SUM(METRIC_SUM), SUM(METRIC_COUNT), MAX(METRIC_MAX), MIN(METRIC_MIN) FROM %s WHERE%s SERVER_TIME >= %s AND SERVER_TIME < %s GROUP BY UUID", this.outputTableName, endTime - 1000L, this.tableName, this.getDownsampledMetricSkipClause() + this.getIncludedUuidsClause(uuids), startTime, endTime));
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("Condition: " + condition.toString());
        }
        return condition;
    }

    private String getIncludedUuidsClause(List<byte[]> uuids) {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        if (CollectionUtils.isNotEmpty(uuids)) {
            for (int i = 0; i < uuids.size(); ++i) {
                sb.append("UUID");
                sb.append(" LIKE ");
                sb.append("'%");
                sb.append(new String(uuids.get(i)));
                sb.append("'");
                if (i == uuids.size() - 1) {
                    sb.append(") AND ");
                    continue;
                }
                sb.append(" OR ");
            }
        }
        return sb.toString();
    }
}

