/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ambari.metrics.core.timeline.aggregators;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.ambari.metrics.core.timeline.aggregators.CustomDownSampler;
import org.apache.ambari.metrics.core.timeline.aggregators.Function;
import org.apache.ambari.metrics.core.timeline.query.TopNCondition;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.metrics2.sink.timeline.TopNConfig;

public class TopNDownSampler
implements CustomDownSampler {
    private TopNConfig topNConfig;
    private static final Log LOG = LogFactory.getLog(TopNDownSampler.class);
    protected String metricPatterns;

    public static TopNDownSampler fromConfig(Map<String, String> conf) {
        String metricPatterns = conf.get("timeline.metrics.downsampler.topn.metric.patterns");
        String topNString = conf.get("timeline.metrics.downsampler.topn.value");
        Integer topNValue = topNString != null ? Integer.valueOf(topNString) : 10;
        String topNFunction = conf.get("timeline.metrics.downsampler.topn.function");
        return new TopNDownSampler(new TopNConfig(topNValue, topNFunction, Boolean.valueOf(false)), metricPatterns);
    }

    public TopNDownSampler(TopNConfig topNConfig, String metricPatterns) {
        this.topNConfig = topNConfig;
        this.metricPatterns = metricPatterns;
    }

    @Override
    public boolean validateConfigs() {
        if (this.topNConfig == null) {
            return false;
        }
        if (this.topNConfig.getTopN() <= 0) {
            return false;
        }
        return !StringUtils.isEmpty((CharSequence)this.metricPatterns);
    }

    @Override
    public List<String> prepareDownSamplingStatement(Long startTime, Long endTime, String tableName) {
        ArrayList<String> stmts = new ArrayList<String>();
        Function.ReadFunction readFunction = Function.ReadFunction.getFunction(this.topNConfig.getTopNFunction());
        Function function = new Function(readFunction, null);
        String columnSelect = TopNCondition.getColumnSelect(function);
        List<String> metricPatternList = Arrays.asList(this.metricPatterns.split(","));
        for (String metricPattern : metricPatternList) {
            String metricPatternClause = "'" + metricPattern + "'";
            if (tableName.contains("RECORD")) {
                stmts.add(String.format("SELECT UUID, %s AS SERVER_TIME, %s, 1, %s, %s FROM %s WHERE UUID IN %s AND SERVER_TIME > %s AND SERVER_TIME <= %s GROUP BY UUID ORDER BY %s DESC LIMIT %s", endTime, columnSelect, columnSelect, columnSelect, tableName, metricPatternClause, startTime, endTime, columnSelect, this.topNConfig.getTopN()));
                continue;
            }
            stmts.add(String.format("SELECT UUID, %s AS SERVER_TIME, %s, 1, %s, %s FROM %s WHERE UUID IN %s AND SERVER_TIME > %s AND SERVER_TIME <= %s GROUP BY UUID ORDER BY %s DESC LIMIT %s", endTime, columnSelect, columnSelect, columnSelect, tableName, metricPatternClause, startTime, endTime, columnSelect, this.topNConfig.getTopN()));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("DownSampling Stmt: " + ((Object)stmts).toString()));
        }
        return stmts;
    }
}

