/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ambari.metrics.core.timeline.aggregators;

import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.TreeMap;
import org.apache.ambari.metrics.core.timeline.PhoenixHBaseAccessor;
import org.apache.ambari.metrics.core.timeline.aggregators.Function;
import org.apache.ambari.metrics.core.timeline.aggregators.TimelineClusterMetric;
import org.apache.ambari.metrics.core.timeline.discovery.TimelineMetricMetadataManager;
import org.apache.hadoop.metrics2.sink.timeline.MetricClusterAggregate;
import org.apache.hadoop.metrics2.sink.timeline.MetricHostAggregate;
import org.apache.hadoop.metrics2.sink.timeline.SingleValuedTimelineMetric;
import org.apache.hadoop.metrics2.sink.timeline.TimelineMetric;

public class TimelineMetricReadHelper {
    private boolean ignoreInstance = false;
    private TimelineMetricMetadataManager metadataManagerInstance = null;

    public TimelineMetricReadHelper() {
    }

    public TimelineMetricReadHelper(boolean ignoreInstance) {
        this.ignoreInstance = ignoreInstance;
    }

    public TimelineMetricReadHelper(TimelineMetricMetadataManager timelineMetricMetadataManager) {
        this.metadataManagerInstance = timelineMetricMetadataManager;
    }

    public TimelineMetricReadHelper(TimelineMetricMetadataManager timelineMetricMetadataManager, boolean ignoreInstance) {
        this.metadataManagerInstance = timelineMetricMetadataManager;
        this.ignoreInstance = ignoreInstance;
    }

    public TimelineMetric getTimelineMetricFromResultSet(ResultSet rs) throws SQLException, IOException {
        TimelineMetric metric = this.getTimelineMetricCommonsFromResultSet(rs);
        if (metric == null) {
            return null;
        }
        TreeMap<Long, Double> sortedByTimeMetrics = PhoenixHBaseAccessor.readMetricFromJSON(rs.getString("METRICS"));
        metric.setMetricValues(sortedByTimeMetrics);
        return metric;
    }

    public SingleValuedTimelineMetric getAggregatedTimelineMetricFromResultSet(ResultSet rs, Function f, boolean shouldSumMetricAcrossTime) throws SQLException, IOException {
        double value;
        byte[] uuid = rs.getBytes("UUID");
        TimelineMetric timelineMetric = this.metadataManagerInstance.getMetricFromUuid(uuid);
        Function function = f != null ? f : Function.DEFAULT_VALUE_FUNCTION;
        SingleValuedTimelineMetric metric = new SingleValuedTimelineMetric(timelineMetric.getMetricName() + function.getSuffix(), timelineMetric.getAppId(), timelineMetric.getInstanceId(), timelineMetric.getHostName(), rs.getLong("SERVER_TIME"));
        switch (function.getReadFunction()) {
            case AVG: {
                value = rs.getDouble("METRIC_SUM") / (double)rs.getInt("METRIC_COUNT");
                break;
            }
            case MIN: {
                value = rs.getDouble("METRIC_MIN");
                break;
            }
            case MAX: {
                value = rs.getDouble("METRIC_MAX");
                break;
            }
            case SUM: {
                value = rs.getDouble("METRIC_SUM");
                if (shouldSumMetricAcrossTime) break;
                value /= (double)rs.getInt("METRIC_COUNT");
                break;
            }
            default: {
                value = rs.getDouble("METRIC_SUM") / (double)rs.getInt("METRIC_COUNT");
            }
        }
        metric.setSingleTimeseriesValue(Long.valueOf(rs.getLong("SERVER_TIME")), Double.valueOf(value));
        return metric;
    }

    public TimelineMetric getTimelineMetricCommonsFromResultSet(ResultSet rs) throws SQLException {
        byte[] uuid = rs.getBytes("UUID");
        TimelineMetric metric = this.metadataManagerInstance.getMetricFromUuid(uuid);
        if (metric == null) {
            return null;
        }
        if (this.ignoreInstance) {
            metric.setInstanceId(null);
        }
        metric.setStartTime(rs.getLong("SERVER_TIME"));
        return metric;
    }

    public MetricClusterAggregate getMetricClusterAggregateFromResultSet(ResultSet rs) throws SQLException {
        MetricClusterAggregate agg = new MetricClusterAggregate();
        agg.setSum(Double.valueOf(rs.getDouble("METRIC_SUM")));
        agg.setMax(Double.valueOf(rs.getDouble("METRIC_MAX")));
        agg.setMin(Double.valueOf(rs.getDouble("METRIC_MIN")));
        agg.setNumberOfHosts(rs.getInt("HOSTS_COUNT"));
        agg.setDeviation(Double.valueOf(0.0));
        return agg;
    }

    public MetricClusterAggregate getMetricClusterTimeAggregateFromResultSet(ResultSet rs) throws SQLException {
        MetricClusterAggregate agg = new MetricClusterAggregate();
        agg.setSum(Double.valueOf(rs.getDouble("METRIC_SUM")));
        agg.setMax(Double.valueOf(rs.getDouble("METRIC_MAX")));
        agg.setMin(Double.valueOf(rs.getDouble("METRIC_MIN")));
        agg.setNumberOfHosts(rs.getInt("METRIC_COUNT"));
        agg.setDeviation(Double.valueOf(0.0));
        return agg;
    }

    public TimelineClusterMetric fromResultSet(ResultSet rs) throws SQLException {
        byte[] uuid = rs.getBytes("UUID");
        TimelineMetric timelineMetric = this.metadataManagerInstance.getMetricFromUuid(uuid);
        if (timelineMetric == null) {
            return null;
        }
        return new TimelineClusterMetric(timelineMetric.getMetricName(), timelineMetric.getAppId(), this.ignoreInstance ? null : timelineMetric.getInstanceId(), rs.getLong("SERVER_TIME"));
    }

    public MetricHostAggregate getMetricHostAggregateFromResultSet(ResultSet rs) throws SQLException {
        MetricHostAggregate metricHostAggregate = new MetricHostAggregate();
        metricHostAggregate.setSum(Double.valueOf(rs.getDouble("METRIC_SUM")));
        metricHostAggregate.setMax(Double.valueOf(rs.getDouble("METRIC_MAX")));
        metricHostAggregate.setMin(Double.valueOf(rs.getDouble("METRIC_MIN")));
        metricHostAggregate.setNumberOfSamples(rs.getLong("METRIC_COUNT"));
        metricHostAggregate.setDeviation(Double.valueOf(0.0));
        return metricHostAggregate;
    }

    public TimelineMetric getTimelineMetricKeyFromResultSet(ResultSet rs) throws SQLException, IOException {
        byte[] uuid = rs.getBytes("UUID");
        return this.metadataManagerInstance.getMetricFromUuid(uuid);
    }
}

