/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ambari.metrics.core.timeline.aggregators;

import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.apache.ambari.metrics.core.timeline.PhoenixHBaseAccessor;
import org.apache.ambari.metrics.core.timeline.aggregators.AbstractTimelineAggregator;
import org.apache.ambari.metrics.core.timeline.aggregators.TimelineMetricReadHelper;
import org.apache.ambari.metrics.core.timeline.availability.AggregationTaskRunner;
import org.apache.ambari.metrics.core.timeline.availability.MetricCollectorHAController;
import org.apache.ambari.metrics.core.timeline.discovery.TimelineMetricMetadataManager;
import org.apache.ambari.metrics.core.timeline.query.Condition;
import org.apache.ambari.metrics.core.timeline.query.DefaultCondition;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.metrics2.sink.timeline.MetricHostAggregate;
import org.apache.hadoop.metrics2.sink.timeline.TimelineMetric;

public class TimelineMetricHostAggregator
extends AbstractTimelineAggregator {
    private static final Log LOG = LogFactory.getLog(TimelineMetricHostAggregator.class);
    TimelineMetricReadHelper readHelper;

    public TimelineMetricHostAggregator(AggregationTaskRunner.AGGREGATOR_NAME aggregatorName, TimelineMetricMetadataManager metricMetadataManager, PhoenixHBaseAccessor hBaseAccessor, Configuration metricsConf, String checkpointLocation, Long sleepIntervalMillis, Integer checkpointCutOffMultiplier, String hostAggregatorDisabledParam, String tableName, String outputTableName, Long nativeTimeRangeDelay, MetricCollectorHAController haController) {
        super(aggregatorName, hBaseAccessor, metricsConf, checkpointLocation, sleepIntervalMillis, checkpointCutOffMultiplier, hostAggregatorDisabledParam, tableName, outputTableName, nativeTimeRangeDelay, haController);
        this.readHelper = new TimelineMetricReadHelper(metricMetadataManager, false);
    }

    @Override
    protected void aggregate(ResultSet rs, long startTime, long endTime) throws IOException, SQLException {
        Map<TimelineMetric, MetricHostAggregate> hostAggregateMap = this.aggregateMetricsFromResultSet(rs, endTime - 1000L);
        LOG.info((Object)("Saving " + hostAggregateMap.size() + " metric aggregates."));
        this.hBaseAccessor.saveHostAggregateRecords(hostAggregateMap, this.outputTableName);
    }

    @Override
    protected Condition prepareMetricQueryCondition(long startTime, long endTime) {
        DefaultCondition condition = new DefaultCondition(null, null, null, null, startTime, endTime, null, null, true);
        condition.setNoLimit();
        condition.setFetchSize(this.resultsetFetchSize);
        condition.setStatement(String.format("SELECT UUID, SERVER_TIME, METRIC_SUM, METRIC_MAX, METRIC_MIN, METRIC_COUNT FROM %s", this.tableName));
        condition.addOrderByColumn("UUID");
        condition.addOrderByColumn("SERVER_TIME");
        return condition;
    }

    private Map<TimelineMetric, MetricHostAggregate> aggregateMetricsFromResultSet(ResultSet rs, long endTime) throws IOException, SQLException {
        TimelineMetric existingMetric = null;
        MetricHostAggregate hostAggregate = null;
        HashMap<TimelineMetric, MetricHostAggregate> hostAggregateMap = new HashMap<TimelineMetric, MetricHostAggregate>();
        while (rs.next()) {
            TimelineMetric currentMetric = this.readHelper.getTimelineMetricKeyFromResultSet(rs);
            if (currentMetric == null) continue;
            MetricHostAggregate currentHostAggregate = this.readHelper.getMetricHostAggregateFromResultSet(rs);
            if (existingMetric == null) {
                existingMetric = currentMetric;
                currentMetric.setStartTime(endTime);
                hostAggregate = new MetricHostAggregate();
                hostAggregateMap.put(currentMetric, hostAggregate);
            }
            if (existingMetric.equalsExceptTime(currentMetric)) {
                hostAggregate.updateAggregates(currentHostAggregate);
                continue;
            }
            currentMetric.setStartTime(endTime);
            hostAggregate = new MetricHostAggregate();
            hostAggregate.updateAggregates(currentHostAggregate);
            hostAggregateMap.put(currentMetric, hostAggregate);
            existingMetric = currentMetric;
        }
        return hostAggregateMap;
    }
}

