/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ambari.metrics.core.timeline.aggregators;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ambari.metrics.core.timeline.PhoenixHBaseAccessor;
import org.apache.ambari.metrics.core.timeline.aggregators.TimelineMetricHostAggregator;
import org.apache.ambari.metrics.core.timeline.availability.AggregationTaskRunner;
import org.apache.ambari.metrics.core.timeline.availability.MetricCollectorHAController;
import org.apache.ambari.metrics.core.timeline.discovery.TimelineMetricMetadataManager;
import org.apache.ambari.metrics.core.timeline.query.Condition;
import org.apache.ambari.metrics.core.timeline.query.DefaultCondition;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;

public class TimelineMetricFilteringHostAggregator
extends TimelineMetricHostAggregator {
    private static final Log LOG = LogFactory.getLog(TimelineMetricFilteringHostAggregator.class);
    private TimelineMetricMetadataManager metricMetadataManager;
    private ConcurrentHashMap<String, Long> postedAggregatedMap;

    public TimelineMetricFilteringHostAggregator(AggregationTaskRunner.AGGREGATOR_NAME aggregatorName, TimelineMetricMetadataManager metricMetadataManager, PhoenixHBaseAccessor hBaseAccessor, Configuration metricsConf, String checkpointLocation, Long sleepIntervalMillis, Integer checkpointCutOffMultiplier, String hostAggregatorDisabledParam, String tableName, String outputTableName, Long nativeTimeRangeDelay, MetricCollectorHAController haController, ConcurrentHashMap<String, Long> postedAggregatedMap) {
        super(aggregatorName, metricMetadataManager, hBaseAccessor, metricsConf, checkpointLocation, sleepIntervalMillis, checkpointCutOffMultiplier, hostAggregatorDisabledParam, tableName, outputTableName, nativeTimeRangeDelay, haController);
        this.metricMetadataManager = metricMetadataManager;
        this.postedAggregatedMap = postedAggregatedMap;
    }

    @Override
    protected Condition prepareMetricQueryCondition(long startTime, long endTime) {
        ArrayList<String> aggregatedHostnames = new ArrayList<String>();
        for (Map.Entry<String, Long> entry : this.postedAggregatedMap.entrySet()) {
            if (entry.getValue() <= startTime || entry.getValue() > endTime) continue;
            aggregatedHostnames.add(entry.getKey());
        }
        List<String> notAggregatedHostnames = this.metricMetadataManager.getNotLikeHostnames(aggregatedHostnames);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Already aggregated hostnames based on postedAggregatedMap : " + aggregatedHostnames));
            LOG.debug((Object)("Hostnames that will be aggregated : " + notAggregatedHostnames));
        }
        List<byte[]> uuids = this.metricMetadataManager.getUuidsForGetMetricQuery(new ArrayList<String>(), notAggregatedHostnames, "", "");
        DefaultCondition condition = new DefaultCondition(uuids, null, null, null, null, startTime, endTime, null, null, true);
        condition.setNoLimit();
        condition.setFetchSize(this.resultsetFetchSize);
        condition.setStatement(String.format("SELECT UUID, SERVER_TIME, METRIC_SUM, METRIC_MAX, METRIC_MIN, METRIC_COUNT FROM %s", this.tableName));
        condition.addOrderByColumn("UUID");
        condition.addOrderByColumn("SERVER_TIME");
        return condition;
    }
}

