/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ambari.metrics.core.timeline.aggregators;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ambari.metrics.core.timeline.PhoenixHBaseAccessor;
import org.apache.ambari.metrics.core.timeline.TimelineMetricDistributedCache;
import org.apache.ambari.metrics.core.timeline.aggregators.AggregatorUtils;
import org.apache.ambari.metrics.core.timeline.aggregators.TimelineClusterMetric;
import org.apache.ambari.metrics.core.timeline.aggregators.TimelineMetricClusterAggregatorSecond;
import org.apache.ambari.metrics.core.timeline.availability.AggregationTaskRunner;
import org.apache.ambari.metrics.core.timeline.availability.MetricCollectorHAController;
import org.apache.ambari.metrics.core.timeline.discovery.TimelineMetricMetadataManager;
import org.apache.commons.lang.mutable.MutableInt;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.metrics2.sink.timeline.MetricClusterAggregate;

public class TimelineMetricClusterAggregatorSecondWithCacheSource
extends TimelineMetricClusterAggregatorSecond {
    private TimelineMetricDistributedCache distributedCache;

    public TimelineMetricClusterAggregatorSecondWithCacheSource(AggregationTaskRunner.AGGREGATOR_NAME metricAggregateSecond, TimelineMetricMetadataManager metricMetadataManager, PhoenixHBaseAccessor hBaseAccessor, Configuration metricsConf, String checkpointLocation, long sleepIntervalMillis, int checkpointCutOffMultiplier, String aggregatorDisabledParam, String inputTableName, String outputTableName, Long nativeTimeRangeDelay, Long timeSliceInterval, MetricCollectorHAController haController, TimelineMetricDistributedCache distributedCache) {
        super(metricAggregateSecond, metricMetadataManager, hBaseAccessor, metricsConf, checkpointLocation, sleepIntervalMillis, checkpointCutOffMultiplier, aggregatorDisabledParam, inputTableName, outputTableName, nativeTimeRangeDelay, timeSliceInterval, haController);
        this.distributedCache = distributedCache;
    }

    @Override
    public boolean doWork(long startTime, long endTime) {
        this.LOG.info("Start aggregation cycle @ " + new Date() + ", startTime = " + new Date(startTime) + ", endTime = " + new Date(endTime));
        try {
            Map<String, Double> caheMetrics;
            if (this.LOG.isDebugEnabled()) {
                caheMetrics = this.distributedCache.getPointInTimeCacheMetrics();
                this.LOG.debug("Ignite metrics before eviction : " + caheMetrics);
            }
            this.LOG.info("Trying to evict elements from cache");
            Map<TimelineClusterMetric, MetricClusterAggregate> metricsFromCache = this.distributedCache.evictMetricAggregates(startTime - this.serverTimeShiftAdjustment, endTime - this.serverTimeShiftAdjustment);
            this.LOG.info(String.format("Evicted %s elements from cache.", metricsFromCache.size()));
            if (this.LOG.isDebugEnabled()) {
                caheMetrics = this.distributedCache.getPointInTimeCacheMetrics();
                this.LOG.debug("Ignite metrics after eviction : " + caheMetrics);
            }
            List<Long[]> timeSlices = AggregatorUtils.getTimeSlices(startTime - this.serverTimeShiftAdjustment, endTime - this.serverTimeShiftAdjustment, this.timeSliceIntervalMillis);
            Map<TimelineClusterMetric, MetricClusterAggregate> result = this.aggregateMetricsFromMetricClusterAggregates(metricsFromCache, timeSlices);
            this.LOG.info("Saving " + result.size() + " metric aggregates.");
            this.hBaseAccessor.saveClusterAggregateRecords(result);
            this.LOG.info("End aggregation cycle @ " + new Date());
            return true;
        }
        catch (Exception e) {
            this.LOG.error("Exception during aggregation. ", (Throwable)e);
            return false;
        }
    }

    Map<TimelineClusterMetric, MetricClusterAggregate> aggregateMetricsFromMetricClusterAggregates(Map<TimelineClusterMetric, MetricClusterAggregate> metricsFromCache, List<Long[]> timeSlices) {
        HashMap<String, MutableInt> hostedAppCounter = new HashMap<String, MutableInt>();
        for (Map.Entry<TimelineClusterMetric, MetricClusterAggregate> clusterMetricAggregateEntry : metricsFromCache.entrySet()) {
            int numHosts = clusterMetricAggregateEntry.getValue().getNumberOfHosts();
            String appId = clusterMetricAggregateEntry.getKey().getAppId();
            if (!hostedAppCounter.containsKey(appId)) {
                hostedAppCounter.put(appId, new MutableInt(numHosts));
                continue;
            }
            int currentHostCount = ((MutableInt)hostedAppCounter.get(appId)).intValue();
            if (currentHostCount >= numHosts) continue;
            hostedAppCounter.put(appId, new MutableInt(numHosts));
        }
        this.processLiveAppCountMetrics(metricsFromCache, hostedAppCounter, timeSlices.get(timeSlices.size() - 1)[1]);
        return metricsFromCache;
    }
}

