/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ambari.metrics.core.timeline.aggregators;

import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ambari.metrics.core.timeline.PhoenixHBaseAccessor;
import org.apache.ambari.metrics.core.timeline.aggregators.AbstractTimelineAggregator;
import org.apache.ambari.metrics.core.timeline.aggregators.AggregatorUtils;
import org.apache.ambari.metrics.core.timeline.aggregators.TimelineClusterMetric;
import org.apache.ambari.metrics.core.timeline.aggregators.TimelineMetricAppAggregator;
import org.apache.ambari.metrics.core.timeline.aggregators.TimelineMetricReadHelper;
import org.apache.ambari.metrics.core.timeline.availability.AggregationTaskRunner;
import org.apache.ambari.metrics.core.timeline.availability.MetricCollectorHAController;
import org.apache.ambari.metrics.core.timeline.discovery.TimelineMetricMetadataKey;
import org.apache.ambari.metrics.core.timeline.discovery.TimelineMetricMetadataManager;
import org.apache.ambari.metrics.core.timeline.query.Condition;
import org.apache.ambari.metrics.core.timeline.query.DefaultCondition;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.mutable.MutableInt;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.metrics2.sink.timeline.MetricClusterAggregate;
import org.apache.hadoop.metrics2.sink.timeline.TimelineMetric;
import org.apache.hadoop.metrics2.sink.timeline.TimelineMetricMetadata;
import org.apache.hadoop.metrics2.sink.timeline.TimelineMetricUtils;

public class TimelineMetricClusterAggregatorSecond
extends AbstractTimelineAggregator {
    public Long timeSliceIntervalMillis;
    private TimelineMetricReadHelper timelineMetricReadHelper;
    private final TimelineMetricAppAggregator appAggregator;
    protected final Long serverTimeShiftAdjustment;
    protected final boolean interpolationEnabled;
    private TimelineMetricMetadataManager metadataManagerInstance;
    private String skipAggrPatternStrings;
    private List<String> skipInterpolationMetricPatterns = new ArrayList<String>();
    private static final String liveHostsMetricName = "live_hosts";

    public TimelineMetricClusterAggregatorSecond(AggregationTaskRunner.AGGREGATOR_NAME aggregatorName, TimelineMetricMetadataManager metadataManager, PhoenixHBaseAccessor hBaseAccessor, Configuration metricsConf, String checkpointLocation, Long sleepIntervalMillis, Integer checkpointCutOffMultiplier, String aggregatorDisabledParam, String tableName, String outputTableName, Long nativeTimeRangeDelay, Long timeSliceInterval, MetricCollectorHAController haController) {
        super(aggregatorName, hBaseAccessor, metricsConf, checkpointLocation, sleepIntervalMillis, checkpointCutOffMultiplier, aggregatorDisabledParam, tableName, outputTableName, nativeTimeRangeDelay, haController);
        this.metadataManagerInstance = metadataManager;
        this.appAggregator = new TimelineMetricAppAggregator(metadataManager, metricsConf);
        this.timeSliceIntervalMillis = timeSliceInterval;
        this.serverTimeShiftAdjustment = Long.parseLong(metricsConf.get("timeline.metrics.service.cluster.aggregator.timeshift.adjustment", "90000"));
        this.interpolationEnabled = Boolean.parseBoolean(metricsConf.get("timeline.metrics.cluster.aggregator.interpolation.enabled", "true"));
        this.skipAggrPatternStrings = metricsConf.get("timeline.metrics.cluster.aggregation.sql.filters");
        String skipInterpolationMetricPatternStrings = metricsConf.get("timeline.metrics.downsampler.event.metric.patterns", "");
        if (StringUtils.isNotEmpty((String)skipInterpolationMetricPatternStrings)) {
            this.LOG.info("Skipping Interpolation for patterns : " + skipInterpolationMetricPatternStrings);
            this.skipInterpolationMetricPatterns.addAll(TimelineMetricUtils.getJavaMetricPatterns((String)skipInterpolationMetricPatternStrings));
        }
        this.timelineMetricReadHelper = Boolean.valueOf(metricsConf.get("timeline.metrics.support.multiple.clusters", "false")) != false ? new TimelineMetricReadHelper(metadataManager) : new TimelineMetricReadHelper(metadataManager, true);
    }

    @Override
    protected void aggregate(ResultSet rs, long startTime, long endTime) throws SQLException, IOException {
        List<Long[]> timeSlices = AggregatorUtils.getTimeSlices(startTime - this.serverTimeShiftAdjustment, endTime - this.serverTimeShiftAdjustment, this.timeSliceIntervalMillis);
        this.appAggregator.init();
        Map<TimelineClusterMetric, MetricClusterAggregate> aggregateClusterMetrics = this.aggregateMetricsFromResultSet(rs, timeSlices);
        this.LOG.info("Saving " + aggregateClusterMetrics.size() + " metric aggregates.");
        this.hBaseAccessor.saveClusterAggregateRecords(aggregateClusterMetrics);
        this.appAggregator.cleanup();
    }

    @Override
    protected Condition prepareMetricQueryCondition(long startTime, long endTime) {
        ArrayList<String> metricNames = new ArrayList<String>();
        boolean metricNamesNotCondition = false;
        if (!StringUtils.isEmpty((String)this.skipAggrPatternStrings)) {
            this.LOG.info("Skipping aggregation for metric patterns : " + this.skipAggrPatternStrings);
            metricNames.addAll(Arrays.asList(this.skipAggrPatternStrings.split(",")));
            metricNamesNotCondition = true;
        }
        DefaultCondition condition = new DefaultCondition(metricNames, null, null, null, startTime - this.serverTimeShiftAdjustment, endTime, null, null, true);
        condition.setMetricNamesNotCondition(metricNamesNotCondition);
        condition.setNoLimit();
        condition.setFetchSize(this.resultsetFetchSize);
        condition.setStatement(String.format("SELECT UUID, SERVER_TIME, METRIC_SUM, METRIC_MAX, METRIC_MIN, METRIC_COUNT, METRICS FROM %s", "METRIC_RECORD_UUID"));
        condition.addOrderByColumn("UUID");
        condition.addOrderByColumn("SERVER_TIME");
        return condition;
    }

    Map<TimelineClusterMetric, MetricClusterAggregate> aggregateMetricsFromResultSet(ResultSet rs, List<Long[]> timeSlices) throws SQLException, IOException {
        HashMap<TimelineClusterMetric, MetricClusterAggregate> aggregateClusterMetrics = new HashMap<TimelineClusterMetric, MetricClusterAggregate>();
        TimelineMetric metric = null;
        HashMap<String, MutableInt> hostedAppCounter = new HashMap<String, MutableInt>();
        if (rs.next()) {
            metric = this.timelineMetricReadHelper.getTimelineMetricFromResultSet(rs);
            while (metric == null && rs.next()) {
                metric = this.timelineMetricReadHelper.getTimelineMetricFromResultSet(rs);
            }
            while (rs.next()) {
                TimelineMetric nextMetric = this.timelineMetricReadHelper.getTimelineMetricFromResultSet(rs);
                if (nextMetric == null) continue;
                if (metric.equalsExceptTime(nextMetric)) {
                    metric.addMetricValues((Map)nextMetric.getMetricValues());
                    continue;
                }
                int numHosts = this.processAggregateClusterMetrics(aggregateClusterMetrics, metric, timeSlices);
                if (!hostedAppCounter.containsKey(metric.getAppId())) {
                    hostedAppCounter.put(metric.getAppId(), new MutableInt(numHosts));
                } else {
                    int currentHostCount = ((MutableInt)hostedAppCounter.get(metric.getAppId())).intValue();
                    if (currentHostCount < numHosts) {
                        hostedAppCounter.put(metric.getAppId(), new MutableInt(numHosts));
                    }
                }
                metric = nextMetric;
            }
        }
        if (metric != null) {
            int numHosts = this.processAggregateClusterMetrics(aggregateClusterMetrics, metric, timeSlices);
            if (!hostedAppCounter.containsKey(metric.getAppId())) {
                hostedAppCounter.put(metric.getAppId(), new MutableInt(numHosts));
            } else {
                int currentHostCount = ((MutableInt)hostedAppCounter.get(metric.getAppId())).intValue();
                if (currentHostCount < numHosts) {
                    hostedAppCounter.put(metric.getAppId(), new MutableInt(numHosts));
                }
            }
        }
        aggregateClusterMetrics.putAll(this.appAggregator.getAggregateClusterMetrics());
        long timestamp = timeSlices.get(timeSlices.size() - 1)[1];
        this.processLiveAppCountMetrics(aggregateClusterMetrics, hostedAppCounter, timestamp);
        return aggregateClusterMetrics;
    }

    protected int processAggregateClusterMetrics(Map<TimelineClusterMetric, MetricClusterAggregate> aggregateClusterMetrics, TimelineMetric metric, List<Long[]> timeSlices) {
        TimelineMetricMetadataKey appKey = new TimelineMetricMetadataKey(metric.getMetricName(), metric.getAppId(), metric.getInstanceId());
        TimelineMetricMetadata metricMetadata = this.metadataManagerInstance.getMetadataCacheValue(appKey);
        if (metricMetadata != null && !metricMetadata.isSupportsAggregates()) {
            this.LOG.debug("Skipping cluster aggregation for " + metric.getMetricName());
            return 0;
        }
        boolean skipInterpolationForMetric = this.shouldInterpolationBeSkipped(metric.getMetricName());
        Map<TimelineClusterMetric, Double> clusterMetrics = AggregatorUtils.sliceFromTimelineMetric(metric, timeSlices, !skipInterpolationForMetric && this.interpolationEnabled);
        return this.aggregateClusterMetricsFromSlices(clusterMetrics, aggregateClusterMetrics, metric.getHostName());
    }

    protected int aggregateClusterMetricsFromSlices(Map<TimelineClusterMetric, Double> clusterMetrics, Map<TimelineClusterMetric, MetricClusterAggregate> aggregateClusterMetrics, String hostname) {
        int numHosts = 0;
        if (clusterMetrics != null && !clusterMetrics.isEmpty()) {
            for (Map.Entry<TimelineClusterMetric, Double> clusterMetricEntry : clusterMetrics.entrySet()) {
                TimelineClusterMetric clusterMetric = clusterMetricEntry.getKey();
                Double avgValue = clusterMetricEntry.getValue();
                MetricClusterAggregate aggregate = aggregateClusterMetrics.get(clusterMetric);
                if (aggregate == null) {
                    aggregate = new MetricClusterAggregate(avgValue, 1, null, avgValue, avgValue);
                    aggregateClusterMetrics.put(clusterMetric, aggregate);
                } else {
                    aggregate.updateSum(avgValue);
                    aggregate.updateNumberOfHosts(1);
                    aggregate.updateMax(avgValue);
                    aggregate.updateMin(avgValue);
                }
                numHosts = aggregate.getNumberOfHosts();
                this.appAggregator.processTimelineClusterMetric(clusterMetric, hostname, avgValue);
            }
        }
        return numHosts;
    }

    protected void processLiveAppCountMetrics(Map<TimelineClusterMetric, MetricClusterAggregate> aggregateClusterMetrics, Map<String, MutableInt> appHostsCount, long timestamp) {
        for (Map.Entry<String, MutableInt> appHostsEntry : appHostsCount.entrySet()) {
            TimelineClusterMetric timelineClusterMetric = new TimelineClusterMetric(liveHostsMetricName, appHostsEntry.getKey(), null, timestamp);
            Integer numOfHosts = appHostsEntry.getValue().intValue();
            MetricClusterAggregate metricClusterAggregate = new MetricClusterAggregate(Double.valueOf(numOfHosts.intValue()), 1, null, Double.valueOf(numOfHosts.intValue()), Double.valueOf(numOfHosts.intValue()));
            this.metadataManagerInstance.getUuid(timelineClusterMetric, true);
            aggregateClusterMetrics.put(timelineClusterMetric, metricClusterAggregate);
        }
    }

    private boolean shouldInterpolationBeSkipped(String metricName) {
        for (String pattern : this.skipInterpolationMetricPatterns) {
            if (!metricName.matches(pattern)) continue;
            return true;
        }
        return false;
    }
}

