/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ambari.metrics.core.timeline.aggregators;

import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.apache.ambari.metrics.core.timeline.PhoenixHBaseAccessor;
import org.apache.ambari.metrics.core.timeline.aggregators.AbstractTimelineAggregator;
import org.apache.ambari.metrics.core.timeline.aggregators.TimelineClusterMetric;
import org.apache.ambari.metrics.core.timeline.aggregators.TimelineMetricReadHelper;
import org.apache.ambari.metrics.core.timeline.availability.AggregationTaskRunner;
import org.apache.ambari.metrics.core.timeline.availability.MetricCollectorHAController;
import org.apache.ambari.metrics.core.timeline.discovery.TimelineMetricMetadataManager;
import org.apache.ambari.metrics.core.timeline.query.Condition;
import org.apache.ambari.metrics.core.timeline.query.DefaultCondition;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.metrics2.sink.timeline.MetricClusterAggregate;
import org.apache.hadoop.metrics2.sink.timeline.MetricHostAggregate;

public class TimelineMetricClusterAggregator
extends AbstractTimelineAggregator {
    private final TimelineMetricReadHelper readHelper;
    private final boolean isClusterPrecisionInputTable;

    public TimelineMetricClusterAggregator(AggregationTaskRunner.AGGREGATOR_NAME aggregatorName, TimelineMetricMetadataManager metricMetadataManager, PhoenixHBaseAccessor hBaseAccessor, Configuration metricsConf, String checkpointLocation, Long sleepIntervalMillis, Integer checkpointCutOffMultiplier, String hostAggregatorDisabledParam, String inputTableName, String outputTableName, Long nativeTimeRangeDelay, MetricCollectorHAController haController) {
        super(aggregatorName, hBaseAccessor, metricsConf, checkpointLocation, sleepIntervalMillis, checkpointCutOffMultiplier, hostAggregatorDisabledParam, inputTableName, outputTableName, nativeTimeRangeDelay, haController);
        this.isClusterPrecisionInputTable = inputTableName.equals("METRIC_AGGREGATE_UUID");
        this.readHelper = new TimelineMetricReadHelper(metricMetadataManager, true);
    }

    @Override
    protected Condition prepareMetricQueryCondition(long startTime, long endTime) {
        DefaultCondition condition = new DefaultCondition(null, null, null, null, startTime, endTime, null, null, true);
        condition.setNoLimit();
        condition.setFetchSize(this.resultsetFetchSize);
        String sqlStr = String.format("SELECT UUID, SERVER_TIME, METRIC_SUM, METRIC_COUNT, METRIC_MAX, METRIC_MIN FROM %s", this.tableName);
        if (this.isClusterPrecisionInputTable) {
            sqlStr = String.format("SELECT UUID, SERVER_TIME, METRIC_SUM, HOSTS_COUNT, METRIC_MAX, METRIC_MIN FROM %s", this.tableName);
        }
        condition.setStatement(sqlStr);
        condition.addOrderByColumn("UUID");
        condition.addOrderByColumn("SERVER_TIME");
        return condition;
    }

    @Override
    protected void aggregate(ResultSet rs, long startTime, long endTime) throws IOException, SQLException {
        Map<TimelineClusterMetric, MetricHostAggregate> hostAggregateMap = this.aggregateMetricsFromResultSet(rs, endTime - 1000L);
        this.LOG.info("Saving " + hostAggregateMap.size() + " metric aggregates.");
        this.hBaseAccessor.saveClusterAggregateRecordsSecond(hostAggregateMap, this.outputTableName);
    }

    private Map<TimelineClusterMetric, MetricHostAggregate> aggregateMetricsFromResultSet(ResultSet rs, long endTime) throws IOException, SQLException {
        TimelineClusterMetric existingMetric = null;
        MetricHostAggregate hostAggregate = null;
        HashMap<TimelineClusterMetric, MetricHostAggregate> hostAggregateMap = new HashMap<TimelineClusterMetric, MetricHostAggregate>();
        int perMetricCount = 0;
        while (rs.next()) {
            MetricClusterAggregate currentHostAggregate;
            TimelineClusterMetric currentMetric = this.readHelper.fromResultSet(rs);
            if (currentMetric == null) continue;
            MetricClusterAggregate metricClusterAggregate = currentHostAggregate = this.isClusterPrecisionInputTable ? this.readHelper.getMetricClusterAggregateFromResultSet(rs) : this.readHelper.getMetricClusterTimeAggregateFromResultSet(rs);
            if (existingMetric == null) {
                existingMetric = currentMetric;
                currentMetric.setTimestamp(endTime);
                hostAggregate = new MetricHostAggregate();
                hostAggregateMap.put(currentMetric, hostAggregate);
                ++perMetricCount;
            }
            if (existingMetric.equalsExceptTime(currentMetric)) {
                this.updateAggregatesFromHost(hostAggregate, currentHostAggregate);
                ++perMetricCount;
                continue;
            }
            hostAggregate.setSum(Double.valueOf(hostAggregate.getSum() / (double)(perMetricCount - 1)));
            hostAggregate.setNumberOfSamples((long)Math.round((float)hostAggregate.getNumberOfSamples() / (float)(perMetricCount - 1)));
            perMetricCount = 1;
            hostAggregate = new MetricHostAggregate();
            currentMetric.setTimestamp(endTime);
            this.updateAggregatesFromHost(hostAggregate, currentHostAggregate);
            hostAggregateMap.put(currentMetric, hostAggregate);
            existingMetric = currentMetric;
        }
        if (existingMetric != null) {
            hostAggregate.setSum(Double.valueOf(hostAggregate.getSum() / (double)(perMetricCount - 1)));
            hostAggregate.setNumberOfSamples((long)Math.round((float)hostAggregate.getNumberOfSamples() / (float)perMetricCount));
        }
        return hostAggregateMap;
    }

    private void updateAggregatesFromHost(MetricHostAggregate agg, MetricClusterAggregate currentClusterAggregate) {
        agg.updateMax(currentClusterAggregate.getMax());
        agg.updateMin(currentClusterAggregate.getMin());
        agg.updateSum(currentClusterAggregate.getSum());
        agg.updateNumberOfSamples((long)currentClusterAggregate.getNumberOfHosts());
    }
}

