/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ambari.metrics.core.timeline.aggregators;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ambari.metrics.core.timeline.TimelineMetricsFilter;
import org.apache.ambari.metrics.core.timeline.aggregators.TimelineClusterMetric;
import org.apache.ambari.metrics.core.timeline.discovery.TimelineMetricHostMetadata;
import org.apache.ambari.metrics.core.timeline.discovery.TimelineMetricMetadataKey;
import org.apache.ambari.metrics.core.timeline.discovery.TimelineMetricMetadataManager;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.metrics2.sink.timeline.MetricClusterAggregate;
import org.apache.hadoop.metrics2.sink.timeline.TimelineMetricMetadata;

public class TimelineMetricAppAggregator {
    private static final Log LOG = LogFactory.getLog(TimelineMetricAppAggregator.class);
    private final List<String> appIdsToAggregate;
    private final Map<String, TimelineMetricHostMetadata> hostMetadata;
    Map<TimelineClusterMetric, MetricClusterAggregate> aggregateClusterMetrics = new HashMap<TimelineClusterMetric, MetricClusterAggregate>();
    TimelineMetricMetadataManager metadataManagerInstance;

    public TimelineMetricAppAggregator(TimelineMetricMetadataManager metadataManager, Configuration metricsConf) {
        this.appIdsToAggregate = this.getAppIdsForHostAggregation(metricsConf);
        this.hostMetadata = metadataManager.getHostedAppsCache();
        this.metadataManagerInstance = metadataManager;
        LOG.info((Object)("AppIds configured for aggregation: " + this.appIdsToAggregate));
    }

    public void init() {
        LOG.debug((Object)"Initializing aggregation cycle.");
        this.aggregateClusterMetrics = new HashMap<TimelineClusterMetric, MetricClusterAggregate>();
    }

    public void cleanup() {
        LOG.debug((Object)"Cleanup aggregated data.");
        this.aggregateClusterMetrics = null;
    }

    public void processTimelineClusterMetric(TimelineClusterMetric clusterMetric, String hostname, Double metricValue) {
        String appId = clusterMetric.getAppId();
        if (appId == null) {
            return;
        }
        if (appId.equalsIgnoreCase("HOST")) {
            if (this.hostMetadata.containsKey(hostname)) {
                this.updateAppAggregatesFromHostMetric(clusterMetric, hostname, metricValue);
            }
        } else if (this.appIdsToAggregate.contains(appId)) {
            ConcurrentHashMap<String, String> appIds;
            TimelineMetricHostMetadata timelineMetricHostMetadata = this.hostMetadata.get(hostname);
            if (timelineMetricHostMetadata == null) {
                appIds = new ConcurrentHashMap();
                this.hostMetadata.put(hostname, new TimelineMetricHostMetadata(appIds));
            } else {
                appIds = timelineMetricHostMetadata.getHostedApps();
            }
            if (!appIds.containsKey(appId)) {
                appIds.put(appId, appId);
                LOG.info((Object)("Adding appId to hosted apps: appId = " + clusterMetric.getAppId() + ", hostname = " + hostname));
            }
        }
    }

    private void updateAppAggregatesFromHostMetric(TimelineClusterMetric clusterMetric, String hostname, Double metricValue) {
        if (this.aggregateClusterMetrics == null) {
            LOG.error((Object)"Aggregation requested without init call.");
            return;
        }
        TimelineMetricMetadataKey appKey = new TimelineMetricMetadataKey(clusterMetric.getMetricName(), "HOST", clusterMetric.getInstanceId());
        ConcurrentHashMap<String, String> apps = this.hostMetadata.get(hostname).getHostedApps();
        for (String appId : apps.keySet()) {
            TimelineClusterMetric appTimelineClusterMetric;
            MetricClusterAggregate clusterAggregate;
            TimelineMetricMetadataKey key;
            TimelineMetricMetadata hostMetricMetadata;
            if (!this.appIdsToAggregate.contains(appId)) continue;
            appKey.setAppId(appId);
            TimelineMetricMetadata appMetadata = this.metadataManagerInstance.getMetadataCacheValue(appKey);
            if (appMetadata == null && (hostMetricMetadata = this.metadataManagerInstance.getMetadataCacheValue(key = new TimelineMetricMetadataKey(clusterMetric.getMetricName(), "HOST", clusterMetric.getInstanceId()))) != null) {
                TimelineMetricMetadata timelineMetricMetadata = new TimelineMetricMetadata(clusterMetric.getMetricName(), appId, clusterMetric.getInstanceId(), hostMetricMetadata.getUnits(), hostMetricMetadata.getType(), hostMetricMetadata.getSeriesStartTime(), hostMetricMetadata.isSupportsAggregates(), TimelineMetricsFilter.acceptMetric(clusterMetric.getMetricName(), appId));
                byte[] uuid = this.metadataManagerInstance.getUuid(clusterMetric.getMetricName(), appId, clusterMetric.getInstanceId(), "", true);
                timelineMetricMetadata.setUuid(uuid);
                this.metadataManagerInstance.putIfModifiedTimelineMetricMetadata(timelineMetricMetadata);
            }
            if ((clusterAggregate = this.aggregateClusterMetrics.get(appTimelineClusterMetric = new TimelineClusterMetric(clusterMetric.getMetricName(), appId, clusterMetric.getInstanceId(), clusterMetric.getTimestamp()))) == null) {
                clusterAggregate = new MetricClusterAggregate(metricValue, 1, null, metricValue, metricValue);
                this.aggregateClusterMetrics.put(appTimelineClusterMetric, clusterAggregate);
                continue;
            }
            clusterAggregate.updateSum(metricValue);
            clusterAggregate.updateNumberOfHosts(1);
            clusterAggregate.updateMax(metricValue);
            clusterAggregate.updateMin(metricValue);
        }
    }

    public Map<TimelineClusterMetric, MetricClusterAggregate> getAggregateClusterMetrics() {
        return this.aggregateClusterMetrics;
    }

    private List<String> getAppIdsForHostAggregation(Configuration metricsConf) {
        String appIds = metricsConf.get("timeline.metrics.service.cluster.aggregator.appIds");
        if (!StringUtils.isEmpty((String)appIds)) {
            return Arrays.asList(StringUtils.stripAll((String[])appIds.split(",")));
        }
        return Collections.emptyList();
    }
}

