/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ambari.metrics.core.timeline.aggregators;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.ambari.metrics.core.timeline.PhoenixHBaseAccessor;
import org.apache.ambari.metrics.core.timeline.TimelineMetricConfiguration;
import org.apache.ambari.metrics.core.timeline.TimelineMetricDistributedCache;
import org.apache.ambari.metrics.core.timeline.aggregators.TimelineMetricAggregator;
import org.apache.ambari.metrics.core.timeline.aggregators.TimelineMetricClusterAggregator;
import org.apache.ambari.metrics.core.timeline.aggregators.TimelineMetricClusterAggregatorSecond;
import org.apache.ambari.metrics.core.timeline.aggregators.TimelineMetricClusterAggregatorSecondWithCacheSource;
import org.apache.ambari.metrics.core.timeline.aggregators.TimelineMetricFilteringHostAggregator;
import org.apache.ambari.metrics.core.timeline.aggregators.v2.TimelineMetricHostAggregator;
import org.apache.ambari.metrics.core.timeline.availability.AggregationTaskRunner;
import org.apache.ambari.metrics.core.timeline.availability.MetricCollectorHAController;
import org.apache.ambari.metrics.core.timeline.discovery.TimelineMetricMetadataManager;
import org.apache.commons.io.FilenameUtils;
import org.apache.hadoop.conf.Configuration;

public class TimelineMetricAggregatorFactory {
    private static final String HOST_AGGREGATE_MINUTE_CHECKPOINT_FILE = "timeline-metrics-host-aggregator-checkpoint";
    private static final String HOST_AGGREGATE_HOURLY_CHECKPOINT_FILE = "timeline-metrics-host-aggregator-hourly-checkpoint";
    private static final String HOST_AGGREGATE_DAILY_CHECKPOINT_FILE = "timeline-metrics-host-aggregator-daily-checkpoint";
    private static final String CLUSTER_AGGREGATOR_CHECKPOINT_FILE = "timeline-metrics-cluster-aggregator-checkpoint";
    private static final String CLUSTER_AGGREGATOR_MINUTE_CHECKPOINT_FILE = "timeline-metrics-cluster-aggregator-minute-checkpoint";
    private static final String CLUSTER_AGGREGATOR_HOURLY_CHECKPOINT_FILE = "timeline-metrics-cluster-aggregator-hourly-checkpoint";
    private static final String CLUSTER_AGGREGATOR_DAILY_CHECKPOINT_FILE = "timeline-metrics-cluster-aggregator-daily-checkpoint";

    private static boolean useGroupByAggregator(Configuration metricsConf) {
        return Boolean.parseBoolean(metricsConf.get("timeline.metrics.service.use.groupBy.aggregators", "true"));
    }

    public static TimelineMetricAggregator createTimelineMetricAggregatorMinute(PhoenixHBaseAccessor hBaseAccessor, Configuration metricsConf, TimelineMetricMetadataManager metadataManager, MetricCollectorHAController haController) {
        String checkpointDir = metricsConf.get("timeline.metrics.aggregator.checkpoint.dir", TimelineMetricConfiguration.DEFAULT_CHECKPOINT_LOCATION);
        String checkpointLocation = FilenameUtils.concat((String)checkpointDir, (String)HOST_AGGREGATE_MINUTE_CHECKPOINT_FILE);
        long sleepIntervalMillis = TimeUnit.SECONDS.toMillis(metricsConf.getLong("timeline.metrics.host.aggregator.minute.interval", 300L));
        int checkpointCutOffMultiplier = metricsConf.getInt("timeline.metrics.host.aggregator.minute.checkpointCutOffMultiplier", 3);
        String hostAggregatorDisabledParam = "timeline.metrics.host.aggregator.minute.disabled";
        String inputTableName = "METRIC_RECORD_UUID";
        String outputTableName = "METRIC_RECORD_MINUTE_UUID";
        if (TimelineMetricAggregatorFactory.useGroupByAggregator(metricsConf)) {
            return new TimelineMetricHostAggregator(AggregationTaskRunner.AGGREGATOR_NAME.METRIC_RECORD_MINUTE, hBaseAccessor, metricsConf, checkpointLocation, sleepIntervalMillis, checkpointCutOffMultiplier, hostAggregatorDisabledParam, inputTableName, outputTableName, 120000L, haController);
        }
        return new org.apache.ambari.metrics.core.timeline.aggregators.TimelineMetricHostAggregator(AggregationTaskRunner.AGGREGATOR_NAME.METRIC_RECORD_MINUTE, metadataManager, hBaseAccessor, metricsConf, checkpointLocation, sleepIntervalMillis, checkpointCutOffMultiplier, hostAggregatorDisabledParam, inputTableName, outputTableName, 120000L, haController);
    }

    public static TimelineMetricAggregator createTimelineMetricAggregatorHourly(PhoenixHBaseAccessor hBaseAccessor, Configuration metricsConf, TimelineMetricMetadataManager metadataManager, MetricCollectorHAController haController) {
        String checkpointDir = metricsConf.get("timeline.metrics.aggregator.checkpoint.dir", TimelineMetricConfiguration.DEFAULT_CHECKPOINT_LOCATION);
        String checkpointLocation = FilenameUtils.concat((String)checkpointDir, (String)HOST_AGGREGATE_HOURLY_CHECKPOINT_FILE);
        long sleepIntervalMillis = TimeUnit.SECONDS.toMillis(metricsConf.getLong("timeline.metrics.host.aggregator.hourly.interval", 3600L));
        int checkpointCutOffMultiplier = metricsConf.getInt("timeline.metrics.host.aggregator.hourly.checkpointCutOffMultiplier", 2);
        String hostAggregatorDisabledParam = "timeline.metrics.host.aggregator.hourly.disabled";
        String inputTableName = "METRIC_RECORD_MINUTE_UUID";
        String outputTableName = "METRIC_RECORD_HOURLY_UUID";
        if (TimelineMetricAggregatorFactory.useGroupByAggregator(metricsConf)) {
            return new TimelineMetricHostAggregator(AggregationTaskRunner.AGGREGATOR_NAME.METRIC_RECORD_HOURLY, hBaseAccessor, metricsConf, checkpointLocation, sleepIntervalMillis, checkpointCutOffMultiplier, hostAggregatorDisabledParam, inputTableName, outputTableName, 3600000L, haController);
        }
        return new org.apache.ambari.metrics.core.timeline.aggregators.TimelineMetricHostAggregator(AggregationTaskRunner.AGGREGATOR_NAME.METRIC_RECORD_HOURLY, metadataManager, hBaseAccessor, metricsConf, checkpointLocation, sleepIntervalMillis, checkpointCutOffMultiplier, hostAggregatorDisabledParam, inputTableName, outputTableName, 3600000L, haController);
    }

    public static TimelineMetricAggregator createTimelineMetricAggregatorDaily(PhoenixHBaseAccessor hBaseAccessor, Configuration metricsConf, TimelineMetricMetadataManager metadataManager, MetricCollectorHAController haController) {
        String checkpointDir = metricsConf.get("timeline.metrics.aggregator.checkpoint.dir", TimelineMetricConfiguration.DEFAULT_CHECKPOINT_LOCATION);
        String checkpointLocation = FilenameUtils.concat((String)checkpointDir, (String)HOST_AGGREGATE_DAILY_CHECKPOINT_FILE);
        long sleepIntervalMillis = TimeUnit.SECONDS.toMillis(metricsConf.getLong("timeline.metrics.host.aggregator.daily.interval", 86400L));
        int checkpointCutOffMultiplier = metricsConf.getInt("timeline.metrics.host.aggregator.daily.checkpointCutOffMultiplier", 1);
        String hostAggregatorDisabledParam = "timeline.metrics.host.aggregator.hourly.disabled";
        String inputTableName = "METRIC_RECORD_HOURLY_UUID";
        String outputTableName = "METRIC_RECORD_DAILY_UUID";
        if (TimelineMetricAggregatorFactory.useGroupByAggregator(metricsConf)) {
            return new TimelineMetricHostAggregator(AggregationTaskRunner.AGGREGATOR_NAME.METRIC_RECORD_DAILY, hBaseAccessor, metricsConf, checkpointLocation, sleepIntervalMillis, checkpointCutOffMultiplier, hostAggregatorDisabledParam, inputTableName, outputTableName, 3600000L, haController);
        }
        return new org.apache.ambari.metrics.core.timeline.aggregators.TimelineMetricHostAggregator(AggregationTaskRunner.AGGREGATOR_NAME.METRIC_RECORD_DAILY, metadataManager, hBaseAccessor, metricsConf, checkpointLocation, sleepIntervalMillis, checkpointCutOffMultiplier, hostAggregatorDisabledParam, inputTableName, outputTableName, 3600000L, haController);
    }

    public static TimelineMetricAggregator createTimelineClusterAggregatorSecond(PhoenixHBaseAccessor hBaseAccessor, Configuration metricsConf, TimelineMetricMetadataManager metadataManager, MetricCollectorHAController haController, TimelineMetricDistributedCache distributedCache) {
        String checkpointDir = metricsConf.get("timeline.metrics.aggregator.checkpoint.dir", TimelineMetricConfiguration.DEFAULT_CHECKPOINT_LOCATION);
        String checkpointLocation = FilenameUtils.concat((String)checkpointDir, (String)CLUSTER_AGGREGATOR_CHECKPOINT_FILE);
        long sleepIntervalMillis = TimeUnit.SECONDS.toMillis(metricsConf.getLong("timeline.metrics.cluster.aggregator.second.interval", 120L));
        long timeSliceIntervalMillis = TimeUnit.SECONDS.toMillis(metricsConf.getInt("timeline.metrics.cluster.aggregator.second.timeslice.interval", 30));
        int checkpointCutOffMultiplier = metricsConf.getInt("timeline.metrics.cluster.aggregator.second.checkpointCutOffMultiplier", 2);
        String outputTableName = "METRIC_AGGREGATE_UUID";
        String aggregatorDisabledParam = "timeline.metrics.cluster.aggregator.second.disabled";
        if (TimelineMetricConfiguration.getInstance().isCollectorInMemoryAggregationEnabled()) {
            return new TimelineMetricClusterAggregatorSecondWithCacheSource(AggregationTaskRunner.AGGREGATOR_NAME.METRIC_AGGREGATE_SECOND, metadataManager, hBaseAccessor, metricsConf, checkpointLocation, sleepIntervalMillis, checkpointCutOffMultiplier, aggregatorDisabledParam, null, outputTableName, 120000L, timeSliceIntervalMillis, haController, distributedCache);
        }
        String inputTableName = "METRIC_RECORD_UUID";
        return new TimelineMetricClusterAggregatorSecond(AggregationTaskRunner.AGGREGATOR_NAME.METRIC_AGGREGATE_SECOND, metadataManager, hBaseAccessor, metricsConf, checkpointLocation, sleepIntervalMillis, checkpointCutOffMultiplier, aggregatorDisabledParam, inputTableName, outputTableName, 120000L, timeSliceIntervalMillis, haController);
    }

    public static TimelineMetricAggregator createTimelineClusterAggregatorMinute(PhoenixHBaseAccessor hBaseAccessor, Configuration metricsConf, TimelineMetricMetadataManager metadataManager, MetricCollectorHAController haController) {
        String checkpointDir = metricsConf.get("timeline.metrics.aggregator.checkpoint.dir", TimelineMetricConfiguration.DEFAULT_CHECKPOINT_LOCATION);
        String checkpointLocation = FilenameUtils.concat((String)checkpointDir, (String)CLUSTER_AGGREGATOR_MINUTE_CHECKPOINT_FILE);
        long sleepIntervalMillis = TimeUnit.SECONDS.toMillis(metricsConf.getLong("timeline.metrics.cluster.aggregator.minute.interval", 300L));
        int checkpointCutOffMultiplier = metricsConf.getInt("timeline.metrics.cluster.aggregator.minute.checkpointCutOffMultiplier", 2);
        String inputTableName = "METRIC_AGGREGATE_UUID";
        String outputTableName = "METRIC_AGGREGATE_MINUTE_UUID";
        String aggregatorDisabledParam = "timeline.metrics.cluster.aggregator.minute.disabled";
        if (TimelineMetricAggregatorFactory.useGroupByAggregator(metricsConf)) {
            return new org.apache.ambari.metrics.core.timeline.aggregators.v2.TimelineMetricClusterAggregator(AggregationTaskRunner.AGGREGATOR_NAME.METRIC_AGGREGATE_MINUTE, hBaseAccessor, metricsConf, checkpointLocation, sleepIntervalMillis, checkpointCutOffMultiplier, aggregatorDisabledParam, inputTableName, outputTableName, 120000L, haController);
        }
        return new TimelineMetricClusterAggregator(AggregationTaskRunner.AGGREGATOR_NAME.METRIC_AGGREGATE_MINUTE, metadataManager, hBaseAccessor, metricsConf, checkpointLocation, sleepIntervalMillis, checkpointCutOffMultiplier, aggregatorDisabledParam, inputTableName, outputTableName, 120000L, haController);
    }

    public static TimelineMetricAggregator createTimelineClusterAggregatorHourly(PhoenixHBaseAccessor hBaseAccessor, Configuration metricsConf, TimelineMetricMetadataManager metadataManager, MetricCollectorHAController haController) {
        String checkpointDir = metricsConf.get("timeline.metrics.aggregator.checkpoint.dir", TimelineMetricConfiguration.DEFAULT_CHECKPOINT_LOCATION);
        String checkpointLocation = FilenameUtils.concat((String)checkpointDir, (String)CLUSTER_AGGREGATOR_HOURLY_CHECKPOINT_FILE);
        long sleepIntervalMillis = TimeUnit.SECONDS.toMillis(metricsConf.getLong("timeline.metrics.cluster.aggregator.hourly.interval", 3600L));
        int checkpointCutOffMultiplier = metricsConf.getInt("timeline.metrics.cluster.aggregator.hourly.checkpointCutOffMultiplier", 2);
        String inputTableName = "METRIC_AGGREGATE_UUID";
        String outputTableName = "METRIC_AGGREGATE_HOURLY_UUID";
        String aggregatorDisabledParam = "timeline.metrics.cluster.aggregator.hourly.disabled";
        if (TimelineMetricAggregatorFactory.useGroupByAggregator(metricsConf)) {
            return new org.apache.ambari.metrics.core.timeline.aggregators.v2.TimelineMetricClusterAggregator(AggregationTaskRunner.AGGREGATOR_NAME.METRIC_AGGREGATE_HOURLY, hBaseAccessor, metricsConf, checkpointLocation, sleepIntervalMillis, checkpointCutOffMultiplier, aggregatorDisabledParam, inputTableName, outputTableName, 120000L, haController);
        }
        return new TimelineMetricClusterAggregator(AggregationTaskRunner.AGGREGATOR_NAME.METRIC_AGGREGATE_HOURLY, metadataManager, hBaseAccessor, metricsConf, checkpointLocation, sleepIntervalMillis, checkpointCutOffMultiplier, aggregatorDisabledParam, inputTableName, outputTableName, 120000L, haController);
    }

    public static TimelineMetricAggregator createTimelineClusterAggregatorDaily(PhoenixHBaseAccessor hBaseAccessor, Configuration metricsConf, TimelineMetricMetadataManager metadataManager, MetricCollectorHAController haController) {
        String checkpointDir = metricsConf.get("timeline.metrics.aggregator.checkpoint.dir", TimelineMetricConfiguration.DEFAULT_CHECKPOINT_LOCATION);
        String checkpointLocation = FilenameUtils.concat((String)checkpointDir, (String)CLUSTER_AGGREGATOR_DAILY_CHECKPOINT_FILE);
        long sleepIntervalMillis = TimeUnit.SECONDS.toMillis(metricsConf.getLong("timeline.metrics.cluster.aggregator.daily.interval", 86400L));
        int checkpointCutOffMultiplier = metricsConf.getInt("timeline.metrics.cluster.aggregator.daily.checkpointCutOffMultiplier", 1);
        String inputTableName = "METRIC_AGGREGATE_HOURLY_UUID";
        String outputTableName = "METRIC_AGGREGATE_DAILY_UUID";
        String aggregatorDisabledParam = "timeline.metrics.cluster.aggregator.daily.disabled";
        if (TimelineMetricAggregatorFactory.useGroupByAggregator(metricsConf)) {
            return new org.apache.ambari.metrics.core.timeline.aggregators.v2.TimelineMetricClusterAggregator(AggregationTaskRunner.AGGREGATOR_NAME.METRIC_AGGREGATE_DAILY, hBaseAccessor, metricsConf, checkpointLocation, sleepIntervalMillis, checkpointCutOffMultiplier, aggregatorDisabledParam, inputTableName, outputTableName, 120000L, haController);
        }
        return new TimelineMetricClusterAggregator(AggregationTaskRunner.AGGREGATOR_NAME.METRIC_AGGREGATE_DAILY, metadataManager, hBaseAccessor, metricsConf, checkpointLocation, sleepIntervalMillis, checkpointCutOffMultiplier, aggregatorDisabledParam, inputTableName, outputTableName, 120000L, haController);
    }

    public static TimelineMetricAggregator createFilteringTimelineMetricAggregatorMinute(PhoenixHBaseAccessor hBaseAccessor, Configuration metricsConf, TimelineMetricMetadataManager metricMetadataManager, MetricCollectorHAController haController, ConcurrentHashMap<String, Long> postedAggregatedMap) {
        String checkpointDir = metricsConf.get("timeline.metrics.aggregator.checkpoint.dir", TimelineMetricConfiguration.DEFAULT_CHECKPOINT_LOCATION);
        String checkpointLocation = FilenameUtils.concat((String)checkpointDir, (String)HOST_AGGREGATE_MINUTE_CHECKPOINT_FILE);
        long sleepIntervalMillis = TimeUnit.SECONDS.toMillis(metricsConf.getLong("timeline.metrics.host.aggregator.minute.interval", 300L));
        int checkpointCutOffMultiplier = metricsConf.getInt("timeline.metrics.host.aggregator.minute.checkpointCutOffMultiplier", 3);
        String hostAggregatorDisabledParam = "timeline.metrics.host.aggregator.minute.disabled";
        String inputTableName = "METRIC_RECORD_UUID";
        String outputTableName = "METRIC_RECORD_MINUTE_UUID";
        if (TimelineMetricAggregatorFactory.useGroupByAggregator(metricsConf)) {
            return new org.apache.ambari.metrics.core.timeline.aggregators.v2.TimelineMetricFilteringHostAggregator(AggregationTaskRunner.AGGREGATOR_NAME.METRIC_RECORD_MINUTE, metricMetadataManager, hBaseAccessor, metricsConf, checkpointLocation, sleepIntervalMillis, checkpointCutOffMultiplier, hostAggregatorDisabledParam, inputTableName, outputTableName, 120000L, haController, postedAggregatedMap);
        }
        return new TimelineMetricFilteringHostAggregator(AggregationTaskRunner.AGGREGATOR_NAME.METRIC_RECORD_MINUTE, metricMetadataManager, hBaseAccessor, metricsConf, checkpointLocation, sleepIntervalMillis, checkpointCutOffMultiplier, hostAggregatorDisabledParam, inputTableName, outputTableName, 120000L, haController, postedAggregatedMap);
    }
}

