/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ambari.metrics.core.timeline.aggregators;

public class TimelineClusterMetric {
    private String metricName;
    private String appId;
    private String instanceId;
    private long timestamp;

    public TimelineClusterMetric(String metricName, String appId, String instanceId, long timestamp) {
        this.metricName = metricName;
        this.appId = appId;
        this.instanceId = instanceId;
        this.timestamp = timestamp;
    }

    public String getMetricName() {
        return this.metricName;
    }

    public String getAppId() {
        return this.appId;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimelineClusterMetric that = (TimelineClusterMetric)o;
        if (this.timestamp != that.timestamp) {
            return false;
        }
        if (this.appId != null ? !this.appId.equals(that.appId) : that.appId != null) {
            return false;
        }
        if (this.instanceId != null ? !this.instanceId.equals(that.instanceId) : that.instanceId != null) {
            return false;
        }
        return this.metricName.equals(that.metricName);
    }

    public boolean equalsExceptTime(TimelineClusterMetric metric) {
        if (!this.metricName.equals(metric.metricName)) {
            return false;
        }
        if (!this.appId.equals(metric.appId)) {
            return false;
        }
        return !(this.instanceId != null ? !this.instanceId.equals(metric.instanceId) : metric.instanceId != null);
    }

    public int hashCode() {
        int result = this.metricName.hashCode();
        result = 31 * result + (this.appId != null ? this.appId.hashCode() : 0);
        result = 31 * result + (this.instanceId != null ? this.instanceId.hashCode() : 0);
        result = 31 * result + (int)(this.timestamp ^ this.timestamp >>> 32);
        return result;
    }

    public String toString() {
        return "TimelineClusterMetric{metricName='" + this.metricName + "', appId='" + this.appId + "', instanceId='" + this.instanceId + "', timestamp=" + this.timestamp + "}";
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }
}

