/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ambari.metrics.core.timeline.aggregators;

import java.util.Arrays;

public class Function {
    public static Function DEFAULT_VALUE_FUNCTION = new Function(ReadFunction.VALUE, null);
    private static final String SUFFIX_SEPARATOR = "\\._";
    private ReadFunction readFunction = ReadFunction.VALUE;
    private PostProcessingFunction postProcessingFunction = null;

    public Function() {
    }

    public Function(ReadFunction readFunction, PostProcessingFunction ppFunction) {
        if (readFunction != null) {
            this.readFunction = readFunction;
        }
        this.postProcessingFunction = ppFunction;
    }

    public static Function fromMetricName(String metricName) {
        String[] parts = metricName.split(SUFFIX_SEPARATOR);
        ReadFunction readFunction = ReadFunction.VALUE;
        PostProcessingFunction ppFunction = null;
        if (parts.length <= 1) {
            return new Function(readFunction, null);
        }
        if (parts.length > 3) {
            throw new IllegalArgumentException("Invalid number of functions specified.");
        }
        boolean isSuccessful = false;
        for (String part : parts) {
            if (ReadFunction.isPresent(part)) {
                readFunction = ReadFunction.getFunction(part);
                isSuccessful = true;
            }
            if (!PostProcessingFunction.isPresent(part)) continue;
            ppFunction = PostProcessingFunction.getFunction(part);
            isSuccessful = true;
        }
        if (!isSuccessful) {
            throw new FunctionFormatException("Could not parse provided functions: " + Arrays.asList(parts));
        }
        return new Function(readFunction, ppFunction);
    }

    public String getSuffix() {
        return this.postProcessingFunction == null ? this.readFunction.getSuffix() : this.postProcessingFunction.getSuffix() + this.readFunction.getSuffix();
    }

    public ReadFunction getReadFunction() {
        return this.readFunction;
    }

    public String toString() {
        return "Function{readFunction=" + this.readFunction + ", postProcessingFunction=" + this.postProcessingFunction + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Function)) {
            return false;
        }
        Function function = (Function)o;
        return this.postProcessingFunction == function.postProcessingFunction && this.readFunction == function.readFunction;
    }

    public int hashCode() {
        int result = this.readFunction.hashCode();
        result = 31 * result + (this.postProcessingFunction != null ? this.postProcessingFunction.hashCode() : 0);
        return result;
    }

    public static enum ReadFunction {
        VALUE(""),
        AVG("._avg"),
        MIN("._min"),
        MAX("._max"),
        SUM("._sum");

        private final String suffix;

        private ReadFunction(String suffix) {
            this.suffix = suffix;
        }

        public String getSuffix() {
            return this.suffix;
        }

        public static boolean isPresent(String functionName) {
            try {
                ReadFunction.valueOf(functionName.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return false;
            }
            return true;
        }

        public static ReadFunction getFunction(String functionName) throws FunctionFormatException {
            if (functionName == null) {
                return VALUE;
            }
            try {
                return ReadFunction.valueOf(functionName.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                throw new FunctionFormatException("Function should be sum, avg, min, max. Got " + functionName, e);
            }
        }
    }

    public static enum PostProcessingFunction {
        NONE(""),
        RATE("._rate"),
        DIFF("._diff");

        private String suffix = "";

        private PostProcessingFunction(String suffix) {
            this.suffix = suffix;
        }

        public String getSuffix() {
            return this.suffix;
        }

        public static boolean isPresent(String functionName) {
            try {
                PostProcessingFunction.valueOf(functionName.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return false;
            }
            return true;
        }

        public static PostProcessingFunction getFunction(String functionName) throws FunctionFormatException {
            if (functionName == null) {
                return NONE;
            }
            try {
                return PostProcessingFunction.valueOf(functionName.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                throw new FunctionFormatException("Function should be ._rate", e);
            }
        }
    }

    public static class FunctionFormatException
    extends IllegalArgumentException {
        public FunctionFormatException(String message) {
            super(message);
        }

        public FunctionFormatException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

