/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ambari.metrics.core.timeline.aggregators;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.ambari.metrics.core.timeline.aggregators.CustomDownSampler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EventMetricDownSampler
implements CustomDownSampler {
    private String metricPatterns = "";
    private static final Log LOG = LogFactory.getLog(EventMetricDownSampler.class);

    public static EventMetricDownSampler fromConfig(Map<String, String> conf) {
        String metricPatterns = conf.get("timeline.metrics.downsampler.event.metric.patterns");
        return new EventMetricDownSampler(metricPatterns);
    }

    public EventMetricDownSampler(String metricPatterns) {
        this.metricPatterns = metricPatterns;
    }

    @Override
    public boolean validateConfigs() {
        return true;
    }

    @Override
    public List<String> prepareDownSamplingStatement(Long startTime, Long endTime, String tableName) {
        ArrayList<String> stmts = new ArrayList<String>();
        List<String> metricPatternList = Arrays.asList(this.metricPatterns.split(","));
        String aggregateColumnName = "METRIC_COUNT";
        if (tableName.equals("METRIC_AGGREGATE_UUID")) {
            aggregateColumnName = "HOSTS_COUNT";
        }
        for (String metricPattern : metricPatternList) {
            String metricPatternClause = "'" + metricPattern + "'";
            if (tableName.contains("RECORD")) {
                stmts.add(String.format("SELECT METRIC_NAME, HOSTNAME, APP_ID, INSTANCE_ID, %s AS SERVER_TIME, UNITS, SUM(METRIC_SUM), SUM(METRIC_COUNT), MAX(METRIC_MAX), MIN(METRIC_MIN) FROM %s WHERE METRIC_NAME LIKE %s AND SERVER_TIME > %s AND SERVER_TIME <= %s GROUP BY METRIC_NAME, HOSTNAME, APP_ID, INSTANCE_ID, UNITS", endTime, tableName, metricPatternClause, startTime, endTime));
                continue;
            }
            stmts.add(String.format("SELECT METRIC_NAME, APP_ID, INSTANCE_ID, %s AS SERVER_TIME, UNITS, SUM(METRIC_SUM), SUM(%s), MAX(METRIC_MAX), MIN(METRIC_MIN) FROM %s WHERE METRIC_NAME LIKE %s AND SERVER_TIME > %s AND SERVER_TIME <= %s GROUP BY METRIC_NAME, APP_ID, INSTANCE_ID, UNITS", endTime, aggregateColumnName, tableName, metricPatternClause, startTime, endTime));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Downsampling Stmt: " + ((Object)stmts).toString()));
        }
        return stmts;
    }
}

