/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ambari.metrics.core.timeline.aggregators;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.ambari.metrics.core.timeline.aggregators.CustomDownSampler;
import org.apache.ambari.metrics.core.timeline.aggregators.EventMetricDownSampler;
import org.apache.ambari.metrics.core.timeline.aggregators.TopNDownSampler;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;

public class DownSamplerUtils {
    public static final String downSamplerConfigPrefix = "timeline.metrics.downsampler.";
    public static final String downSamplerMetricPatternsConfig = "metric.patterns";
    public static final String topNDownSamplerKey = "topn";
    public static final String eventDownSamplerKey = "event";
    private static final Log LOG = LogFactory.getLog(DownSamplerUtils.class);

    public static List<String> getDownsampleMetricPatterns(Configuration configuration) {
        Map conf = configuration.getValByRegex("timeline.metrics.downsampler.*");
        ArrayList<String> metricPatterns = new ArrayList<String>();
        Set keys = conf.keySet();
        for (String key : keys) {
            String[] patterns;
            if (!key.endsWith(downSamplerMetricPatternsConfig)) continue;
            String patternString = (String)conf.get(key);
            for (String pattern : patterns = StringUtils.split((String)patternString, (String)",")) {
                if (!StringUtils.isNotEmpty((String)pattern)) continue;
                String trimmedPattern = pattern.trim();
                metricPatterns.add(trimmedPattern);
            }
        }
        return metricPatterns;
    }

    public static List<CustomDownSampler> getDownSamplers(Configuration configuration) {
        Map conf = configuration.getValByRegex("timeline.metrics.downsampler.*");
        ArrayList<CustomDownSampler> downSamplers = new ArrayList<CustomDownSampler>();
        Set keys = conf.keySet();
        try {
            for (String key : keys) {
                String type;
                CustomDownSampler downSampler;
                if (!key.startsWith(downSamplerConfigPrefix) || !key.endsWith(downSamplerMetricPatternsConfig) || (downSampler = DownSamplerUtils.getDownSamplerByType(type = key.split("\\.")[3], conf)) == null) continue;
                downSamplers.add(downSampler);
            }
        }
        catch (Exception e) {
            LOG.warn((Object)("Exception caught while parsing downsampler configs from ams-site : " + e.getMessage()));
        }
        return downSamplers;
    }

    public static CustomDownSampler getDownSamplerByType(String type, Map<String, String> conf) {
        if (type == null) {
            return null;
        }
        if (StringUtils.isNotEmpty((String)type) && type.equalsIgnoreCase(topNDownSamplerKey)) {
            return TopNDownSampler.fromConfig(conf);
        }
        if (StringUtils.isNotEmpty((String)type) && type.equalsIgnoreCase(eventDownSamplerKey)) {
            return EventMetricDownSampler.fromConfig(conf);
        }
        LOG.warn((Object)("Unknown downsampler requested : " + type));
        return null;
    }
}

