/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ambari.metrics.core.timeline.aggregators;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.ambari.metrics.core.timeline.aggregators.TimelineClusterMetric;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.metrics2.sink.timeline.PostProcessingUtil;
import org.apache.hadoop.metrics2.sink.timeline.TimelineMetric;

public class AggregatorUtils {
    private static final Log LOG = LogFactory.getLog(AggregatorUtils.class);

    public static double[] calculateAggregates(Map<Long, Double> metricValues) {
        double[] values = new double[4];
        double max = Double.MIN_VALUE;
        double min = Double.MAX_VALUE;
        double sum = 0.0;
        int metricCount = 0;
        if (metricValues != null && !metricValues.isEmpty()) {
            for (Double value : metricValues.values()) {
                if (value == null || value.isNaN()) continue;
                if (value > max) {
                    max = value;
                }
                if (value < min) {
                    min = value;
                }
                sum += value.doubleValue();
            }
            metricCount = metricValues.values().size();
        }
        values[0] = sum;
        values[1] = max != Double.MIN_VALUE ? max : 0.0;
        values[2] = min != Double.MAX_VALUE ? min : 0.0;
        values[3] = metricCount;
        return values;
    }

    public static Map<TimelineClusterMetric, Double> sliceFromTimelineMetric(TimelineMetric timelineMetric, List<Long[]> timeSlices, boolean interpolationEnabled) {
        if (timelineMetric.getMetricValues().isEmpty()) {
            return null;
        }
        HashMap<TimelineClusterMetric, Double> timelineClusterMetricMap = new HashMap<TimelineClusterMetric, Double>();
        Long prevTimestamp = -1L;
        TimelineClusterMetric prevMetric = null;
        int count = 0;
        double sum = 0.0;
        HashMap<Long, Double> timeSliceValueMap = new HashMap<Long, Double>();
        for (Map.Entry metric : timelineMetric.getMetricValues().entrySet()) {
            Long timestamp;
            if (metric.getValue() == null || (timestamp = AggregatorUtils.getSliceTimeForMetric(timeSlices, Long.parseLong(((Long)metric.getKey()).toString()))) == -1L) continue;
            TimelineClusterMetric clusterMetric = new TimelineClusterMetric(timelineMetric.getMetricName(), timelineMetric.getAppId(), timelineMetric.getInstanceId(), timestamp);
            if (prevTimestamp < 0L || timestamp.equals(prevTimestamp)) {
                Double newValue = (Double)metric.getValue();
                if (newValue > 0.0) {
                    sum += newValue.doubleValue();
                    ++count;
                }
            } else {
                double metricValue = count > 0 ? sum / (double)count : 0.0;
                timelineClusterMetricMap.put(prevMetric, metricValue);
                timeSliceValueMap.put(prevMetric.getTimestamp(), metricValue);
                sum = (Double)metric.getValue();
                count = sum > 0.0 ? 1 : 0;
            }
            prevTimestamp = timestamp;
            prevMetric = clusterMetric;
        }
        if (prevTimestamp > 0L) {
            double metricValue = count > 0 ? sum / (double)count : 0.0;
            timelineClusterMetricMap.put(prevMetric, metricValue);
            timeSliceValueMap.put(prevTimestamp, metricValue);
        }
        if (interpolationEnabled) {
            Map<Long, Double> interpolatedValues = AggregatorUtils.interpolateMissingPeriods(timelineMetric.getMetricValues(), timeSlices, timeSliceValueMap, timelineMetric.getType());
            for (Map.Entry<Long, Double> entry : interpolatedValues.entrySet()) {
                TimelineClusterMetric timelineClusterMetric = new TimelineClusterMetric(timelineMetric.getMetricName(), timelineMetric.getAppId(), timelineMetric.getInstanceId(), entry.getKey());
                timelineClusterMetricMap.putIfAbsent(timelineClusterMetric, entry.getValue());
            }
        }
        return timelineClusterMetricMap;
    }

    /*
     * WARNING - void declaration
     */
    private static Map<Long, Double> interpolateMissingPeriods(TreeMap<Long, Double> metricValues, List<Long[]> timeSlices, Map<Long, Double> timeSliceValueMap, String type) {
        HashMap<Long, Double> resultClusterMetricMap;
        block10: {
            block9: {
                resultClusterMetricMap = new HashMap<Long, Double>();
                if (!StringUtils.isNotEmpty((String)type) || !"COUNTER".equalsIgnoreCase(type)) break block9;
                ArrayList<Long> requiredTimestamps = new ArrayList<Long>();
                for (Long[] longArray : timeSlices) {
                    if (timeSliceValueMap.containsKey(longArray[1])) continue;
                    requiredTimestamps.add(longArray[1]);
                }
                Map interpolatedValuesMap = PostProcessingUtil.interpolate(metricValues, requiredTimestamps);
                if (interpolatedValuesMap == null) break block10;
                for (Map.Entry entry : interpolatedValuesMap.entrySet()) {
                    Double interpolatedValue = (Double)entry.getValue();
                    if (interpolatedValue != null) {
                        resultClusterMetricMap.put((Long)entry.getKey(), interpolatedValue);
                        continue;
                    }
                    LOG.debug((Object)"Cannot compute interpolated value, hence skipping.");
                }
                break block10;
            }
            Double defaultNextSeenValue = null;
            if (MapUtils.isEmpty(timeSliceValueMap) && MapUtils.isNotEmpty(metricValues)) {
                Map.Entry<Long, Double> firstEntry = metricValues.firstEntry();
                defaultNextSeenValue = firstEntry.getValue();
                LOG.debug((Object)("Found a data point outside timeslice range: " + new Date(firstEntry.getKey()) + ": " + defaultNextSeenValue));
            }
            for (int sliceNum = 0; sliceNum < timeSlices.size(); ++sliceNum) {
                Double interpolatedValue;
                void var8_14;
                Long[] longArray = timeSlices.get(sliceNum);
                if (timeSliceValueMap.containsKey(longArray[1])) continue;
                LOG.debug((Object)("Found an empty slice : " + new Date(longArray[0]) + ", " + new Date(longArray[1])));
                Object var8_15 = null;
                int index = sliceNum - 1;
                Long[] prevTimeSlice = null;
                while (var8_14 == null && index >= 0) {
                    prevTimeSlice = timeSlices.get(index--);
                    Double d = timeSliceValueMap.get(prevTimeSlice[1]);
                }
                Double nextSeenValue = null;
                index = sliceNum + 1;
                Long[] nextTimeSlice = null;
                while (nextSeenValue == null && index < timeSlices.size()) {
                    nextTimeSlice = timeSlices.get(index++);
                    nextSeenValue = timeSliceValueMap.get(nextTimeSlice[1]);
                }
                if (nextSeenValue == null) {
                    nextSeenValue = defaultNextSeenValue;
                }
                if ((interpolatedValue = PostProcessingUtil.interpolate((Long)longArray[1], (Long)(prevTimeSlice != null ? prevTimeSlice[1] : null), (Double)var8_14, (Long)(nextTimeSlice != null ? nextTimeSlice[1] : null), (Double)nextSeenValue)) != null) {
                    LOG.debug((Object)("Interpolated value : " + interpolatedValue));
                    resultClusterMetricMap.put(longArray[1], interpolatedValue);
                    continue;
                }
                LOG.debug((Object)"Cannot compute interpolated value, hence skipping.");
            }
        }
        return resultClusterMetricMap;
    }

    public static Long getSliceTimeForMetric(List<Long[]> timeSlices, Long timestamp) {
        for (Long[] timeSlice : timeSlices) {
            if (timestamp < timeSlice[0] || timestamp >= timeSlice[1]) continue;
            return timeSlice[1];
        }
        return -1L;
    }

    public static List<Long[]> getTimeSlices(long startTime, long endTime, long timeSliceIntervalMillis) {
        ArrayList<Long[]> timeSlices = new ArrayList<Long[]>();
        for (long sliceStartTime = startTime; sliceStartTime < endTime; sliceStartTime += timeSliceIntervalMillis) {
            timeSlices.add(new Long[]{sliceStartTime, sliceStartTime + timeSliceIntervalMillis});
        }
        return timeSlices;
    }

    public static long getRoundedCheckPointTimeMillis(long referenceTime, long aggregatorPeriod) {
        return referenceTime - referenceTime % aggregatorPeriod;
    }

    public static long getRoundedAggregateTimeMillis(long aggregatorPeriod) {
        long currentTime = System.currentTimeMillis();
        return currentTime - currentTime % aggregatorPeriod;
    }
}

