/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ambari.metrics.core.timeline;

import com.google.common.collect.Multimap;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.TreeMap;
import org.apache.ambari.metrics.core.timeline.FunctionUtils;
import org.apache.ambari.metrics.core.timeline.PhoenixHBaseAccessor;
import org.apache.ambari.metrics.core.timeline.aggregators.Function;
import org.apache.ambari.metrics.core.timeline.query.Condition;
import org.apache.hadoop.metrics2.sink.timeline.SingleValuedTimelineMetric;
import org.apache.hadoop.metrics2.sink.timeline.TimelineMetric;
import org.apache.hadoop.metrics2.sink.timeline.TimelineMetrics;

class TransientMetricReadHelper {
    TransientMetricReadHelper() {
    }

    static void appendMetricFromResultSet(TimelineMetrics metrics, Condition condition, Multimap<String, List<Function>> metricFunctions, ResultSet rs) throws SQLException, IOException {
        String metricName = rs.getString("METRIC_NAME");
        Collection<List<Function>> functionList = FunctionUtils.findMetricFunctions(metricFunctions, metricName);
        for (List<Function> functions : functionList) {
            if (functions != null && !functions.isEmpty()) {
                if (functions.size() > 1) {
                    throw new IllegalArgumentException("Multiple aggregate functions not supported.");
                }
                for (Function f : functions) {
                    if (f.getReadFunction() == Function.ReadFunction.VALUE) {
                        TransientMetricReadHelper.getTimelineMetricsFromResultSet(metrics, f, condition, rs);
                        continue;
                    }
                    SingleValuedTimelineMetric metric = TransientMetricReadHelper.getAggregatedTimelineMetricFromResultSet(rs, f);
                    if (condition.isGrouped()) {
                        metrics.addOrMergeTimelineMetric(metric);
                        continue;
                    }
                    metrics.getMetrics().add(metric.getTimelineMetric());
                }
                continue;
            }
            TransientMetricReadHelper.getTimelineMetricsFromResultSet(metrics, null, condition, rs);
        }
    }

    private static TimelineMetric getTimelineMetricFromResultSet(ResultSet rs) throws SQLException, IOException {
        TimelineMetric metric = TransientMetricReadHelper.getTimelineMetricCommonsFromResultSet(rs);
        TreeMap<Long, Double> sortedByTimeMetrics = PhoenixHBaseAccessor.readMetricFromJSON(rs.getString("METRICS"));
        metric.setMetricValues(sortedByTimeMetrics);
        return metric;
    }

    private static TimelineMetric getTimelineMetricCommonsFromResultSet(ResultSet rs) throws SQLException {
        TimelineMetric metric = new TimelineMetric();
        metric.setMetricName(rs.getString("METRIC_NAME"));
        metric.setAppId(rs.getString("APP_ID"));
        metric.setInstanceId(rs.getString("INSTANCE_ID"));
        metric.setHostName(rs.getString("HOSTNAME"));
        metric.setStartTime(rs.getLong("SERVER_TIME"));
        metric.setType(rs.getString("UNITS"));
        return metric;
    }

    private static void getTimelineMetricsFromResultSet(TimelineMetrics metrics, Function f, Condition condition, ResultSet rs) throws SQLException, IOException {
        TimelineMetric metric = TransientMetricReadHelper.getTimelineMetricFromResultSet(rs);
        if (f != null && f.getSuffix() != null) {
            metric.setMetricName(metric.getMetricName() + f.getSuffix());
        }
        if (condition.isGrouped()) {
            metrics.addOrMergeTimelineMetric(metric);
        } else {
            metrics.getMetrics().add(metric);
        }
    }

    private static SingleValuedTimelineMetric getAggregatedTimelineMetricFromResultSet(ResultSet rs, Function f) throws SQLException, IOException {
        Function function = f != null ? f : Function.DEFAULT_VALUE_FUNCTION;
        SingleValuedTimelineMetric metric = new SingleValuedTimelineMetric(rs.getString("METRIC_NAME") + function.getSuffix(), rs.getString("APP_ID"), rs.getString("INSTANCE_ID"), rs.getString("HOSTNAME"), rs.getLong("SERVER_TIME"));
        metric.setSingleTimeseriesValue(Long.valueOf(rs.getLong("SERVER_TIME")), Double.valueOf(switch (function.getReadFunction()) {
            case Function.ReadFunction.AVG -> rs.getDouble("METRIC_SUM") / (double)rs.getInt("METRIC_COUNT");
            case Function.ReadFunction.MIN -> rs.getDouble("METRIC_MIN");
            case Function.ReadFunction.MAX -> rs.getDouble("METRIC_MAX");
            case Function.ReadFunction.SUM -> rs.getDouble("METRIC_SUM");
            default -> rs.getDouble("METRIC_SUM") / (double)rs.getInt("METRIC_COUNT");
        }));
        return metric;
    }
}

