/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ambari.metrics.core.timeline;

import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import javax.cache.Cache;
import javax.cache.configuration.Factory;
import javax.cache.expiry.CreatedExpiryPolicy;
import javax.cache.expiry.Duration;
import org.apache.ambari.metrics.core.timeline.TimelineMetricConfiguration;
import org.apache.ambari.metrics.core.timeline.TimelineMetricDistributedCache;
import org.apache.ambari.metrics.core.timeline.TimelineMetricsFilter;
import org.apache.ambari.metrics.core.timeline.aggregators.AggregatorUtils;
import org.apache.ambari.metrics.core.timeline.aggregators.TimelineClusterMetric;
import org.apache.ambari.metrics.core.timeline.discovery.TimelineMetricHostMetadata;
import org.apache.ambari.metrics.core.timeline.discovery.TimelineMetricMetadataKey;
import org.apache.ambari.metrics.core.timeline.discovery.TimelineMetricMetadataManager;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.metrics2.sink.timeline.MetricClusterAggregate;
import org.apache.hadoop.metrics2.sink.timeline.TimelineMetric;
import org.apache.hadoop.metrics2.sink.timeline.TimelineMetricMetadata;
import org.apache.hadoop.metrics2.sink.timeline.TimelineMetricUtils;
import org.apache.hadoop.metrics2.sink.timeline.availability.MetricCollectorHAHelper;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.Ignition;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMetrics;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.QueryCursor;
import org.apache.ignite.cache.query.ScanQuery;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.lang.IgniteBiPredicate;
import org.apache.ignite.spi.discovery.DiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.TcpDiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.ipfinder.TcpDiscoveryIpFinder;
import org.apache.ignite.spi.discovery.tcp.ipfinder.vm.TcpDiscoveryVmIpFinder;
import org.apache.ignite.ssl.SslContextFactory;

public class TimelineMetricsIgniteCache
implements TimelineMetricDistributedCache {
    private static final Log LOG = LogFactory.getLog(TimelineMetricsIgniteCache.class);
    private IgniteCache<TimelineClusterMetric, MetricClusterAggregate> igniteCache;
    private long cacheSliceIntervalMillis;
    private boolean interpolationEnabled;
    private List<String> skipAggrPatternStrings = new ArrayList<String>();
    private List<String> appIdsToAggregate;
    private TimelineMetricMetadataManager metricMetadataManager;

    public TimelineMetricsIgniteCache(TimelineMetricMetadataManager metricMetadataManager) throws MalformedURLException, URISyntaxException {
        String transientMetricPatterns;
        TimelineMetricConfiguration timelineMetricConfiguration = TimelineMetricConfiguration.getInstance();
        Configuration metricConf = timelineMetricConfiguration.getMetricsConf();
        Configuration sslConf = timelineMetricConfiguration.getMetricsSslConf();
        IgniteConfiguration igniteConfiguration = new IgniteConfiguration();
        this.metricMetadataManager = metricMetadataManager;
        if (metricConf.get("timeline.metrics.service.http.policy") != null && metricConf.get("timeline.metrics.service.http.policy").equalsIgnoreCase("HTTPS_ONLY")) {
            SslContextFactory sslContextFactory = new SslContextFactory();
            String keyStorePath = sslConf.get("ssl.server.keystore.location");
            String keyStorePassword = sslConf.get("ssl.server.keystore.password");
            String trustStorePath = sslConf.get("ssl.server.truststore.location");
            String trustStorePassword = sslConf.get("ssl.server.truststore.password");
            sslContextFactory.setKeyStoreFilePath(keyStorePath);
            sslContextFactory.setKeyStorePassword(keyStorePassword.toCharArray());
            sslContextFactory.setTrustStoreFilePath(trustStorePath);
            sslContextFactory.setTrustStorePassword(trustStorePassword.toCharArray());
            igniteConfiguration.setSslContextFactory((Factory)sslContextFactory);
        }
        this.appIdsToAggregate = timelineMetricConfiguration.getAppIdsForHostAggregation();
        this.interpolationEnabled = Boolean.parseBoolean(metricConf.get("timeline.metrics.cluster.aggregator.interpolation.enabled", "true"));
        this.cacheSliceIntervalMillis = TimeUnit.SECONDS.toMillis(metricConf.getInt("timeline.metrics.cluster.aggregator.second.timeslice.interval", 30));
        Long aggregationInterval = metricConf.getLong("timeline.metrics.cluster.aggregator.second.interval", 120L);
        String filteredMetricPatterns = metricConf.get("timeline.metrics.cluster.aggregation.sql.filters");
        if (StringUtils.isNotEmpty((String)filteredMetricPatterns)) {
            LOG.info((Object)("Skipping in memory cluster aggregation for metric patterns : " + filteredMetricPatterns));
            this.skipAggrPatternStrings.addAll(TimelineMetricUtils.getJavaMetricPatterns((String)filteredMetricPatterns));
        }
        if (StringUtils.isNotEmpty((String)(transientMetricPatterns = timelineMetricConfiguration.getTransientMetricPatterns()))) {
            LOG.info((Object)("Skipping in memory cluster aggregation for transient metric patterns : " + transientMetricPatterns));
            this.skipAggrPatternStrings.addAll(TimelineMetricUtils.getJavaMetricPatterns((String)transientMetricPatterns));
        }
        if (metricConf.get("timeline.metrics.collector.ignite.nodes.list") != null) {
            TcpDiscoverySpi discoverySpi = new TcpDiscoverySpi();
            TcpDiscoveryVmIpFinder ipFinder = new TcpDiscoveryVmIpFinder();
            ipFinder.setAddresses(Arrays.asList(metricConf.get("timeline.metrics.collector.ignite.nodes.list").split(",")));
            LOG.info((Object)("Setting ignite nodes to : " + ipFinder.getRegisteredAddresses()));
            discoverySpi.setIpFinder((TcpDiscoveryIpFinder)ipFinder);
            igniteConfiguration.setDiscoverySpi((DiscoverySpi)discoverySpi);
        } else {
            String zkQuorum;
            String zkClientPort = timelineMetricConfiguration.getClusterZKClientPort();
            String zkConnectionURL = timelineMetricConfiguration.getZkConnectionUrl(zkClientPort, zkQuorum = timelineMetricConfiguration.getClusterZKQuorum());
            MetricCollectorHAHelper metricCollectorHAHelper = new MetricCollectorHAHelper(zkConnectionURL, 5, 200);
            Collection liveCollectors = metricCollectorHAHelper.findLiveCollectorHostsFromZNode();
            if (liveCollectors != null && !liveCollectors.isEmpty()) {
                TcpDiscoverySpi discoverySpi = new TcpDiscoverySpi();
                TcpDiscoveryVmIpFinder ipFinder = new TcpDiscoveryVmIpFinder();
                ipFinder.setAddresses(liveCollectors);
                LOG.info((Object)("Setting ignite nodes to : " + ipFinder.getRegisteredAddresses()));
                discoverySpi.setIpFinder((TcpDiscoveryIpFinder)ipFinder);
                igniteConfiguration.setDiscoverySpi((DiscoverySpi)discoverySpi);
            }
        }
        CacheConfiguration cacheConfiguration = new CacheConfiguration();
        cacheConfiguration.setName("metrics_cache");
        cacheConfiguration.setCacheMode(CacheMode.PARTITIONED);
        cacheConfiguration.setBackups(metricConf.getInt("timeline.metrics.collector.ignite.nodes.backups", 1));
        cacheConfiguration.setRebalanceThrottle(0L);
        cacheConfiguration.setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL);
        cacheConfiguration.setEagerTtl(true);
        cacheConfiguration.setExpiryPolicyFactory(CreatedExpiryPolicy.factoryOf((Duration)new Duration(TimeUnit.SECONDS, aggregationInterval * 3L)));
        Ignite igniteNode = Ignition.start((IgniteConfiguration)igniteConfiguration);
        this.igniteCache = igniteNode.getOrCreateCache(cacheConfiguration);
    }

    @Override
    public Map<TimelineClusterMetric, MetricClusterAggregate> evictMetricAggregates(Long startTime, Long endTime) {
        HashMap<TimelineClusterMetric, MetricClusterAggregate> aggregatedMetricsMap = new HashMap<TimelineClusterMetric, MetricClusterAggregate>();
        IgniteBiPredicate & Serializable filter = (IgniteBiPredicate & Serializable)(key, value) -> key.getTimestamp() > startTime && key.getTimestamp() <= endTime;
        try (QueryCursor cursor = this.igniteCache.query((Query)new ScanQuery((IgniteBiPredicate)filter));){
            for (Cache.Entry e : cursor) {
                aggregatedMetricsMap.put((TimelineClusterMetric)e.getKey(), (MetricClusterAggregate)e.getValue());
            }
        }
        this.igniteCache.removeAllAsync(aggregatedMetricsMap.keySet());
        return aggregatedMetricsMap;
    }

    @Override
    public void putMetrics(Collection<TimelineMetric> elements) {
        Map<String, TimelineMetricHostMetadata> hostMetadata = this.metricMetadataManager.getHostedAppsCache();
        for (TimelineMetric metric : elements) {
            if (this.shouldBeSkipped(metric.getMetricName())) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)String.format("Skipping %s metric from being aggregated", metric.getMetricName()));
                continue;
            }
            List<Long[]> timeSlices = AggregatorUtils.getTimeSlices(AggregatorUtils.getRoundedCheckPointTimeMillis((Long)metric.getMetricValues().firstKey(), this.cacheSliceIntervalMillis), (Long)metric.getMetricValues().lastKey(), this.cacheSliceIntervalMillis);
            Map<TimelineClusterMetric, Double> slicedClusterMetrics = AggregatorUtils.sliceFromTimelineMetric(metric, timeSlices, this.interpolationEnabled);
            if (slicedClusterMetrics == null) continue;
            for (Map.Entry<TimelineClusterMetric, Double> metricDoubleEntry : slicedClusterMetrics.entrySet()) {
                ConcurrentHashMap<String, String> appIdsMap;
                MetricClusterAggregate newMetricClusterAggregate = new MetricClusterAggregate(metricDoubleEntry.getValue(), 1, null, metricDoubleEntry.getValue(), metricDoubleEntry.getValue());
                this.putMetricIntoCache(metricDoubleEntry.getKey(), newMetricClusterAggregate);
                if (hostMetadata == null) continue;
                if (metric.getAppId().equalsIgnoreCase("HOST")) {
                    if (!hostMetadata.containsKey(metric.getHostName())) continue;
                    this.updateAppAggregatesFromHostMetric(metricDoubleEntry.getKey(), newMetricClusterAggregate, hostMetadata.get(metric.getHostName()));
                    continue;
                }
                if (!this.appIdsToAggregate.contains(metric.getAppId())) continue;
                TimelineMetricHostMetadata timelineMetricHostMetadata = hostMetadata.get(metric.getHostName());
                if (timelineMetricHostMetadata == null) {
                    appIdsMap = new ConcurrentHashMap();
                    hostMetadata.put(metric.getHostName(), new TimelineMetricHostMetadata(appIdsMap));
                } else {
                    appIdsMap = timelineMetricHostMetadata.getHostedApps();
                }
                if (appIdsMap.containsKey(metric.getAppId())) continue;
                appIdsMap.put(metric.getAppId(), metric.getAppId());
                LOG.info((Object)("Adding appId to hosted apps: appId = " + metric.getAppId() + ", hostname = " + metric.getHostName()));
            }
        }
    }

    private void updateAppAggregatesFromHostMetric(TimelineClusterMetric key, MetricClusterAggregate newMetricClusterAggregate, TimelineMetricHostMetadata timelineMetricHostMetadata) {
        for (String appId : timelineMetricHostMetadata.getHostedApps().keySet()) {
            TimelineMetricMetadataKey metricMetadataKey;
            if (!this.appIdsToAggregate.contains(appId)) continue;
            TimelineClusterMetric timelineClusterMetric = new TimelineClusterMetric(key.getMetricName(), appId, key.getInstanceId(), key.getTimestamp());
            TimelineMetricMetadataKey metadataKey = new TimelineMetricMetadataKey(timelineClusterMetric.getMetricName(), appId, timelineClusterMetric.getInstanceId());
            TimelineMetricMetadata metricMetadata = this.metricMetadataManager.getMetadataCacheValue(metadataKey);
            if ((metricMetadata == null || metricMetadata.getUuid() == null) && (metricMetadata = this.metricMetadataManager.getMetadataCacheValue(metricMetadataKey = new TimelineMetricMetadataKey(timelineClusterMetric.getMetricName(), "HOST", timelineClusterMetric.getInstanceId()))) != null) {
                TimelineMetricMetadata timelineMetricMetadata = new TimelineMetricMetadata(timelineClusterMetric.getMetricName(), appId, timelineClusterMetric.getInstanceId(), metricMetadata.getUnits(), metricMetadata.getType(), metricMetadata.getSeriesStartTime(), metricMetadata.isSupportsAggregates(), TimelineMetricsFilter.acceptMetric(timelineClusterMetric.getMetricName(), appId));
                byte[] uuid = this.metricMetadataManager.getUuid(timelineClusterMetric.getMetricName(), appId, timelineClusterMetric.getInstanceId(), "", true);
                timelineMetricMetadata.setUuid(uuid);
                this.metricMetadataManager.putIfModifiedTimelineMetricMetadata(timelineMetricMetadata);
            }
            this.putMetricIntoCache(timelineClusterMetric, newMetricClusterAggregate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putMetricIntoCache(TimelineClusterMetric metricKey, MetricClusterAggregate metricValue) {
        Lock lock = this.igniteCache.lock((Object)metricKey);
        lock.lock();
        try {
            MetricClusterAggregate metricClusterAggregateFromCache = (MetricClusterAggregate)this.igniteCache.get((Object)metricKey);
            if (metricClusterAggregateFromCache == null) {
                this.igniteCache.put((Object)metricKey, (Object)metricValue);
            } else {
                metricClusterAggregateFromCache.updateAggregates(metricValue);
                this.igniteCache.put((Object)metricKey, (Object)metricClusterAggregateFromCache);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Exception : ", (Throwable)e);
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public Map<String, Double> getPointInTimeCacheMetrics() {
        CacheMetrics clusterIgniteMetrics = this.igniteCache.metrics();
        HashMap<String, Double> metricsMap = new HashMap<String, Double>();
        metricsMap.put("Cluster_AverageGetTime", Double.valueOf(clusterIgniteMetrics.getAverageGetTime()));
        metricsMap.put("Cluster_AveragePutTime", Double.valueOf(clusterIgniteMetrics.getAveragePutTime()));
        metricsMap.put("Cluster_KeySize", Double.valueOf(clusterIgniteMetrics.getKeySize()));
        metricsMap.put("Cluster_OffHeapAllocatedSize", Double.valueOf(clusterIgniteMetrics.getOffHeapAllocatedSize()));
        return metricsMap;
    }

    private boolean shouldBeSkipped(String metricName) {
        for (String pattern : this.skipAggrPatternStrings) {
            if (!metricName.matches(pattern)) continue;
            return true;
        }
        return false;
    }
}

