/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ambari.metrics.core.timeline;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.ambari.metrics.core.timeline.TimelineMetricConfiguration;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.metrics2.sink.timeline.TimelineMetric;

public class TimelineMetricsFilter {
    private static Set<String> whitelistedMetrics;
    private static Set<Pattern> whitelistedMetricPatterns;
    private static Set<String> whitelistedApps;
    private static Set<String> blacklistedMetrics;
    private static Set<Pattern> blacklistedPatterns;
    private static Set<String> blacklistedApps;
    private static String patternPrefix;
    private static Set<String> amshbaseWhitelist;
    private static final Log LOG;

    public static void initializeMetricFilter(TimelineMetricConfiguration configuration) {
        String appsWhitelist;
        String appsBlacklist;
        String blacklistFile;
        Configuration metricsConf = null;
        try {
            metricsConf = configuration.getMetricsConf();
        }
        catch (Exception e) {
            LOG.error((Object)"Error fetching metrics configuration for getting whitelisting information");
            return;
        }
        whitelistedMetrics = new HashSet<String>();
        whitelistedMetricPatterns = new HashSet<Pattern>();
        blacklistedApps = new HashSet<String>();
        whitelistedApps = new HashSet<String>();
        blacklistedMetrics = new HashSet<String>();
        blacklistedPatterns = new HashSet<Pattern>();
        blacklistedApps = new HashSet<String>();
        amshbaseWhitelist = new HashSet<String>();
        if (configuration.isWhitelistingEnabled()) {
            String whitelistFile = metricsConf.get("timeline.metrics.whitelist.file", "/etc/obdp-metrics-collector/conf/metrics_whitelist");
            TimelineMetricsFilter.readMetricWhitelistFromFile(whitelistedMetrics, whitelistedMetricPatterns, whitelistFile);
            LOG.info((Object)("Whitelisting " + whitelistedMetrics.size() + " metrics and " + whitelistedMetricPatterns.size() + " metric patterns"));
            LOG.debug((Object)("Whitelisted metrics : " + Arrays.toString(whitelistedMetrics.toArray())));
        }
        if (!StringUtils.isEmpty((String)(blacklistFile = metricsConf.get("timeline.metrics.blacklist.file", "")))) {
            TimelineMetricsFilter.readMetricWhitelistFromFile(blacklistedMetrics, blacklistedPatterns, blacklistFile);
            LOG.info((Object)("Blacklisting " + blacklistedMetrics.size() + " metrics"));
            LOG.debug((Object)("Blacklisted metrics : " + Arrays.toString(blacklistedMetrics.toArray())));
        }
        if (!StringUtils.isEmpty((String)(appsBlacklist = metricsConf.get("timeline.metrics.apps.blacklist", "")))) {
            for (String app : appsBlacklist.split(",")) {
                blacklistedApps.add(app);
            }
            LOG.info((Object)("Blacklisted apps : " + blacklistedApps.toString()));
        }
        if (!StringUtils.isEmpty((String)(appsWhitelist = metricsConf.get("timeline.metrics.apps.whitelist", "")))) {
            for (String app : appsWhitelist.split(",")) {
                whitelistedApps.add(app);
            }
            LOG.info((Object)("Whitelisted apps : " + whitelistedApps.toString()));
        }
        if (CollectionUtils.isNotEmpty(amshbaseWhitelist = configuration.getAmshbaseWhitelist())) {
            LOG.info((Object)("Whitelisting " + amshbaseWhitelist.size() + " ams-hbase metrics"));
        }
    }

    private static void readMetricWhitelistFromFile(Set<String> metricList, Set<Pattern> patternList, String whitelistFile) {
        BufferedReader br = null;
        try (FileInputStream fstream = new FileInputStream(whitelistFile);){
            String strLine;
            br = new BufferedReader(new InputStreamReader(fstream));
            while ((strLine = br.readLine()) != null) {
                if (StringUtils.isEmpty((String)(strLine = strLine.trim()))) continue;
                if (strLine.startsWith(patternPrefix)) {
                    patternList.add(Pattern.compile(strLine.substring(patternPrefix.length())));
                    continue;
                }
                metricList.add(strLine);
            }
        }
        catch (IOException ioEx) {
            LOG.error((Object)"Unable to parse metric file", (Throwable)ioEx);
        }
    }

    public static boolean acceptMetric(String metricName, String appId) {
        TimelineMetric timelineMetric = new TimelineMetric();
        timelineMetric.setAppId(appId);
        timelineMetric.setMetricName(metricName);
        return TimelineMetricsFilter.acceptMetric(timelineMetric);
    }

    public static boolean acceptMetric(TimelineMetric metric) {
        Matcher m;
        String appId = metric.getAppId();
        String metricName = metric.getMetricName();
        if (CollectionUtils.isNotEmpty(blacklistedApps) && blacklistedApps.contains(appId)) {
            return false;
        }
        if (CollectionUtils.isNotEmpty(blacklistedMetrics) || CollectionUtils.isNotEmpty(blacklistedPatterns)) {
            if (blacklistedMetrics.contains(metricName)) {
                return false;
            }
            for (Pattern p : blacklistedPatterns) {
                m = p.matcher(metricName);
                if (!m.find()) continue;
                blacklistedMetrics.add(metricName);
                return false;
            }
        }
        if ("ams-hbase".equals(appId) && CollectionUtils.isNotEmpty(amshbaseWhitelist)) {
            return amshbaseWhitelist.contains(metric.getMetricName());
        }
        if (CollectionUtils.isNotEmpty(whitelistedApps) && whitelistedApps.contains(appId)) {
            return true;
        }
        if (CollectionUtils.isEmpty(whitelistedMetrics) && CollectionUtils.isEmpty(whitelistedMetricPatterns)) {
            return true;
        }
        if (whitelistedMetrics.contains(metricName)) {
            return true;
        }
        for (Pattern p : whitelistedMetricPatterns) {
            m = p.matcher(metricName);
            if (!m.find()) continue;
            whitelistedMetrics.add(metricName);
            return true;
        }
        return false;
    }

    static {
        patternPrefix = "._p_";
        LOG = LogFactory.getLog(TimelineMetricsFilter.class);
    }
}

