/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ambari.metrics.core.timeline;

import java.util.Collections;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.ambari.metrics.core.timeline.HBaseTimelineMetricsService;
import org.apache.ambari.metrics.core.timeline.TimelineMetricConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.metrics2.sink.timeline.Precision;
import org.apache.hadoop.metrics2.sink.timeline.TimelineMetric;
import org.apache.hadoop.metrics2.sink.timeline.TimelineMetrics;
import org.apache.hadoop.util.ExitUtil;

public class TimelineMetricStoreWatcher
implements Runnable {
    private static final Log LOG = LogFactory.getLog(TimelineMetricStoreWatcher.class);
    private static final String FAKE_METRIC_NAME = "TimelineMetricStoreWatcher.FakeMetric";
    private static final String FAKE_HOSTNAME = "fakehostname";
    private static final String FAKE_APP_ID = "timeline_metric_store_watcher";
    private static int failures = 0;
    private final TimelineMetricConfiguration configuration;
    private HBaseTimelineMetricsService timelineMetricStore;
    private ExecutorService executor = Executors.newSingleThreadExecutor();

    public TimelineMetricStoreWatcher(HBaseTimelineMetricsService timelineMetricStore, TimelineMetricConfiguration configuration) {
        this.timelineMetricStore = timelineMetricStore;
        this.configuration = configuration;
    }

    @Override
    public void run() {
        if (this.checkMetricStore()) {
            failures = 0;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Successfully got metrics from TimelineMetricStore");
            }
        } else {
            LOG.info((Object)("Failed to get metrics from TimelineMetricStore, attempt = " + failures));
            ++failures;
        }
        if (failures >= this.configuration.getTimelineMetricsServiceWatcherMaxFailures()) {
            String msg = "Error getting metrics from TimelineMetricStore. Shutting down by TimelineMetricStoreWatcher.";
            LOG.fatal((Object)msg);
            ExitUtil.terminate((int)-1, (String)msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkMetricStore() {
        long startTime = System.currentTimeMillis();
        int delay = this.configuration.getTimelineMetricsServiceWatcherDelay();
        int timeout = this.configuration.getTimelineMetricsServiceWatcherTimeout();
        TimelineMetric fakeMetric = new TimelineMetric();
        fakeMetric.setMetricName(FAKE_METRIC_NAME);
        fakeMetric.setHostName(FAKE_HOSTNAME);
        fakeMetric.setAppId(FAKE_APP_ID);
        fakeMetric.setStartTime(startTime);
        fakeMetric.getMetricValues().put(startTime, 0.0);
        TimelineMetrics metrics = new TimelineMetrics();
        metrics.setMetrics(Collections.singletonList(fakeMetric));
        Callable<TimelineMetric> task = () -> {
            this.timelineMetricStore.putMetricsSkipCache(metrics);
            TimelineMetrics timelineMetrics = this.timelineMetricStore.getTimelineMetrics(Collections.singletonList(FAKE_METRIC_NAME), Collections.singletonList(FAKE_HOSTNAME), FAKE_APP_ID, null, startTime - (long)(delay * 2 * 1000), startTime + (long)(delay * 2 * 1000), Precision.SECONDS, 1, true, null, null);
            return (TimelineMetric)timelineMetrics.getMetrics().get(0);
        };
        Future<TimelineMetric> future = this.executor.submit(task);
        TimelineMetric timelineMetric = null;
        try {
            timelineMetric = future.get(timeout, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            future.cancel(true);
        }
        return timelineMetric != null;
    }
}

