/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ambari.metrics.core.timeline;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.ambari.metrics.core.timeline.MetricApp;
import org.apache.ambari.metrics.core.timeline.aggregators.TimelineClusterMetric;
import org.apache.ambari.metrics.core.timeline.discovery.TimelineMetricMetadataManager;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;

public class TimelineMetricSplitPointComputer {
    private static final Log LOG = LogFactory.getLog(TimelineMetricSplitPointComputer.class);
    private Set<String> masterComponents = new HashSet<String>();
    private Set<String> slaveComponents = new HashSet<String>();
    private static final int MINIMUM_PRECISION_TABLE_REGIONS = 4;
    private static final int MINIMUM_AGGREGATE_TABLE_REGIONS = 2;
    private static final int OTHER_TABLE_STATIC_REGIONS = 8;
    private static final int SLAVE_EQUIDISTANT_POINTS = 50;
    private static final int MASTER_EQUIDISTANT_POINTS = 5;
    private double hbaseTotalHeapsize;
    private double hbaseMemstoreUpperLimit;
    private double hbaseMemstoreFlushSize;
    private TimelineMetricMetadataManager timelineMetricMetadataManager = null;
    private List<byte[]> precisionSplitPoints = new ArrayList<byte[]>();
    private List<byte[]> aggregateSplitPoints = new ArrayList<byte[]>();

    public TimelineMetricSplitPointComputer(Configuration metricsConf, Configuration hbaseConf, TimelineMetricMetadataManager timelineMetricMetadataManager) {
        String componentsString = metricsConf.get("timeline.metrics.initial.configured.master.components", "");
        if (StringUtils.isNotEmpty((String)componentsString)) {
            this.masterComponents.addAll(Arrays.asList(componentsString.split(",")));
        }
        if (StringUtils.isNotEmpty((String)(componentsString = metricsConf.get("timeline.metrics.initial.configured.slave.components", "")))) {
            this.slaveComponents.addAll(Arrays.asList(componentsString.split(",")));
        }
        this.timelineMetricMetadataManager = timelineMetricMetadataManager;
        this.hbaseTotalHeapsize = metricsConf.getDouble("hbase_total_heapsize", 1.073741824E9);
        this.hbaseMemstoreUpperLimit = hbaseConf.getDouble("hbase.regionserver.global.memstore.upperLimit", 0.3);
        this.hbaseMemstoreFlushSize = hbaseConf.getDouble("hbase.hregion.memstore.flush.size", 1.34217728E8);
    }

    protected void computeSplitPoints() {
        byte[] uuid;
        MetricApp metricAppService;
        int i;
        int index;
        double memstoreMaxMemory = this.hbaseMemstoreUpperLimit * this.hbaseTotalHeapsize;
        int maxInMemoryRegions = (int)(memstoreMaxMemory / this.hbaseMemstoreFlushSize - 8.0);
        int targetPrecisionTableRegionCount = 4;
        int targetAggregateTableRegionCount = 2;
        if (maxInMemoryRegions > 2) {
            targetPrecisionTableRegionCount = Math.max(4, (int)(0.7 * (double)maxInMemoryRegions));
            targetAggregateTableRegionCount = Math.max(2, (int)(0.15 * (double)maxInMemoryRegions));
        }
        ArrayList<MetricApp> metricList = new ArrayList<MetricApp>();
        for (String component : this.masterComponents) {
            metricList.addAll(this.getSortedMetricListForSplitPoint(component, false));
        }
        for (String component : this.slaveComponents) {
            metricList.addAll(this.getSortedMetricListForSplitPoint(component, true));
        }
        int totalMetricLength = metricList.size();
        if (targetPrecisionTableRegionCount > 1) {
            int idx;
            index = idx = (int)Math.ceil(totalMetricLength / targetPrecisionTableRegionCount);
            for (i = 0; i < targetPrecisionTableRegionCount; ++i) {
                if (index >= totalMetricLength - 1) continue;
                metricAppService = (MetricApp)metricList.get(index);
                uuid = this.timelineMetricMetadataManager.getUuid(new TimelineClusterMetric(metricAppService.metricName, metricAppService.appId, null, -1L), true);
                this.precisionSplitPoints.add(uuid);
                index += idx;
            }
        }
        if (targetAggregateTableRegionCount > 1) {
            int idx;
            index = idx = (int)Math.ceil(totalMetricLength / targetAggregateTableRegionCount);
            for (i = 0; i < targetAggregateTableRegionCount; ++i) {
                if (index >= totalMetricLength - 1) continue;
                metricAppService = (MetricApp)metricList.get(index);
                uuid = this.timelineMetricMetadataManager.getUuid(new TimelineClusterMetric(metricAppService.metricName, metricAppService.appId, null, -1L), true);
                this.aggregateSplitPoints.add(uuid);
                index += idx;
            }
        }
    }

    private List<MetricApp> getSortedMetricListForSplitPoint(String component, boolean isSlave) {
        String appId = this.getAppId(component);
        ArrayList<MetricApp> metricList = new ArrayList<MetricApp>();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = this.getClass().getClassLoader();
        }
        try (InputStream inputStream = classLoader.getResourceAsStream("metrics_def/" + appId.toUpperCase() + ".dat");){
            if (inputStream != null) {
                String strLine;
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                LOG.info((Object)("Found split point candidate metrics for : " + appId));
                while ((strLine = bufferedReader.readLine()) != null) {
                    metricList.add(new MetricApp(strLine.trim(), appId));
                }
            } else {
                LOG.info((Object)("Split point candidate metrics not found for : " + appId));
            }
        }
        catch (Exception e) {
            LOG.info((Object)("Error reading split point candidate metrics for component : " + component));
            LOG.error((Object)e);
        }
        if (isSlave) {
            return this.getEquidistantMetrics(metricList, 50);
        }
        return this.getEquidistantMetrics(metricList, 5);
    }

    private List<MetricApp> getEquidistantMetrics(List<MetricApp> metrics, int distance) {
        ArrayList<MetricApp> selectedMetricApps = new ArrayList<MetricApp>();
        int idx = metrics.size() / distance;
        if (idx == 0) {
            return metrics;
        }
        int index = idx;
        for (int i = 0; i < distance; ++i) {
            selectedMetricApps.add(metrics.get(index - 1));
            index += idx;
        }
        return selectedMetricApps;
    }

    public List<byte[]> getPrecisionSplitPoints() {
        return this.precisionSplitPoints;
    }

    public List<byte[]> getClusterAggregateSplitPoints() {
        return this.aggregateSplitPoints;
    }

    public List<byte[]> getHostAggregateSplitPoints() {
        return this.aggregateSplitPoints;
    }

    private String getAppId(String component) {
        if (component.equalsIgnoreCase("METRICS_COLLECTOR")) {
            return "ams-hbase";
        }
        if (component.equalsIgnoreCase("METRICS_MONITOR")) {
            return "HOST";
        }
        return component;
    }
}

