/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ambari.metrics.core.timeline;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.ambari.metrics.core.timeline.availability.MetricCollectorHAController;
import org.apache.ambari.metrics.core.timeline.discovery.TimelineMetricMetadataManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@XmlRootElement(name="summary")
@XmlAccessorType(value=XmlAccessType.NONE)
public class TimelineMetricServiceSummary {
    private Date timestamp;
    private Map<String, String> metadataSummary = new HashMap<String, String>();
    private Map<String, String> aggregationSummary = new HashMap<String, String>();
    static final Log LOG = LogFactory.getLog(TimelineMetricServiceSummary.class);

    TimelineMetricServiceSummary(TimelineMetricMetadataManager metricMetadataManager, MetricCollectorHAController haController) {
        this.timestamp = new Date(System.currentTimeMillis());
        try {
            this.metadataSummary = metricMetadataManager.getMetadataSummary();
        }
        catch (Exception e) {
            LOG.error((Object)("Error fetching metadata summary : " + e));
        }
        if (haController != null) {
            this.aggregationSummary = haController.getAggregationSummary();
        }
    }

    @XmlElement(name="timestamp")
    public Date getTimestamp() {
        return this.timestamp;
    }

    @XmlElement(name="metadata")
    public Map<String, String> getMetadataSummary() {
        return this.metadataSummary;
    }

    @XmlElement(name="aggregation")
    public Map<String, String> getAggregationSummary() {
        return this.aggregationSummary;
    }
}

