/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ambari.metrics.core.timeline;

import com.google.common.collect.Multimap;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.ambari.metrics.core.timeline.FunctionUtils;
import org.apache.ambari.metrics.core.timeline.MetricsCacheCommitterThread;
import org.apache.ambari.metrics.core.timeline.MetricsSystemInitializationException;
import org.apache.ambari.metrics.core.timeline.TimelineMetricConfiguration;
import org.apache.ambari.metrics.core.timeline.TimelineMetricSplitPointComputer;
import org.apache.ambari.metrics.core.timeline.TimelineMetricsAggregatorSink;
import org.apache.ambari.metrics.core.timeline.TimelineMetricsFilter;
import org.apache.ambari.metrics.core.timeline.TransientMetricReadHelper;
import org.apache.ambari.metrics.core.timeline.aggregators.AggregatorUtils;
import org.apache.ambari.metrics.core.timeline.aggregators.Function;
import org.apache.ambari.metrics.core.timeline.aggregators.TimelineClusterMetric;
import org.apache.ambari.metrics.core.timeline.aggregators.TimelineMetricReadHelper;
import org.apache.ambari.metrics.core.timeline.discovery.TimelineMetricHostMetadata;
import org.apache.ambari.metrics.core.timeline.discovery.TimelineMetricMetadataKey;
import org.apache.ambari.metrics.core.timeline.discovery.TimelineMetricMetadataManager;
import org.apache.ambari.metrics.core.timeline.query.Condition;
import org.apache.ambari.metrics.core.timeline.query.DefaultPhoenixDataSource;
import org.apache.ambari.metrics.core.timeline.query.MetadataQueryCondition;
import org.apache.ambari.metrics.core.timeline.query.PhoenixConnectionProvider;
import org.apache.ambari.metrics.core.timeline.query.PhoenixTransactSQL;
import org.apache.ambari.metrics.core.timeline.query.SplitByMetricNamesCondition;
import org.apache.ambari.metrics.core.timeline.sink.ExternalMetricsSink;
import org.apache.ambari.metrics.core.timeline.sink.ExternalSinkProvider;
import org.apache.ambari.metrics.core.timeline.source.InternalMetricsSource;
import org.apache.ambari.metrics.core.timeline.source.InternalSourceProvider;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.util.RetryCounter;
import org.apache.hadoop.hbase.util.RetryCounterFactory;
import org.apache.hadoop.metrics2.sink.timeline.ContainerMetric;
import org.apache.hadoop.metrics2.sink.timeline.MetricClusterAggregate;
import org.apache.hadoop.metrics2.sink.timeline.MetricHostAggregate;
import org.apache.hadoop.metrics2.sink.timeline.Precision;
import org.apache.hadoop.metrics2.sink.timeline.SingleValuedTimelineMetric;
import org.apache.hadoop.metrics2.sink.timeline.TimelineMetric;
import org.apache.hadoop.metrics2.sink.timeline.TimelineMetricMetadata;
import org.apache.hadoop.metrics2.sink.timeline.TimelineMetricUtils;
import org.apache.hadoop.metrics2.sink.timeline.TimelineMetrics;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.util.timeline.TimelineUtils;
import org.apache.phoenix.exception.PhoenixIOException;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.TypeReference;

public class PhoenixHBaseAccessor {
    private static final Log LOG = LogFactory.getLog(PhoenixHBaseAccessor.class);
    static final int PHOENIX_MAX_MUTATION_STATE_SIZE = 50000;
    public static int RESULTSET_LIMIT = 5760;
    public static int hostMinuteAggregatorDataInterval = 300;
    public static int clusterMinuteAggregatorDataInterval = 300;
    public static int clusterSecondAggregatorDataInterval = 30;
    static TimelineMetricReadHelper TIMELINE_METRIC_READ_HELPER = new TimelineMetricReadHelper();
    static ObjectMapper mapper = new ObjectMapper();
    static TypeReference<TreeMap<Long, Double>> metricValuesTypeRef = new TypeReference<TreeMap<Long, Double>>(){};
    private final Configuration hbaseConf;
    private final Configuration metricsConf;
    private final RetryCounterFactory retryCounterFactory;
    private final PhoenixConnectionProvider dataSource;
    private final int cacheSize;
    private final boolean cacheEnabled;
    private final BlockingQueue<TimelineMetrics> insertCache;
    private ScheduledExecutorService scheduledExecutorService;
    private MetricsCacheCommitterThread metricsCommiterThread;
    private TimelineMetricsAggregatorSink aggregatorSink;
    private final int cacheCommitInterval;
    private final boolean skipBlockCacheForAggregatorsEnabled;
    private TimelineMetricMetadataManager metadataManagerInstance;
    private Set<String> eventMetricPatterns = new HashSet<String>();
    private boolean supportMultipleClusterMetrics = false;
    private String defaultInstanceId = "";
    private Map<String, Integer> tableTTL = new HashMap<String, Integer>();
    private final TimelineMetricConfiguration configuration;
    private List<InternalMetricsSource> rawMetricsSources = new ArrayList<InternalMetricsSource>();

    public PhoenixHBaseAccessor(PhoenixConnectionProvider dataSource) {
        this(TimelineMetricConfiguration.getInstance(), dataSource);
    }

    PhoenixHBaseAccessor(TimelineMetricConfiguration configuration, PhoenixConnectionProvider dataSource) {
        Class metricSinkClass;
        this.configuration = TimelineMetricConfiguration.getInstance();
        try {
            this.hbaseConf = configuration.getHbaseConf();
            this.metricsConf = configuration.getMetricsConf();
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError("Cannot initialize configuration.");
        }
        if (dataSource == null) {
            dataSource = new DefaultPhoenixDataSource(this.hbaseConf);
        }
        this.dataSource = dataSource;
        RESULTSET_LIMIT = this.metricsConf.getInt("timeline.metrics.service.default.result.limit", RESULTSET_LIMIT);
        clusterSecondAggregatorDataInterval = this.metricsConf.getInt("timeline.metrics.cluster.aggregator.second.timeslice.interval", 30);
        hostMinuteAggregatorDataInterval = this.metricsConf.getInt("timeline.metrics.host.aggregator.minute.interval", 300);
        clusterMinuteAggregatorDataInterval = this.metricsConf.getInt("timeline.metrics.cluster.aggregator.minute.interval", 300);
        try {
            Class.forName("org.apache.phoenix.jdbc.PhoenixDriver");
        }
        catch (ClassNotFoundException e) {
            LOG.error((Object)"Phoenix client jar not found in the classpath.", (Throwable)e);
            throw new IllegalStateException(e);
        }
        this.retryCounterFactory = new RetryCounterFactory(this.metricsConf.getInt("timeline.metrics.service.default.max_retries", 10), (int)TimeUnit.SECONDS.toMillis(this.metricsConf.getInt("timeline.metrics.service.default.retryInterval", 3)));
        this.cacheEnabled = Boolean.valueOf(this.metricsConf.get("timeline.metrics.cache.enabled", "true"));
        this.cacheSize = Integer.valueOf(this.metricsConf.get("timeline.metrics.cache.size", "150"));
        this.cacheCommitInterval = Integer.valueOf(this.metricsConf.get("timeline.metrics.cache.commit.interval", "3"));
        this.insertCache = new ArrayBlockingQueue<TimelineMetrics>(this.cacheSize);
        this.skipBlockCacheForAggregatorsEnabled = this.metricsConf.getBoolean("timeline.metrics.aggregators.skip.blockcache.enabled", false);
        String eventMetricPatternStrings = this.metricsConf.get("timeline.metrics.downsampler.event.metric.patterns", "");
        this.eventMetricPatterns.addAll(TimelineMetricUtils.getJavaMetricPatterns((String)eventMetricPatternStrings));
        this.tableTTL.put("METRIC_RECORD_UUID", this.metricsConf.getInt("timeline.metrics.host.aggregator.ttl", 86400));
        this.tableTTL.put("CONTAINER_METRICS", this.metricsConf.getInt("timeline.container-metrics.ttl", 1209600));
        this.tableTTL.put("METRIC_RECORD_MINUTE_UUID", this.metricsConf.getInt("timeline.metrics.host.aggregator.minute.ttl", 604800));
        this.tableTTL.put("METRIC_RECORD_HOURLY_UUID", this.metricsConf.getInt("timeline.metrics.host.aggregator.hourly.ttl", 2592000));
        this.tableTTL.put("METRIC_RECORD_DAILY_UUID", this.metricsConf.getInt("timeline.metrics.host.aggregator.daily.ttl", 31536000));
        this.tableTTL.put("METRIC_AGGREGATE_UUID", this.metricsConf.getInt("timeline.metrics.cluster.aggregator.second.ttl", 604800));
        this.tableTTL.put("METRIC_AGGREGATE_MINUTE_UUID", this.metricsConf.getInt("timeline.metrics.cluster.aggregator.minute.ttl", 2592000));
        this.tableTTL.put("METRIC_AGGREGATE_HOURLY_UUID", this.metricsConf.getInt("timeline.metrics.cluster.aggregator.hourly.ttl", 31536000));
        this.tableTTL.put("METRIC_AGGREGATE_DAILY_UUID", this.metricsConf.getInt("timeline.metrics.cluster.aggregator.daily.ttl", 63072000));
        this.tableTTL.put("METRIC_TRANSIENT", this.metricsConf.getInt("timeline.metrics.transient.table.ttl", 604800));
        this.supportMultipleClusterMetrics = Boolean.valueOf(this.metricsConf.get("timeline.metrics.support.multiple.clusters", "false"));
        this.defaultInstanceId = configuration.getDefaultInstanceId();
        if (this.cacheEnabled) {
            LOG.debug((Object)"Initialising and starting metrics cache committer thread...");
            this.metricsCommiterThread = new MetricsCacheCommitterThread(this);
            this.scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
            this.scheduledExecutorService.scheduleWithFixedDelay(this.metricsCommiterThread, 0L, this.cacheCommitInterval, TimeUnit.SECONDS);
        }
        if ((metricSinkClass = this.metricsConf.getClass("timeline.metrics.service.aggregator.sink.class", null, TimelineMetricsAggregatorSink.class)) != null) {
            this.aggregatorSink = (TimelineMetricsAggregatorSink)ReflectionUtils.newInstance((Class)metricSinkClass, (Configuration)this.metricsConf);
            LOG.info((Object)("Initialized aggregator sink class " + metricSinkClass));
        }
        List<ExternalSinkProvider> externalSinkProviderList = configuration.getExternalSinkProviderList();
        InternalSourceProvider internalSourceProvider = configuration.getInternalSourceProvider();
        if (!externalSinkProviderList.isEmpty()) {
            for (ExternalSinkProvider externalSinkProvider : externalSinkProviderList) {
                ExternalMetricsSink rawMetricsSink = externalSinkProvider.getExternalMetricsSink(InternalSourceProvider.SOURCE_NAME.RAW_METRICS);
                int interval = configuration.getExternalSinkInterval(externalSinkProvider.getClass().getSimpleName(), InternalSourceProvider.SOURCE_NAME.RAW_METRICS);
                if (interval == -1) {
                    interval = this.cacheCommitInterval;
                }
                this.rawMetricsSources.add(internalSourceProvider.getInternalMetricsSource(InternalSourceProvider.SOURCE_NAME.RAW_METRICS, interval, rawMetricsSink));
            }
        }
        TIMELINE_METRIC_READ_HELPER = new TimelineMetricReadHelper(this.metadataManagerInstance);
    }

    public boolean isInsertCacheEmpty() {
        return this.insertCache.isEmpty();
    }

    public void commitMetricsFromCache() {
        LOG.debug((Object)"Clearing metrics cache");
        ArrayList<TimelineMetrics> metricsList = new ArrayList<TimelineMetrics>(this.insertCache.size());
        if (!this.insertCache.isEmpty()) {
            this.insertCache.drainTo(metricsList);
        }
        if (metricsList.size() > 0) {
            this.commitMetrics(metricsList);
            if (!this.rawMetricsSources.isEmpty()) {
                for (InternalMetricsSource rawMetricsSource : this.rawMetricsSources) {
                    rawMetricsSource.publishTimelineMetrics(metricsList);
                }
            }
        }
    }

    public void commitMetrics(TimelineMetrics timelineMetrics) {
        this.commitMetrics(Collections.singletonList(timelineMetrics));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commitMetrics(Collection<TimelineMetrics> timelineMetricsCollection) {
        LOG.debug((Object)"Committing metrics to store");
        Connection conn = null;
        Statement metricRecordStmt = null;
        ArrayList<TimelineMetric> transientMetrics = new ArrayList<TimelineMetric>();
        int rowCount = 0;
        try {
            conn = this.getConnection();
            metricRecordStmt = conn.prepareStatement(String.format("UPSERT INTO %s (UUID, SERVER_TIME, METRIC_SUM, METRIC_MAX, METRIC_MIN, METRIC_COUNT, METRICS) VALUES (?, ?, ?, ?, ?, ?, ?)", "METRIC_RECORD_UUID"));
            for (TimelineMetrics timelineMetrics : timelineMetricsCollection) {
                for (TimelineMetric metric : timelineMetrics.getMetrics()) {
                    double[] aggregates;
                    if (this.metadataManagerInstance.isTransientMetric(metric.getMetricName(), metric.getAppId())) {
                        transientMetrics.add(metric);
                        continue;
                    }
                    metricRecordStmt.clearParameters();
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)("host: " + metric.getHostName() + ", metricName = " + metric.getMetricName() + ", values: " + metric.getMetricValues()));
                    }
                    if ((aggregates = AggregatorUtils.calculateAggregates(metric.getMetricValues()))[3] != 0.0) {
                        ++rowCount;
                        byte[] uuid = this.metadataManagerInstance.getUuid(metric, true);
                        if (uuid == null) {
                            LOG.error((Object)("Error computing UUID for metric. Cannot write metrics : " + metric.toString()));
                            continue;
                        }
                        metricRecordStmt.setBytes(1, uuid);
                        metricRecordStmt.setLong(2, metric.getStartTime());
                        metricRecordStmt.setDouble(3, aggregates[0]);
                        metricRecordStmt.setDouble(4, aggregates[1]);
                        metricRecordStmt.setDouble(5, aggregates[2]);
                        metricRecordStmt.setLong(6, (long)aggregates[3]);
                        String json = TimelineUtils.dumpTimelineRecordtoJSON((Object)metric.getMetricValues());
                        metricRecordStmt.setString(7, json);
                        try {
                            int n = metricRecordStmt.executeUpdate();
                        }
                        catch (NumberFormatException | SQLException ex) {
                            LOG.warn((Object)("Failed on insert records to store : " + ex.getMessage()));
                            LOG.warn((Object)("Metric that cannot be stored : [" + metric.getMetricName() + "," + metric.getAppId() + "]" + metric.getMetricValues().toString()));
                            continue;
                        }
                        if (rowCount < 49999) continue;
                        conn.commit();
                        rowCount = 0;
                        continue;
                    }
                    LOG.debug((Object)("Discarding empty metric record for : [" + metric.getMetricName() + "," + metric.getAppId() + "," + metric.getHostName() + "," + metric.getInstanceId() + "]"));
                }
            }
            if (CollectionUtils.isNotEmpty(transientMetrics)) {
                this.commitTransientMetrics(conn, transientMetrics);
            }
            conn.commit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (metricRecordStmt != null) {
                try {
                    metricRecordStmt.close();
                }
                catch (SQLException sQLException) {}
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    private void commitTransientMetrics(Connection conn, Collection<TimelineMetric> transientMetrics) throws SQLException, IOException {
        LOG.debug((Object)"Committing transient metrics to store");
        PreparedStatement metricTransientRecordStmt = null;
        metricTransientRecordStmt = conn.prepareStatement(String.format("UPSERT INTO %s (METRIC_NAME, HOSTNAME, APP_ID, INSTANCE_ID, SERVER_TIME, UNITS, METRIC_SUM, METRIC_MAX, METRIC_MIN, METRIC_COUNT, METRICS) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)", "METRIC_TRANSIENT"));
        for (TimelineMetric metric : transientMetrics) {
            metricTransientRecordStmt.clearParameters();
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("host: " + metric.getHostName() + ", metricName = " + metric.getMetricName() + ", values: " + metric.getMetricValues()));
            }
            double[] aggregates = AggregatorUtils.calculateAggregates(metric.getMetricValues());
            metricTransientRecordStmt.setString(1, metric.getMetricName());
            metricTransientRecordStmt.setString(2, metric.getHostName());
            metricTransientRecordStmt.setString(3, metric.getAppId());
            metricTransientRecordStmt.setString(4, metric.getInstanceId());
            metricTransientRecordStmt.setLong(5, metric.getStartTime());
            metricTransientRecordStmt.setString(6, metric.getUnits());
            metricTransientRecordStmt.setDouble(7, aggregates[0]);
            metricTransientRecordStmt.setDouble(8, aggregates[1]);
            metricTransientRecordStmt.setDouble(9, aggregates[2]);
            metricTransientRecordStmt.setLong(10, (long)aggregates[3]);
            String json = TimelineUtils.dumpTimelineRecordtoJSON((Object)metric.getMetricValues());
            metricTransientRecordStmt.setString(11, json);
            try {
                metricTransientRecordStmt.executeUpdate();
            }
            catch (SQLException sql) {
                LOG.error((Object)"Failed on inserting transient metric records to store.", (Throwable)sql);
            }
        }
    }

    private static TimelineMetric getLastTimelineMetricFromResultSet(ResultSet rs) throws SQLException, IOException {
        TimelineMetric metric = TIMELINE_METRIC_READ_HELPER.getTimelineMetricCommonsFromResultSet(rs);
        metric.setMetricValues(PhoenixHBaseAccessor.readLastMetricValueFromJSON(rs.getString("METRICS")));
        return metric;
    }

    private static TreeMap<Long, Double> readLastMetricValueFromJSON(String json) throws IOException {
        TreeMap<Long, Double> values = PhoenixHBaseAccessor.readMetricFromJSON(json);
        Long lastTimeStamp = values.lastKey();
        TreeMap<Long, Double> valueMap = new TreeMap<Long, Double>();
        valueMap.put(lastTimeStamp, values.get(lastTimeStamp));
        return valueMap;
    }

    public static TreeMap<Long, Double> readMetricFromJSON(String json) throws IOException {
        return (TreeMap)mapper.readValue(json, metricValuesTypeRef);
    }

    public Connection getConnectionRetryingOnException() throws SQLException, InterruptedException {
        RetryCounter retryCounter = this.retryCounterFactory.create();
        while (true) {
            try {
                return this.getConnection();
            }
            catch (SQLException e) {
                if (!retryCounter.shouldRetry()) {
                    LOG.error((Object)("HBaseAccessor getConnection failed after " + retryCounter.getMaxAttempts() + " attempts"));
                    throw e;
                }
                retryCounter.sleepUntilNextRetry();
                continue;
            }
            break;
        }
    }

    public Connection getConnection() throws SQLException {
        return this.dataSource.getConnection();
    }

    Admin getHBaseAdmin() throws IOException {
        return this.dataSource.getHBaseAdmin();
    }

    protected void initMetricSchema() {
        Connection conn = null;
        Statement stmt = null;
        Statement pStmt = null;
        TimelineMetricSplitPointComputer splitPointComputer = new TimelineMetricSplitPointComputer(this.metricsConf, this.hbaseConf, this.metadataManagerInstance);
        splitPointComputer.computeSplitPoints();
        String encoding = this.metricsConf.get("timeline.metrics.hbase.data.block.encoding", "FAST_DIFF");
        String compression = this.metricsConf.get("timeline.metrics.hbase.compression.scheme", "SNAPPY");
        try {
            LOG.info((Object)"Initializing metrics schema...");
            conn = this.getConnectionRetryingOnException();
            stmt = conn.createStatement();
            stmt.executeUpdate(String.format("CREATE TABLE IF NOT EXISTS CONTAINER_METRICS (APP_ID VARCHAR,  CONTAINER_ID VARCHAR, START_TIME TIMESTAMP, FINISH_TIME TIMESTAMP,  DURATION BIGINT, HOSTNAME VARCHAR, EXIT_CODE INTEGER, LOCALIZATION_DURATION BIGINT, LAUNCH_DURATION BIGINT, MEM_REQUESTED_GB DOUBLE, MEM_REQUESTED_GB_MILLIS DOUBLE, MEM_VIRTUAL_GB DOUBLE, MEM_USED_GB_MIN DOUBLE, MEM_USED_GB_MAX DOUBLE, MEM_USED_GB_AVG DOUBLE, MEM_USED_GB_50_PCT DOUBLE, MEM_USED_GB_75_PCT DOUBLE, MEM_USED_GB_90_PCT DOUBLE, MEM_USED_GB_95_PCT DOUBLE, MEM_USED_GB_99_PCT DOUBLE, MEM_UNUSED_GB DOUBLE, MEM_UNUSED_GB_MILLIS DOUBLE  CONSTRAINT pk PRIMARY KEY(APP_ID, CONTAINER_ID)) DATA_BLOCK_ENCODING='%s', IMMUTABLE_ROWS=true, TTL=%s, COMPRESSION='%s'", encoding, this.tableTTL.get("CONTAINER_METRICS"), compression));
            String precisionSql = String.format("CREATE TABLE IF NOT EXISTS METRIC_RECORD_UUID (UUID BINARY(20) NOT NULL, SERVER_TIME BIGINT NOT NULL, METRIC_SUM DOUBLE, METRIC_COUNT UNSIGNED_INT, METRIC_MAX DOUBLE, METRIC_MIN DOUBLE, METRICS VARCHAR CONSTRAINT pk PRIMARY KEY (UUID, SERVER_TIME ROW_TIMESTAMP)) DATA_BLOCK_ENCODING='%s', IMMUTABLE_ROWS=true, TTL=%s, COMPRESSION='%s'", encoding, this.tableTTL.get("METRIC_RECORD_UUID"), compression);
            pStmt = this.prepareCreateMetricsTableStatement(conn, precisionSql, splitPointComputer.getPrecisionSplitPoints());
            pStmt.executeUpdate();
            String hostMinuteAggregrateSql = String.format("CREATE TABLE IF NOT EXISTS %s (UUID BINARY(20) NOT NULL, SERVER_TIME BIGINT NOT NULL, METRIC_SUM DOUBLE,METRIC_COUNT UNSIGNED_INT, METRIC_MAX DOUBLE,METRIC_MIN DOUBLE CONSTRAINT pk PRIMARY KEY (UUID, SERVER_TIME ROW_TIMESTAMP)) DATA_BLOCK_ENCODING='%s', IMMUTABLE_ROWS=true, TTL=%s, COMPRESSION='%s'", "METRIC_RECORD_MINUTE_UUID", encoding, this.tableTTL.get("METRIC_RECORD_MINUTE_UUID"), compression);
            pStmt = this.prepareCreateMetricsTableStatement(conn, hostMinuteAggregrateSql, splitPointComputer.getHostAggregateSplitPoints());
            pStmt.executeUpdate();
            stmt.executeUpdate(String.format("CREATE TABLE IF NOT EXISTS %s (UUID BINARY(20) NOT NULL, SERVER_TIME BIGINT NOT NULL, METRIC_SUM DOUBLE,METRIC_COUNT UNSIGNED_INT, METRIC_MAX DOUBLE,METRIC_MIN DOUBLE CONSTRAINT pk PRIMARY KEY (UUID, SERVER_TIME ROW_TIMESTAMP)) DATA_BLOCK_ENCODING='%s', IMMUTABLE_ROWS=true, TTL=%s, COMPRESSION='%s'", "METRIC_RECORD_HOURLY_UUID", encoding, this.tableTTL.get("METRIC_RECORD_HOURLY_UUID"), compression));
            stmt.executeUpdate(String.format("CREATE TABLE IF NOT EXISTS %s (UUID BINARY(20) NOT NULL, SERVER_TIME BIGINT NOT NULL, METRIC_SUM DOUBLE,METRIC_COUNT UNSIGNED_INT, METRIC_MAX DOUBLE,METRIC_MIN DOUBLE CONSTRAINT pk PRIMARY KEY (UUID, SERVER_TIME ROW_TIMESTAMP)) DATA_BLOCK_ENCODING='%s', IMMUTABLE_ROWS=true, TTL=%s, COMPRESSION='%s'", "METRIC_RECORD_DAILY_UUID", encoding, this.tableTTL.get("METRIC_RECORD_DAILY_UUID"), compression));
            String aggregateSql = String.format("CREATE TABLE IF NOT EXISTS %s (UUID BINARY(16) NOT NULL, SERVER_TIME BIGINT NOT NULL, METRIC_SUM DOUBLE, HOSTS_COUNT UNSIGNED_INT, METRIC_MAX DOUBLE, METRIC_MIN DOUBLE CONSTRAINT pk PRIMARY KEY (UUID, SERVER_TIME ROW_TIMESTAMP)) DATA_BLOCK_ENCODING='%s', IMMUTABLE_ROWS=true, TTL=%s, COMPRESSION='%s'", "METRIC_AGGREGATE_UUID", encoding, this.tableTTL.get("METRIC_AGGREGATE_UUID"), compression);
            pStmt = this.prepareCreateMetricsTableStatement(conn, aggregateSql, splitPointComputer.getClusterAggregateSplitPoints());
            pStmt.executeUpdate();
            stmt.executeUpdate(String.format("CREATE TABLE IF NOT EXISTS %s (UUID BINARY(16) NOT NULL, SERVER_TIME BIGINT NOT NULL, METRIC_SUM DOUBLE, METRIC_COUNT UNSIGNED_INT, METRIC_MAX DOUBLE, METRIC_MIN DOUBLE CONSTRAINT pk PRIMARY KEY (UUID, SERVER_TIME ROW_TIMESTAMP)) DATA_BLOCK_ENCODING='%s', IMMUTABLE_ROWS=true, TTL=%s, COMPRESSION='%s'", "METRIC_AGGREGATE_MINUTE_UUID", encoding, this.tableTTL.get("METRIC_AGGREGATE_MINUTE_UUID"), compression));
            stmt.executeUpdate(String.format("CREATE TABLE IF NOT EXISTS %s (UUID BINARY(16) NOT NULL, SERVER_TIME BIGINT NOT NULL, METRIC_SUM DOUBLE, METRIC_COUNT UNSIGNED_INT, METRIC_MAX DOUBLE, METRIC_MIN DOUBLE CONSTRAINT pk PRIMARY KEY (UUID, SERVER_TIME ROW_TIMESTAMP)) DATA_BLOCK_ENCODING='%s', IMMUTABLE_ROWS=true, TTL=%s, COMPRESSION='%s'", "METRIC_AGGREGATE_HOURLY_UUID", encoding, this.tableTTL.get("METRIC_AGGREGATE_HOURLY_UUID"), compression));
            stmt.executeUpdate(String.format("CREATE TABLE IF NOT EXISTS %s (UUID BINARY(16) NOT NULL, SERVER_TIME BIGINT NOT NULL, METRIC_SUM DOUBLE, METRIC_COUNT UNSIGNED_INT, METRIC_MAX DOUBLE, METRIC_MIN DOUBLE CONSTRAINT pk PRIMARY KEY (UUID, SERVER_TIME ROW_TIMESTAMP)) DATA_BLOCK_ENCODING='%s', IMMUTABLE_ROWS=true, TTL=%s, COMPRESSION='%s'", "METRIC_AGGREGATE_DAILY_UUID", encoding, this.tableTTL.get("METRIC_AGGREGATE_DAILY_UUID"), compression));
            String transientMetricPatterns = this.metricsConf.get("timeline.metrics.transient.metric.patterns", "");
            if (StringUtils.isNotEmpty((String)transientMetricPatterns)) {
                String transientMetricsTableSql = String.format("CREATE TABLE IF NOT EXISTS METRIC_TRANSIENT (METRIC_NAME VARCHAR, HOSTNAME VARCHAR, SERVER_TIME BIGINT NOT NULL, APP_ID VARCHAR, INSTANCE_ID VARCHAR, UNITS CHAR(20), METRIC_SUM DOUBLE, METRIC_COUNT UNSIGNED_INT, METRIC_MAX DOUBLE, METRIC_MIN DOUBLE, METRICS VARCHAR CONSTRAINT pk PRIMARY KEY (METRIC_NAME, HOSTNAME, SERVER_TIME ROW_TIMESTAMP, APP_ID, INSTANCE_ID)) DATA_BLOCK_ENCODING='%s', IMMUTABLE_ROWS=true, TTL=%s, COMPRESSION='%s'", encoding, this.tableTTL.get("METRIC_TRANSIENT"), compression);
                int n = stmt.executeUpdate(transientMetricsTableSql);
            }
            conn.commit();
            LOG.info((Object)"Metrics schema initialized.");
        }
        catch (InterruptedException | SQLException sql) {
            LOG.error((Object)"Error creating Metrics Schema in HBase using Phoenix.", (Throwable)sql);
            throw new MetricsSystemInitializationException("Error creating Metrics Schema in HBase using Phoenix.", sql);
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException sQLException) {}
            }
            if (pStmt != null) {
                try {
                    pStmt.close();
                }
                catch (Exception exception) {}
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    boolean initPoliciesAndTTL() {
        boolean modifyAnyTable = false;
        Admin hBaseAdmin = null;
        try {
            hBaseAdmin = this.dataSource.getHBaseAdmin();
        }
        catch (IOException e) {
            LOG.warn((Object)"Unable to initialize HBaseAdmin for setting policies.", (Throwable)e);
        }
        Object[] tableNames = null;
        Object[] containerMetricsTableName = null;
        if (hBaseAdmin != null) {
            try {
                tableNames = hBaseAdmin.listTableNames(PhoenixTransactSQL.PHOENIX_TABLES_REGEX_PATTERN, false);
                containerMetricsTableName = hBaseAdmin.listTableNames("CONTAINER_METRICS", false);
                tableNames = (TableName[])ArrayUtils.addAll((Object[])tableNames, (Object[])containerMetricsTableName);
            }
            catch (IOException e) {
                LOG.warn((Object)"Unable to get table names from HBaseAdmin for setting policies.", (Throwable)e);
                return false;
            }
            if (tableNames == null || tableNames.length == 0) {
                LOG.warn((Object)"Unable to get table names from HBaseAdmin for setting policies.");
                return false;
            }
            for (String tableName : PhoenixTransactSQL.PHOENIX_TABLES) {
                try {
                    boolean modifyTable = false;
                    Optional<TableName> tableNameOptional = Arrays.stream(tableNames).filter(t -> tableName.equals(t.getNameAsString())).findFirst();
                    HTableDescriptor tableDescriptor = null;
                    if (tableNameOptional.isPresent()) {
                        tableDescriptor = hBaseAdmin.getTableDescriptor(tableNameOptional.get());
                    }
                    if (tableDescriptor == null) {
                        LOG.warn((Object)("Unable to get table descriptor for " + tableName));
                        continue;
                    }
                    TableDescriptorBuilder tableDescriptorBuilder = TableDescriptorBuilder.newBuilder(tableDescriptor);
                    boolean enableNormalizer = this.hbaseConf.getBoolean("hbase.normalizer.enabled", false);
                    if (enableNormalizer ^ tableDescriptor.isNormalizationEnabled()) {
                        tableDescriptorBuilder.setNormalizationEnabled(enableNormalizer);
                        LOG.info((Object)("Normalizer set to " + enableNormalizer + " for " + tableName));
                        modifyTable = true;
                    }
                    boolean durabilitySettingsModified = this.setDurabilityForTable(tableName, tableDescriptorBuilder, (TableDescriptor)tableDescriptor);
                    modifyTable = modifyTable || durabilitySettingsModified;
                    boolean compactionPolicyModified = false;
                    compactionPolicyModified = this.setCompactionPolicyForTable(tableName, tableDescriptorBuilder, (TableDescriptor)tableDescriptor);
                    modifyTable = modifyTable || compactionPolicyModified;
                    ColumnFamilyDescriptor[] columnFamilyDescriptors = tableDescriptor.getColumnFamilies();
                    if (columnFamilyDescriptors != null) {
                        for (ColumnFamilyDescriptor familyDescriptor : columnFamilyDescriptors) {
                            int ttlValue = familyDescriptor.getTimeToLive();
                            if (ttlValue == this.tableTTL.get(tableName)) continue;
                            ColumnFamilyDescriptorBuilder familyDescriptorBuilder = ColumnFamilyDescriptorBuilder.newBuilder((ColumnFamilyDescriptor)familyDescriptor);
                            familyDescriptorBuilder.setTimeToLive(this.tableTTL.get(tableName).intValue());
                            LOG.info((Object)("Setting TTL on table: " + tableName + " to : " + this.tableTTL.get(tableName) + " seconds."));
                            hBaseAdmin.modifyColumnFamily(tableNameOptional.get(), familyDescriptorBuilder.build());
                            modifyTable = true;
                        }
                    }
                    if (!modifyTable) continue;
                    modifyAnyTable = modifyTable;
                    hBaseAdmin.modifyTable(tableNameOptional.get(), tableDescriptorBuilder.build());
                }
                catch (IOException e) {
                    LOG.error((Object)("Failed setting policies for " + tableName), (Throwable)e);
                }
            }
            try {
                hBaseAdmin.close();
            }
            catch (IOException e) {
                LOG.warn((Object)"Exception on HBaseAdmin close.", (Throwable)e);
            }
        }
        return modifyAnyTable;
    }

    private boolean setDurabilityForTable(String tableName, TableDescriptorBuilder tableDescriptorBuilder, TableDescriptor tableDescriptor) {
        String tableDurability = this.metricsConf.get("timeline.metrics." + tableName + ".durability", "");
        if (StringUtils.isEmpty((String)tableDurability) || tableDescriptor.getDurability().toString().equals(tableDurability)) {
            return false;
        }
        if (StringUtils.isNotEmpty((String)tableDurability)) {
            LOG.info((Object)("Setting WAL option " + tableDurability + " for table : " + tableName));
            boolean validDurability = true;
            if ("SKIP_WAL".equals(tableDurability)) {
                tableDescriptorBuilder.setDurability(Durability.SKIP_WAL);
            } else if ("SYNC_WAL".equals(tableDurability)) {
                tableDescriptorBuilder.setDurability(Durability.SYNC_WAL);
            } else if ("ASYNC_WAL".equals(tableDurability)) {
                tableDescriptorBuilder.setDurability(Durability.ASYNC_WAL);
            } else if ("FSYNC_WAL".equals(tableDurability)) {
                tableDescriptorBuilder.setDurability(Durability.FSYNC_WAL);
            } else {
                LOG.info((Object)("Unknown value for durability : " + tableDurability));
                validDurability = false;
            }
            return validDurability;
        }
        return false;
    }

    private boolean setCompactionPolicyForTable(String tableName, TableDescriptorBuilder tableDescriptorBuilder, TableDescriptor tableDescriptor) {
        boolean modifyTable = false;
        String keyConfig = "timeline.metrics." + tableName + ".compaction.policy.key";
        String policyConfig = "timeline.metrics." + tableName + ".compaction.policy";
        String storeFilesConfig = "timeline.metrics." + tableName + ".blocking.store.files";
        String compactionPolicyKey = this.metricsConf.get(keyConfig, "hbase.hstore.engine.class");
        String compactionPolicyClass = this.metricsConf.get(policyConfig, "org.apache.hadoop.hbase.regionserver.DateTieredStoreEngine");
        int blockingStoreFiles = this.hbaseConf.getInt(storeFilesConfig, 60);
        if (tableName.equals("METRIC_RECORD_UUID")) {
            compactionPolicyKey = this.metricsConf.get(keyConfig, "hbase.hstore.defaultengine.compactionpolicy.class");
            compactionPolicyClass = this.metricsConf.get(policyConfig, "org.apache.hadoop.hbase.regionserver.compactions.FIFOCompactionPolicy");
            blockingStoreFiles = this.hbaseConf.getInt(storeFilesConfig, 1000);
        }
        if (!compactionPolicyClass.equals(tableDescriptor.getValue(compactionPolicyKey))) {
            tableDescriptorBuilder.setValue(compactionPolicyKey, compactionPolicyClass);
            this.setHbaseBlockingStoreFiles(tableDescriptorBuilder, tableDescriptor, tableName, blockingStoreFiles);
            modifyTable = true;
            LOG.info((Object)("Setting compaction policy for " + tableName + ", " + compactionPolicyKey + "=" + compactionPolicyClass));
        }
        if (!compactionPolicyKey.equals("hbase.hstore.engine.class")) {
            tableDescriptorBuilder.removeValue("hbase.hstore.engine.class".getBytes());
        }
        if (!compactionPolicyKey.equals("hbase.hstore.defaultengine.compactionpolicy.class")) {
            tableDescriptorBuilder.removeValue("hbase.hstore.defaultengine.compactionpolicy.class".getBytes());
        }
        return modifyTable;
    }

    private boolean setHbaseBlockingStoreFiles(TableDescriptorBuilder tableDescriptorBuilder, TableDescriptor tableDescriptor, String tableName, int value) {
        if (!String.valueOf(value).equals(tableDescriptor.getValue("hbase.hstore.blockingStoreFiles"))) {
            tableDescriptorBuilder.setValue("hbase.hstore.blockingStoreFiles", String.valueOf(value));
            LOG.info((Object)("Setting config property hbase.hstore.blockingStoreFiles = " + value + " for " + tableName));
            return true;
        }
        return false;
    }

    private PreparedStatement prepareCreateMetricsTableStatement(Connection connection, String sql, List<byte[]> splitPoints) throws SQLException {
        String createTableWithSplitPointsSql = sql + this.getSplitPointsStr(splitPoints.size());
        LOG.debug((Object)createTableWithSplitPointsSql);
        PreparedStatement statement = connection.prepareStatement(createTableWithSplitPointsSql);
        for (int i = 1; i <= splitPoints.size(); ++i) {
            statement.setBytes(i, splitPoints.get(i - 1));
        }
        return statement;
    }

    private String getSplitPointsStr(int numSplits) {
        if (numSplits <= 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(" SPLIT ON ");
        sb.append("(");
        for (int i = 0; i < numSplits; ++i) {
            sb.append("?");
            sb.append(",");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(")");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertContainerMetrics(List<ContainerMetric> metrics) throws SQLException, IOException {
        Connection conn = this.getConnection();
        Statement metricRecordStmt = null;
        try {
            metricRecordStmt = conn.prepareStatement(String.format("UPSERT INTO %s (APP_ID, CONTAINER_ID, START_TIME, FINISH_TIME, DURATION, HOSTNAME, EXIT_CODE, LOCALIZATION_DURATION, LAUNCH_DURATION, MEM_REQUESTED_GB, MEM_REQUESTED_GB_MILLIS, MEM_VIRTUAL_GB, MEM_USED_GB_MIN, MEM_USED_GB_MAX, MEM_USED_GB_AVG, MEM_USED_GB_50_PCT, MEM_USED_GB_75_PCT, MEM_USED_GB_90_PCT, MEM_USED_GB_95_PCT, MEM_USED_GB_99_PCT, MEM_UNUSED_GB, MEM_UNUSED_GB_MILLIS) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)", "CONTAINER_METRICS"));
            for (ContainerMetric metric : metrics) {
                metricRecordStmt.clearParameters();
                metricRecordStmt.setString(1, ContainerId.fromString((String)metric.getContainerId()).getApplicationAttemptId().getApplicationId().toString());
                metricRecordStmt.setString(2, metric.getContainerId());
                metricRecordStmt.setTimestamp(3, new Timestamp(metric.getStartTime()));
                metricRecordStmt.setTimestamp(4, new Timestamp(metric.getFinishTime()));
                metricRecordStmt.setLong(5, metric.getFinishTime() - metric.getStartTime());
                metricRecordStmt.setString(6, metric.getHostName());
                metricRecordStmt.setInt(7, metric.getExitCode());
                metricRecordStmt.setLong(8, metric.getLocalizationDuration());
                metricRecordStmt.setLong(9, metric.getLaunchDuration());
                metricRecordStmt.setDouble(10, (double)metric.getPmemLimit() / 1024.0);
                metricRecordStmt.setDouble(11, (double)metric.getPmemLimit() / 1024.0 * (double)(metric.getFinishTime() - metric.getStartTime()));
                metricRecordStmt.setDouble(12, (double)metric.getVmemLimit() / 1024.0);
                metricRecordStmt.setDouble(13, (double)metric.getPmemUsedMin() / 1024.0);
                metricRecordStmt.setDouble(14, (double)metric.getPmemUsedMax() / 1024.0);
                metricRecordStmt.setDouble(15, (double)metric.getPmemUsedAvg() / 1024.0);
                metricRecordStmt.setDouble(16, (double)metric.getPmem50Pct() / 1024.0);
                metricRecordStmt.setDouble(17, (double)metric.getPmem75Pct() / 1024.0);
                metricRecordStmt.setDouble(18, (double)metric.getPmem90Pct() / 1024.0);
                metricRecordStmt.setDouble(19, (double)metric.getPmem95Pct() / 1024.0);
                metricRecordStmt.setDouble(20, (double)metric.getPmem99Pct() / 1024.0);
                metricRecordStmt.setDouble(21, (double)metric.getPmemLimit() / 1024.0 - (double)metric.getPmemUsedMax() / 1024.0);
                metricRecordStmt.setDouble(22, ((double)metric.getPmemLimit() / 1024.0 - (double)metric.getPmemUsedMax() / 1024.0) * (double)(metric.getFinishTime() - metric.getStartTime()));
                try {
                    metricRecordStmt.executeUpdate();
                }
                catch (SQLException sql) {
                    LOG.error((Object)"Failed on insert records to store.", (Throwable)sql);
                }
            }
            conn.commit();
        }
        finally {
            if (metricRecordStmt != null) {
                try {
                    metricRecordStmt.close();
                }
                catch (SQLException sQLException) {}
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    public void insertMetricRecordsWithMetadata(TimelineMetricMetadataManager metadataManager, TimelineMetrics metrics, boolean skipCache) throws SQLException, IOException {
        List timelineMetrics = metrics.getMetrics();
        if (timelineMetrics == null || timelineMetrics.isEmpty()) {
            LOG.debug((Object)"Empty metrics insert request.");
            return;
        }
        Iterator iterator = timelineMetrics.iterator();
        while (iterator.hasNext()) {
            TimelineMetric tm = (TimelineMetric)iterator.next();
            boolean acceptMetric = TimelineMetricsFilter.acceptMetric(tm);
            if (this.supportMultipleClusterMetrics && StringUtils.isEmpty((String)tm.getInstanceId())) {
                tm.setInstanceId(this.defaultInstanceId);
            }
            if (metadataManager != null) {
                metadataManager.putIfModifiedTimelineMetricMetadata(metadataManager.createTimelineMetricMetadata(tm, acceptMetric));
                metadataManager.putIfModifiedHostedAppsMetadata(tm.getHostName(), tm.getAppId());
                if (!tm.getAppId().equals("FLUME_HANDLER")) {
                    metadataManager.putIfModifiedHostedInstanceMetadata(tm.getInstanceId(), tm.getHostName());
                }
            }
            if (acceptMetric) continue;
            iterator.remove();
        }
        if (!skipCache && this.cacheEnabled) {
            LOG.debug((Object)"Adding metrics to cache");
            if (this.insertCache.size() >= this.cacheSize) {
                this.commitMetricsFromCache();
            }
            try {
                this.insertCache.put(metrics);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            LOG.debug((Object)"Skipping metrics cache");
            this.commitMetrics(metrics);
        }
    }

    public void insertMetricRecords(TimelineMetrics metrics, boolean skipCache) throws SQLException, IOException {
        this.insertMetricRecordsWithMetadata(null, metrics, skipCache);
    }

    public void insertMetricRecords(TimelineMetrics metrics) throws SQLException, IOException {
        this.insertMetricRecords(metrics, false);
    }

    public TimelineMetrics getMetricRecords(Condition condition, Multimap<String, List<Function>> metricFunctions) throws SQLException, IOException {
        this.validateConditionIsNotEmpty(condition);
        Connection conn = this.getConnection();
        Statement stmt = null;
        ResultSet rs = null;
        TimelineMetrics metrics = new TimelineMetrics();
        try {
            if (condition.isPointInTime()) {
                this.getLatestMetricRecords(condition, conn, metrics);
            } else if (condition.getEndTime() >= condition.getStartTime()) {
                if (CollectionUtils.isNotEmpty(condition.getUuids())) {
                    stmt = PhoenixTransactSQL.prepareGetMetricsSqlStmt(conn, condition);
                    rs = stmt.executeQuery();
                    while (rs.next()) {
                        this.appendMetricFromResultSet(metrics, condition, metricFunctions, rs);
                    }
                }
                if (CollectionUtils.isNotEmpty(condition.getTransientMetricNames()) && (stmt = PhoenixTransactSQL.prepareTransientMetricsSqlStmt(conn, condition)) != null) {
                    rs = stmt.executeQuery();
                    while (rs.next()) {
                        TransientMetricReadHelper.appendMetricFromResultSet(metrics, condition, metricFunctions, rs);
                    }
                }
            } else {
                LOG.warn((Object)"Skipping metrics query because endTime < startTime");
            }
        }
        catch (PhoenixIOException pioe) {
            Throwable pioe2 = pioe.getCause();
            if (pioe2 instanceof PhoenixIOException && pioe2.getCause() instanceof DoNotRetryIOException) {
                String className = null;
                for (StackTraceElement ste : pioe2.getCause().getStackTrace()) {
                    className = ste.getClassName();
                }
                if (className != null && className.equals("HashJoinRegionScanner")) {
                    LOG.error((Object)"The cache might have expired and have been removed. Try to increase the cache size by setting bigger value for phoenix.coprocessor.maxMetaDataCacheSize in ams-hbase-site config. Falling back to sort-merge join algorithm.");
                    PhoenixTransactSQL.setSortMergeJoinEnabled(true);
                }
            }
            throw pioe;
        }
        catch (RuntimeException ex) {
            Throwable io = ex.getCause();
            String className = null;
            if (io != null) {
                for (TimelineMetrics ste : io.getStackTrace()) {
                    className = ste.getClassName();
                }
            }
            if (className != null && className.equals("TimeRange")) {
                LOG.debug((Object)io);
                TimelineMetrics timelineMetrics = new TimelineMetrics();
                return timelineMetrics;
            }
            throw ex;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException sQLException) {}
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        LOG.debug((Object)("Metrics records size: " + metrics.getMetrics().size()));
        return metrics;
    }

    private void appendMetricFromResultSet(TimelineMetrics metrics, Condition condition, Multimap<String, List<Function>> metricFunctions, ResultSet rs) throws SQLException, IOException {
        byte[] uuid = rs.getBytes("UUID");
        String metricName = this.metadataManagerInstance.getMetricNameFromUuid(uuid);
        Collection<List<Function>> functionList = FunctionUtils.findMetricFunctions(metricFunctions, metricName);
        if (CollectionUtils.isEmpty(functionList)) {
            LOG.warn((Object)("No metric name or pattern in GET query matched the metric name from the metric store : " + metricName));
            return;
        }
        for (List<Function> functions : functionList) {
            if (functions != null && !functions.isEmpty()) {
                if (functions.size() > 1) {
                    throw new IllegalArgumentException("Multiple aggregate functions not supported.");
                }
                for (Function f : functions) {
                    if (f.getReadFunction() == Function.ReadFunction.VALUE) {
                        this.getTimelineMetricsFromResultSet(metrics, f, condition, rs, this.isEventDownsampledMetric(metricName));
                        continue;
                    }
                    SingleValuedTimelineMetric metric = TIMELINE_METRIC_READ_HELPER.getAggregatedTimelineMetricFromResultSet(rs, f, this.isEventDownsampledMetric(metricName));
                    if (condition.isGrouped()) {
                        metrics.addOrMergeTimelineMetric(metric);
                        continue;
                    }
                    metrics.getMetrics().add(metric.getTimelineMetric());
                }
                continue;
            }
            this.getTimelineMetricsFromResultSet(metrics, null, condition, rs, this.isEventDownsampledMetric(metricName));
        }
    }

    private boolean isEventDownsampledMetric(String metricName) {
        for (String pattern : this.eventMetricPatterns) {
            if (!metricName.matches(pattern)) continue;
            return true;
        }
        return false;
    }

    private void getTimelineMetricsFromResultSet(TimelineMetrics metrics, Function f, Condition condition, ResultSet rs, boolean shouldSumAcrossTime) throws SQLException, IOException {
        if (condition.getPrecision().equals((Object)Precision.SECONDS)) {
            TimelineMetric metric = TIMELINE_METRIC_READ_HELPER.getTimelineMetricFromResultSet(rs);
            if (metric == null) {
                return;
            }
            if (f != null && f.getSuffix() != null) {
                metric.setMetricName(metric.getMetricName() + f.getSuffix());
            }
            if (condition.isGrouped()) {
                metrics.addOrMergeTimelineMetric(metric);
            } else {
                metrics.getMetrics().add(metric);
            }
        } else {
            SingleValuedTimelineMetric metric = TIMELINE_METRIC_READ_HELPER.getAggregatedTimelineMetricFromResultSet(rs, f, shouldSumAcrossTime);
            if (condition.isGrouped()) {
                metrics.addOrMergeTimelineMetric(metric);
            } else {
                metrics.getMetrics().add(metric.getTimelineMetric());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getLatestMetricRecords(Condition condition, Connection conn, TimelineMetrics metrics) throws SQLException, IOException {
        this.validateConditionIsNotEmpty(condition);
        PreparedStatement stmt = PhoenixTransactSQL.prepareGetLatestMetricSqlStmt(conn, condition);
        ResultSet rs = null;
        try {
            rs = stmt.executeQuery();
            while (rs.next()) {
                TimelineMetric metric = PhoenixHBaseAccessor.getLastTimelineMetricFromResultSet(rs);
                metrics.getMetrics().add(metric);
            }
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TimelineMetrics getAggregateMetricRecords(Condition condition, Multimap<String, List<Function>> metricFunctions) throws SQLException, IOException {
        this.validateConditionIsNotEmpty(condition);
        Connection conn = this.getConnection();
        Statement stmt = null;
        ResultSet rs = null;
        TimelineMetrics metrics = new TimelineMetrics();
        try {
            if (condition.isPointInTime()) {
                this.getLatestAggregateMetricRecords(condition, conn, metrics, metricFunctions);
            } else {
                if (CollectionUtils.isNotEmpty(condition.getUuids())) {
                    stmt = PhoenixTransactSQL.prepareGetAggregateSqlStmt(conn, condition);
                    rs = stmt.executeQuery();
                    while (rs.next()) {
                        this.appendAggregateMetricFromResultSet(metrics, condition, metricFunctions, rs);
                    }
                }
                if (CollectionUtils.isNotEmpty(condition.getTransientMetricNames()) && (stmt = PhoenixTransactSQL.prepareTransientMetricsSqlStmt(conn, condition)) != null) {
                    rs = stmt.executeQuery();
                    while (rs.next()) {
                        TransientMetricReadHelper.appendMetricFromResultSet(metrics, condition, metricFunctions, rs);
                    }
                }
            }
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException sQLException) {}
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        LOG.debug((Object)("Aggregate records size: " + metrics.getMetrics().size()));
        return metrics;
    }

    private void appendAggregateMetricFromResultSet(TimelineMetrics metrics, Condition condition, Multimap<String, List<Function>> metricFunctions, ResultSet rs) throws SQLException {
        byte[] uuid = rs.getBytes("UUID");
        String metricName = this.metadataManagerInstance.getMetricNameFromUuid(uuid);
        Collection<List<Function>> functionList = FunctionUtils.findMetricFunctions(metricFunctions, metricName);
        for (List<Function> functions : functionList) {
            for (Function aggregateFunction : functions) {
                SingleValuedTimelineMetric metric = condition.getPrecision() == Precision.MINUTES || condition.getPrecision() == Precision.HOURS || condition.getPrecision() == Precision.DAYS ? this.getAggregateTimelineMetricFromResultSet(rs, aggregateFunction, false) : this.getAggregateTimelineMetricFromResultSet(rs, aggregateFunction, true);
                if (condition.isGrouped()) {
                    metrics.addOrMergeTimelineMetric(metric);
                    continue;
                }
                metrics.getMetrics().add(metric.getTimelineMetric());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getLatestAggregateMetricRecords(Condition condition, Connection conn, TimelineMetrics metrics, Multimap<String, List<Function>> metricFunctions) throws SQLException {
        PreparedStatement stmt = null;
        SplitByMetricNamesCondition splitCondition = new SplitByMetricNamesCondition(condition);
        for (byte[] uuid : condition.getUuids()) {
            splitCondition.setCurrentUuid(uuid);
            stmt = PhoenixTransactSQL.prepareGetLatestAggregateMetricSqlStmt(conn, splitCondition);
            ResultSet rs = null;
            try {
                rs = stmt.executeQuery();
                while (rs.next()) {
                    String metricName = this.metadataManagerInstance.getMetricNameFromUuid(uuid);
                    Collection<List<Function>> functionList = FunctionUtils.findMetricFunctions(metricFunctions, metricName);
                    for (List<Function> functions : functionList) {
                        if (functions != null) {
                            for (Function f : functions) {
                                SingleValuedTimelineMetric metric = this.getAggregateTimelineMetricFromResultSet(rs, f, true);
                                if (condition.isGrouped()) {
                                    metrics.addOrMergeTimelineMetric(metric);
                                    continue;
                                }
                                metrics.getMetrics().add(metric.getTimelineMetric());
                            }
                            continue;
                        }
                        SingleValuedTimelineMetric metric = this.getAggregateTimelineMetricFromResultSet(rs, new Function(), true);
                        metrics.getMetrics().add(metric.getTimelineMetric());
                    }
                }
            }
            finally {
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException sQLException) {}
                }
                if (stmt == null) continue;
                stmt.close();
            }
        }
    }

    private SingleValuedTimelineMetric getAggregateTimelineMetricFromResultSet(ResultSet rs, Function f, boolean useHostCount) throws SQLException {
        String countColumnName = "METRIC_COUNT";
        if (useHostCount) {
            countColumnName = "HOSTS_COUNT";
        }
        byte[] uuid = rs.getBytes("UUID");
        TimelineMetric timelineMetric = this.metadataManagerInstance.getMetricFromUuid(uuid);
        SingleValuedTimelineMetric metric = new SingleValuedTimelineMetric(timelineMetric.getMetricName() + f.getSuffix(), timelineMetric.getAppId(), timelineMetric.getInstanceId(), null, rs.getLong("SERVER_TIME"));
        metric.setSingleTimeseriesValue(Long.valueOf(rs.getLong("SERVER_TIME")), Double.valueOf(switch (f.getReadFunction()) {
            case Function.ReadFunction.AVG -> rs.getDouble("METRIC_SUM") / (double)rs.getInt(countColumnName);
            case Function.ReadFunction.MIN -> rs.getDouble("METRIC_MIN");
            case Function.ReadFunction.MAX -> rs.getDouble("METRIC_MAX");
            case Function.ReadFunction.SUM -> rs.getDouble("METRIC_SUM");
            default -> rs.getDouble("METRIC_SUM") / (double)rs.getInt(countColumnName);
        }));
        return metric;
    }

    private void validateConditionIsNotEmpty(Condition condition) {
        if (condition.isEmpty()) {
            throw new IllegalArgumentException("No filter criteria specified.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveHostAggregateRecords(Map<TimelineMetric, MetricHostAggregate> hostAggregateMap, String phoenixTableName) throws SQLException {
        if (hostAggregateMap == null || hostAggregateMap.isEmpty()) {
            LOG.debug((Object)"Empty aggregate records.");
            return;
        }
        Connection conn = this.getConnection();
        Statement stmt = null;
        long start = System.currentTimeMillis();
        int rowCount = 0;
        try {
            stmt = conn.prepareStatement(String.format("UPSERT INTO %s (UUID, SERVER_TIME, METRIC_SUM, METRIC_MAX, METRIC_MIN,METRIC_COUNT) VALUES (?, ?, ?, ?, ?, ?)", phoenixTableName));
            for (Map.Entry<TimelineMetric, MetricHostAggregate> metricAggregate : hostAggregateMap.entrySet()) {
                TimelineMetric metric = metricAggregate.getKey();
                MetricHostAggregate hostAggregate = metricAggregate.getValue();
                byte[] uuid = this.metadataManagerInstance.getUuid(metric, true);
                if (uuid == null) {
                    LOG.error((Object)("Error computing UUID for metric. Cannot write aggregate metric : " + metric.toString()));
                    continue;
                }
                ++rowCount;
                stmt.clearParameters();
                stmt.setBytes(1, uuid);
                stmt.setLong(2, metric.getStartTime());
                stmt.setDouble(3, hostAggregate.getSum());
                stmt.setDouble(4, hostAggregate.getMax());
                stmt.setDouble(5, hostAggregate.getMin());
                stmt.setDouble(6, hostAggregate.getNumberOfSamples());
                try {
                    stmt.executeUpdate();
                }
                catch (SQLException sql) {
                    LOG.error((Object)sql);
                }
                if (rowCount < 49999) continue;
                conn.commit();
                rowCount = 0;
            }
            conn.commit();
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException sQLException) {}
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        long end = System.currentTimeMillis();
        if (end - start > 60000L) {
            LOG.info((Object)("Time to save map: " + (end - start) + ", thread = " + Thread.currentThread().getClass()));
        }
        if (this.aggregatorSink != null) {
            try {
                this.aggregatorSink.saveHostAggregateRecords(hostAggregateMap, this.getTablePrecision(phoenixTableName));
            }
            catch (Exception e) {
                LOG.warn((Object)("Error writing host aggregate records metrics to external sink. " + e));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveClusterAggregateRecords(Map<TimelineClusterMetric, MetricClusterAggregate> records) throws SQLException {
        if (records == null || records.isEmpty()) {
            LOG.debug((Object)"Empty aggregate records.");
            return;
        }
        long start = System.currentTimeMillis();
        String sqlStr = String.format("UPSERT INTO %s (UUID, SERVER_TIME, METRIC_SUM, HOSTS_COUNT, METRIC_MAX, METRIC_MIN) VALUES (?, ?, ?, ?, ?, ?)", "METRIC_AGGREGATE_UUID");
        Connection conn = this.getConnection();
        PreparedStatement stmt = null;
        try {
            stmt = conn.prepareStatement(sqlStr);
            int rowCount = 0;
            for (Map.Entry<TimelineClusterMetric, MetricClusterAggregate> aggregateEntry : records.entrySet()) {
                TimelineClusterMetric clusterMetric = aggregateEntry.getKey();
                MetricClusterAggregate aggregate = aggregateEntry.getValue();
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("clusterMetric = " + clusterMetric + ", aggregate = " + aggregate));
                }
                ++rowCount;
                byte[] uuid = this.metadataManagerInstance.getUuid(clusterMetric, true);
                if (uuid == null) {
                    LOG.error((Object)("Error computing UUID for metric. Cannot write metrics : " + clusterMetric.toString()));
                    continue;
                }
                stmt.clearParameters();
                stmt.setBytes(1, uuid);
                stmt.setLong(2, clusterMetric.getTimestamp());
                stmt.setDouble(3, aggregate.getSum());
                stmt.setInt(4, aggregate.getNumberOfHosts());
                stmt.setDouble(5, aggregate.getMax());
                stmt.setDouble(6, aggregate.getMin());
                try {
                    stmt.executeUpdate();
                }
                catch (SQLException sql) {
                    LOG.error((Object)sql);
                }
                if (rowCount < 49999) continue;
                conn.commit();
                rowCount = 0;
            }
            conn.commit();
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException rowCount) {}
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException rowCount) {}
            }
        }
        long end = System.currentTimeMillis();
        if (end - start > 60000L) {
            LOG.info((Object)("Time to save: " + (end - start) + ", thread = " + Thread.currentThread().getName()));
        }
        if (this.aggregatorSink != null) {
            try {
                this.aggregatorSink.saveClusterAggregateRecords(records);
            }
            catch (Exception e) {
                LOG.warn((Object)"Error writing cluster aggregate records metrics to external sink. ", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveClusterAggregateRecordsSecond(Map<TimelineClusterMetric, MetricHostAggregate> records, String tableName) throws SQLException {
        if (records == null || records.isEmpty()) {
            LOG.debug((Object)"Empty aggregate records.");
            return;
        }
        long start = System.currentTimeMillis();
        Connection conn = this.getConnection();
        Statement stmt = null;
        try {
            stmt = conn.prepareStatement(String.format("UPSERT INTO %s (UUID, SERVER_TIME, METRIC_SUM, METRIC_COUNT, METRIC_MAX, METRIC_MIN) VALUES (?, ?, ?, ?, ?, ?)", tableName));
            int rowCount = 0;
            for (Map.Entry<TimelineClusterMetric, MetricHostAggregate> aggregateEntry : records.entrySet()) {
                byte[] uuid;
                TimelineClusterMetric clusterMetric = aggregateEntry.getKey();
                MetricHostAggregate aggregate = aggregateEntry.getValue();
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("clusterMetric = " + clusterMetric + ", aggregate = " + aggregate));
                }
                if ((uuid = this.metadataManagerInstance.getUuid(clusterMetric, true)) == null) {
                    LOG.error((Object)("Error computing UUID for metric. Cannot write metric : " + clusterMetric.toString()));
                    continue;
                }
                ++rowCount;
                stmt.clearParameters();
                stmt.setBytes(1, uuid);
                stmt.setLong(2, clusterMetric.getTimestamp());
                stmt.setDouble(3, aggregate.getSum());
                stmt.setLong(4, aggregate.getNumberOfSamples());
                stmt.setDouble(5, aggregate.getMax());
                stmt.setDouble(6, aggregate.getMin());
                try {
                    stmt.executeUpdate();
                }
                catch (SQLException sql) {
                    LOG.error((Object)sql);
                }
                if (rowCount < 49999) continue;
                conn.commit();
                rowCount = 0;
            }
            conn.commit();
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException rowCount) {}
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException rowCount) {}
            }
        }
        long end = System.currentTimeMillis();
        if (end - start > 60000L) {
            LOG.info((Object)("Time to save: " + (end - start) + ", thread = " + Thread.currentThread().getName()));
        }
        if (this.aggregatorSink != null) {
            try {
                this.aggregatorSink.saveClusterTimeAggregateRecords(records, this.getTablePrecision(tableName));
            }
            catch (Exception e) {
                LOG.warn((Object)("Error writing cluster time aggregate records metrics to external sink. " + e));
            }
        }
    }

    private Precision getTablePrecision(String tableName) {
        Precision tablePrecision = null;
        switch (tableName) {
            case "METRIC_RECORD_UUID": {
                tablePrecision = Precision.SECONDS;
                break;
            }
            case "METRIC_RECORD_MINUTE_UUID": 
            case "METRIC_AGGREGATE_MINUTE_UUID": {
                tablePrecision = Precision.MINUTES;
                break;
            }
            case "METRIC_RECORD_HOURLY_UUID": 
            case "METRIC_AGGREGATE_HOURLY_UUID": {
                tablePrecision = Precision.HOURS;
                break;
            }
            case "METRIC_RECORD_DAILY_UUID": 
            case "METRIC_AGGREGATE_DAILY_UUID": {
                tablePrecision = Precision.DAYS;
            }
        }
        return tablePrecision;
    }

    public boolean isSkipBlockCacheForAggregatorsEnabled() {
        return this.skipBlockCacheForAggregatorsEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveHostAppsMetadata(Map<String, TimelineMetricHostMetadata> hostMetadata) throws SQLException {
        Connection conn = this.getConnection();
        PreparedStatement stmt = null;
        try {
            stmt = conn.prepareStatement("UPSERT INTO HOSTED_APPS_METADATA_UUID (HOSTNAME, UUID, APP_IDS) VALUES (?, ?, ?)");
            int rowCount = 0;
            for (Map.Entry<String, TimelineMetricHostMetadata> hostedAppsEntry : hostMetadata.entrySet()) {
                TimelineMetricHostMetadata timelineMetricHostMetadata = hostedAppsEntry.getValue();
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("HostedAppsMetadata: " + hostedAppsEntry));
                }
                stmt.clearParameters();
                stmt.setString(1, hostedAppsEntry.getKey());
                stmt.setBytes(2, timelineMetricHostMetadata.getUuid());
                stmt.setString(3, StringUtils.join((Collection)timelineMetricHostMetadata.getHostedApps().keySet(), (String)","));
                try {
                    stmt.executeUpdate();
                    ++rowCount;
                }
                catch (SQLException sql) {
                    LOG.error((Object)"Error saving hosted apps metadata.", (Throwable)sql);
                }
            }
            conn.commit();
            LOG.info((Object)("Saved " + rowCount + " hosted apps metadata records."));
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException sQLException) {}
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveInstanceHostsMetadata(Map<String, Set<String>> instanceHostsMap) throws SQLException {
        Connection conn = this.getConnection();
        PreparedStatement stmt = null;
        try {
            stmt = conn.prepareStatement("UPSERT INTO INSTANCE_HOST_METADATA (INSTANCE_ID, HOSTNAME) VALUES (?, ?)");
            int rowCount = 0;
            for (Map.Entry<String, Set<String>> hostInstancesEntry : instanceHostsMap.entrySet()) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Host Instances Entry: " + hostInstancesEntry));
                }
                String instanceId = hostInstancesEntry.getKey();
                for (String hostname : hostInstancesEntry.getValue()) {
                    stmt.clearParameters();
                    stmt.setString(1, instanceId);
                    stmt.setString(2, hostname);
                    try {
                        stmt.executeUpdate();
                        ++rowCount;
                    }
                    catch (SQLException sql) {
                        LOG.error((Object)"Error saving host instances metadata.", (Throwable)sql);
                    }
                }
            }
            conn.commit();
            LOG.info((Object)("Saved " + rowCount + " host instances metadata records."));
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException sQLException) {}
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveMetricMetadata(Collection<TimelineMetricMetadata> metricMetadata) throws SQLException {
        if (metricMetadata.isEmpty()) {
            LOG.info((Object)"No metadata records to save.");
            return;
        }
        Connection conn = this.getConnection();
        PreparedStatement stmt = null;
        try {
            stmt = conn.prepareStatement("UPSERT INTO METRICS_METADATA_UUID (METRIC_NAME, APP_ID, INSTANCE_ID, UUID, UNITS, TYPE, START_TIME, SUPPORTS_AGGREGATION, IS_WHITELISTED) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)");
            int rowCount = 0;
            for (TimelineMetricMetadata metadata : metricMetadata) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("TimelineMetricMetadata: metricName = " + metadata.getMetricName() + ", appId = " + metadata.getAppId() + ", seriesStartTime = " + metadata.getSeriesStartTime()));
                }
                try {
                    stmt.clearParameters();
                    stmt.setString(1, metadata.getMetricName());
                    stmt.setString(2, metadata.getAppId());
                    stmt.setString(3, metadata.getInstanceId());
                    stmt.setBytes(4, metadata.getUuid());
                    stmt.setString(5, metadata.getUnits());
                    stmt.setString(6, metadata.getType());
                    stmt.setLong(7, metadata.getSeriesStartTime());
                    stmt.setBoolean(8, metadata.isSupportsAggregates());
                    stmt.setBoolean(9, metadata.isWhitelisted());
                }
                catch (Exception e) {
                    LOG.error((Object)"Exception in saving metric metadata entry. ");
                    continue;
                }
                try {
                    stmt.executeUpdate();
                    ++rowCount;
                }
                catch (SQLException sql) {
                    LOG.error((Object)"Error saving metadata.", (Throwable)sql);
                }
            }
            conn.commit();
            LOG.info((Object)("Saved " + rowCount + " metadata records."));
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException sQLException) {}
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, TimelineMetricHostMetadata> getHostedAppsMetadata() throws SQLException {
        HashMap<String, TimelineMetricHostMetadata> hostedAppMap = new HashMap<String, TimelineMetricHostMetadata>();
        Connection conn = this.getConnection();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.prepareStatement("SELECT HOSTNAME, UUID, APP_IDS FROM HOSTED_APPS_METADATA_UUID");
            rs = stmt.executeQuery();
            while (rs.next()) {
                String appIds = rs.getString("APP_IDS");
                TimelineMetricHostMetadata hostMetadata = new TimelineMetricHostMetadata(new HashSet<String>());
                if (StringUtils.isNotEmpty((String)appIds)) {
                    hostMetadata = new TimelineMetricHostMetadata(new HashSet<String>(Arrays.asList(StringUtils.split((String)appIds, (String)","))));
                }
                hostMetadata.setUuid(rs.getBytes("UUID"));
                hostedAppMap.put(rs.getString("HOSTNAME"), hostMetadata);
            }
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException sQLException) {}
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return hostedAppMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Set<String>> getInstanceHostsMetdata() throws SQLException {
        HashMap<String, Set<String>> instanceHostsMap = new HashMap<String, Set<String>>();
        Connection conn = this.getConnection();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.prepareStatement("SELECT INSTANCE_ID, HOSTNAME FROM INSTANCE_HOST_METADATA");
            rs = stmt.executeQuery();
            while (rs.next()) {
                String instanceId = rs.getString("INSTANCE_ID");
                String hostname = rs.getString("HOSTNAME");
                if (!instanceHostsMap.containsKey(instanceId)) {
                    instanceHostsMap.put(instanceId, new HashSet());
                }
                ((Set)instanceHostsMap.get(instanceId)).add(hostname);
            }
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException sQLException) {}
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return instanceHostsMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<TimelineMetricMetadataKey, TimelineMetricMetadata> getTimelineMetricMetadata() throws SQLException {
        HashMap<TimelineMetricMetadataKey, TimelineMetricMetadata> metadataMap = new HashMap<TimelineMetricMetadataKey, TimelineMetricMetadata>();
        Connection conn = this.getConnection();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.prepareStatement("SELECT METRIC_NAME, APP_ID, INSTANCE_ID, UUID, UNITS, TYPE, START_TIME, SUPPORTS_AGGREGATION, IS_WHITELISTED FROM METRICS_METADATA_UUID");
            rs = stmt.executeQuery();
            while (rs.next()) {
                String metricName = rs.getString("METRIC_NAME");
                String appId = rs.getString("APP_ID");
                String instanceId = rs.getString("INSTANCE_ID");
                TimelineMetricMetadata metadata = new TimelineMetricMetadata(metricName, appId, instanceId, rs.getString("UNITS"), rs.getString("TYPE"), Long.valueOf(rs.getLong("START_TIME")), rs.getBoolean("SUPPORTS_AGGREGATION"), rs.getBoolean("IS_WHITELISTED"));
                TimelineMetricMetadataKey key = new TimelineMetricMetadataKey(metricName, appId, instanceId);
                metadata.setIsPersisted(true);
                metadata.setUuid(this.checkForNull(rs.getBytes("UUID")));
                metadataMap.put(key, metadata);
            }
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException sQLException) {}
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return metadataMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TimelineMetricMetadata> scanMetricMetadataForWildCardRequest(Collection<String> metricNames, String appId, String instanceId) throws SQLException {
        ArrayList<TimelineMetricMetadata> metadataList = new ArrayList<TimelineMetricMetadata>();
        Connection conn = this.getConnection();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        MetadataQueryCondition metadataQueryCondition = new MetadataQueryCondition(new ArrayList<String>(metricNames), appId, instanceId);
        stmt = PhoenixTransactSQL.prepareScanMetricMetadataSqlStmt(conn, metadataQueryCondition);
        try {
            if (stmt != null) {
                rs = stmt.executeQuery();
                while (rs.next()) {
                    TimelineMetricMetadata metadata = new TimelineMetricMetadata(rs.getString("METRIC_NAME"), rs.getString("APP_ID"), rs.getString("INSTANCE_ID"), null, null, null, false, true);
                    metadata.setUuid(this.checkForNull(rs.getBytes("UUID")));
                    metadataList.add(metadata);
                }
            }
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException sQLException) {}
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return metadataList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<byte[]> scanHostMetadataForWildCardRequest(List<String> hostnames) throws SQLException {
        ArrayList<byte[]> uuidList = new ArrayList<byte[]>();
        Connection conn = this.getConnection();
        ResultSet rs = null;
        MetadataQueryCondition metadataQueryCondition = new MetadataQueryCondition(hostnames);
        PreparedStatement stmt = PhoenixTransactSQL.prepareScanMetricMetadataSqlStmt(conn, metadataQueryCondition);
        try {
            if (stmt != null) {
                rs = stmt.executeQuery();
                while (rs.next()) {
                    byte[] uuid = rs.getBytes("UUID");
                    if (uuid == null) continue;
                    uuidList.add(uuid);
                }
            }
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException sQLException) {}
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return uuidList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<TimelineMetricMetadataKey, TimelineMetricMetadata> getTimelineMetricMetadataV1() throws SQLException {
        HashMap<TimelineMetricMetadataKey, TimelineMetricMetadata> metadataMap = new HashMap<TimelineMetricMetadataKey, TimelineMetricMetadata>();
        Connection conn = this.getConnection();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.prepareStatement("SELECT METRIC_NAME, APP_ID, UNITS, TYPE, START_TIME, SUPPORTS_AGGREGATION, IS_WHITELISTED FROM METRICS_METADATA");
            rs = stmt.executeQuery();
            while (rs.next()) {
                String metricName = rs.getString("METRIC_NAME");
                String appId = rs.getString("APP_ID");
                TimelineMetricMetadata metadata = new TimelineMetricMetadata(metricName, appId, null, rs.getString("UNITS"), rs.getString("TYPE"), Long.valueOf(rs.getLong("START_TIME")), rs.getBoolean("SUPPORTS_AGGREGATION"), rs.getBoolean("IS_WHITELISTED"));
                TimelineMetricMetadataKey key = new TimelineMetricMetadataKey(metricName, appId, null);
                metadata.setIsPersisted(false);
                metadataMap.put(key, metadata);
            }
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException sQLException) {}
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return metadataMap;
    }

    public void setMetadataInstance(TimelineMetricMetadataManager metadataManager) {
        this.metadataManagerInstance = metadataManager;
        TIMELINE_METRIC_READ_HELPER = new TimelineMetricReadHelper(this.metadataManagerInstance);
    }

    private byte[] checkForNull(byte[] uuid) {
        if (uuid != null) {
            for (byte b : uuid) {
                if (b == 0) continue;
                return uuid;
            }
        }
        return null;
    }
}

