/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ambari.metrics.core.loadsimulator.util;

public class TimeStampProvider {
    private int timeStep;
    private long currentTime;
    private int sendInterval;

    public TimeStampProvider(long startTime, int timeStep, int sendInterval) {
        this.timeStep = timeStep;
        this.currentTime = startTime - (long)timeStep;
        this.sendInterval = sendInterval;
    }

    public long next() {
        return this.currentTime += (long)this.timeStep;
    }

    public long[] timestampsForNextInterval() {
        return this.timestampsForInterval(this.sendInterval);
    }

    private long[] timestampsForInterval(int sendInterval) {
        int steps = sendInterval / this.timeStep;
        long[] timestamps = new long[steps];
        for (int i = 0; i < timestamps.length; ++i) {
            timestamps[i] = this.next();
        }
        return timestamps;
    }
}

