/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ambari.metrics.core.loadsimulator.net;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;

public class UrlService {
    public static final int CONNECT_TIMEOUT = 20000;
    public static final int READ_TIMEOUT = 20000;
    private final String address;
    private HttpURLConnection conn;

    private UrlService(String address) {
        this.address = address;
    }

    public static UrlService newConnection(String address) throws IOException {
        UrlService svc = new UrlService(address);
        svc.connect();
        return svc;
    }

    public HttpURLConnection connect() throws IOException {
        URL url = new URL(this.address);
        this.conn = (HttpURLConnection)url.openConnection();
        this.conn.setConnectTimeout(20000);
        this.conn.setReadTimeout(20000);
        this.conn.setDoInput(true);
        this.conn.setDoOutput(true);
        this.conn.setRequestMethod("POST");
        this.conn.setRequestProperty("Content-Type", "application/json");
        this.conn.setRequestProperty("Accept", "*/*");
        return this.conn;
    }

    public String send(String payload) throws IOException {
        if (this.conn == null) {
            throw new IllegalStateException("Cannot use unconnected UrlService");
        }
        this.write(payload);
        return this.read();
    }

    private String read() throws IOException {
        StringBuilder response = new StringBuilder();
        BufferedReader br = new BufferedReader(new InputStreamReader(this.conn.getInputStream()));
        String line = null;
        while ((line = br.readLine()) != null) {
            response.append(line);
        }
        br.close();
        return response.toString();
    }

    private void write(String payload) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter(this.conn.getOutputStream(), "UTF-8");
        writer.write(payload);
        writer.close();
    }

    public void disconnect() {
        this.conn.disconnect();
    }
}

