/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ambari.metrics.core.loadsimulator.net;

import com.google.common.base.Stopwatch;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.ambari.metrics.core.loadsimulator.net.MetricsSender;
import org.apache.ambari.metrics.core.loadsimulator.net.UrlService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestMetricsSender
implements MetricsSender {
    private static final Logger LOG = LoggerFactory.getLogger(RestMetricsSender.class);
    private static final String COLLECTOR_URL = "http://%s/ws/v1/timeline/metrics";
    private final String collectorServiceAddress;

    public RestMetricsSender(String metricsHost) {
        this.collectorServiceAddress = String.format(COLLECTOR_URL, metricsHost);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String pushMetrics(String payload) {
        String responseString = "";
        UrlService svc = null;
        Stopwatch timer = Stopwatch.createStarted();
        try {
            LOG.info("server: {}", (Object)this.collectorServiceAddress);
            svc = this.getConnectedUrlService();
            responseString = svc.send(payload);
            timer.stop();
            LOG.info("http response time: " + timer.elapsed(TimeUnit.MILLISECONDS) + " ms");
            if (responseString.length() > 0) {
                LOG.debug("POST response from server: " + responseString);
            }
        }
        catch (IOException e) {
            LOG.error("", (Throwable)e);
        }
        finally {
            if (svc != null) {
                svc.disconnect();
            }
        }
        return responseString;
    }

    protected UrlService getConnectedUrlService() throws IOException {
        return UrlService.newConnection(this.collectorServiceAddress);
    }
}

