/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ambari.metrics.core.loadsimulator.data;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import org.apache.ambari.metrics.core.loadsimulator.data.AppID;
import org.apache.ambari.metrics.core.loadsimulator.data.ApplicationInstance;
import org.apache.ambari.metrics.core.loadsimulator.data.HostMetricsGenerator;
import org.apache.ambari.metrics.core.loadsimulator.util.RandomMetricsProvider;
import org.apache.ambari.metrics.core.loadsimulator.util.TimeStampProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsGeneratorConfigurer {
    private static final Logger LOG = LoggerFactory.getLogger(MetricsGeneratorConfigurer.class);

    public static HostMetricsGenerator createMetricsForHost(ApplicationInstance id, TimeStampProvider timeStamps) {
        return new HostMetricsGenerator(id, timeStamps, MetricsGeneratorConfigurer.readMetrics(id.getAppId()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, RandomMetricsProvider> readMetrics(AppID type) {
        InputStream input = null;
        HashMap<String, RandomMetricsProvider> metrics = new HashMap<String, RandomMetricsProvider>();
        String fileName = "metrics_def/" + type.toString() + ".dat";
        try {
            String line;
            LOG.info("Loading " + fileName);
            input = MetricsGeneratorConfigurer.class.getClassLoader().getResourceAsStream(fileName);
            BufferedReader reader = new BufferedReader(new InputStreamReader(input));
            while ((line = reader.readLine()) != null) {
                metrics.put(line.trim(), new RandomMetricsProvider(100.0, 200.0));
            }
        }
        catch (IOException e) {
            LOG.error("Cannot read file " + fileName + " for appID " + type.toString(), (Throwable)e);
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException iOException) {}
            }
        }
        return metrics;
    }
}

