/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ambari.metrics.core.loadsimulator.data;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.ambari.metrics.core.loadsimulator.data.ApplicationInstance;

public class Metric {
    private String instanceid;
    private String hostname;
    private Map<String, String> metrics = new LinkedHashMap<String, String>();
    private String starttime;
    private String appid;
    private String metricname;

    public Metric() {
    }

    public Metric(ApplicationInstance app, String metricName, long startTime) {
        this.hostname = app.getHostName();
        this.appid = app.getAppId().getId();
        this.instanceid = app.getInstanceId();
        this.metricname = metricName;
        this.starttime = Long.toString(startTime);
    }

    public void putMetric(long timestamp, String value) {
        this.metrics.put(Long.toString(timestamp), value);
    }

    public String getInstanceid() {
        return this.instanceid;
    }

    public String getHostname() {
        return this.hostname;
    }

    public Map<String, String> getMetrics() {
        return this.metrics;
    }

    public String getStarttime() {
        return this.starttime;
    }

    public String getAppid() {
        return this.appid;
    }

    public String getMetricname() {
        return this.metricname;
    }
}

