/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ambari.metrics.core.loadsimulator.data;

import java.util.HashMap;
import java.util.Map;
import org.apache.ambari.metrics.core.loadsimulator.data.AppMetrics;
import org.apache.ambari.metrics.core.loadsimulator.data.ApplicationInstance;
import org.apache.ambari.metrics.core.loadsimulator.data.Metric;
import org.apache.ambari.metrics.core.loadsimulator.util.RandomMetricsProvider;
import org.apache.ambari.metrics.core.loadsimulator.util.TimeStampProvider;

public class HostMetricsGenerator {
    private Map<String, RandomMetricsProvider> metricDataProviders = new HashMap<String, RandomMetricsProvider>();
    private final TimeStampProvider tsp;
    private final ApplicationInstance id;

    public HostMetricsGenerator(ApplicationInstance id, TimeStampProvider timeStamps, Map<String, RandomMetricsProvider> metricDataProviders) {
        this.id = id;
        this.tsp = timeStamps;
        this.metricDataProviders = metricDataProviders;
    }

    public AppMetrics createMetrics() {
        long[] timestamps = this.tsp.timestampsForNextInterval();
        AppMetrics appMetrics = new AppMetrics(this.id, timestamps[0]);
        for (Map.Entry<String, RandomMetricsProvider> entry : this.metricDataProviders.entrySet()) {
            String metricName = entry.getKey();
            RandomMetricsProvider metricData = entry.getValue();
            Metric metric = appMetrics.createMetric(metricName);
            for (long timestamp : timestamps) {
                metric.putMetric(timestamp, String.valueOf(metricData.next()));
            }
            appMetrics.addMetric(metric);
        }
        return appMetrics;
    }
}

