/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ambari.metrics.core.loadsimulator;

import java.io.IOException;
import java.util.concurrent.Callable;
import org.apache.ambari.metrics.core.loadsimulator.data.AppMetrics;
import org.apache.ambari.metrics.core.loadsimulator.data.HostMetricsGenerator;
import org.apache.ambari.metrics.core.loadsimulator.net.MetricsSender;
import org.apache.ambari.metrics.core.loadsimulator.net.RestMetricsSender;
import org.apache.ambari.metrics.core.loadsimulator.util.Json;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsSenderWorker
implements Callable<String> {
    private static final Logger LOG = LoggerFactory.getLogger(RestMetricsSender.class);
    MetricsSender sender;
    HostMetricsGenerator hmg;

    public MetricsSenderWorker(MetricsSender sender, HostMetricsGenerator metricsGenerator) {
        this.sender = sender;
        this.hmg = metricsGenerator;
    }

    @Override
    public String call() throws Exception {
        AppMetrics hostMetrics = this.hmg.createMetrics();
        try {
            String request = new Json().serialize(hostMetrics);
            String response = this.sender.pushMetrics(request);
            return response;
        }
        catch (IOException e) {
            LOG.error("Error while pushing metrics: ", (Throwable)e);
            throw e;
        }
    }
}

