/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ambari.metrics.core.loadsimulator;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.ambari.metrics.core.loadsimulator.LoadRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsLoadSimulator {
    private static final Logger LOG = LoggerFactory.getLogger(MetricsLoadSimulator.class);

    public static void main(String[] args) throws IOException, InterruptedException {
        Map<String, String> mapArgs = MetricsLoadSimulator.parseArgs(args);
        LoadRunner loadRunner = new LoadRunner(mapArgs.get("hostName"), Integer.valueOf(mapArgs.get("numberOfHosts")), mapArgs.get("metricsHostName"), mapArgs.get("minHostIndex") == null ? 0 : Integer.valueOf(mapArgs.get("minHostIndex")), Integer.valueOf(mapArgs.get("collectInterval")), Integer.valueOf(mapArgs.get("sendInterval")), Boolean.valueOf(mapArgs.get("master")));
        loadRunner.start();
    }

    public static void startTest(Map<String, String> mapArgs) {
        LoadRunner loadRunner = new LoadRunner(mapArgs.get("hostName"), Integer.valueOf(mapArgs.get("numberOfHosts")), mapArgs.get("metricsHostName"), mapArgs.get("minHostIndex") == null ? 0 : Integer.valueOf(mapArgs.get("minHostIndex")), Integer.valueOf(mapArgs.get("collectInterval")), Integer.valueOf(mapArgs.get("sendInterval")), Boolean.valueOf(mapArgs.get("master")));
        loadRunner.start();
    }

    private static Map<String, String> parseArgs(String[] args) {
        HashMap<String, String> mapProps = new HashMap<String, String>();
        mapProps.put("hostName", "host");
        mapProps.put("numberOfHosts", "20");
        mapProps.put("trafficType", "burst");
        mapProps.put("metricsHostName", "localhost");
        mapProps.put("collectInterval", "10000");
        mapProps.put("sendInterval", "60000");
        if (args.length == 0) {
            MetricsLoadSimulator.printUsage();
            throw new RuntimeException("Unexpected argument, See usage message.");
        }
        for (int i = 0; i < args.length; i += 2) {
            String arg = args[i];
            if (arg.equals("-h")) {
                mapProps.put("hostName", args[i + 1]);
                continue;
            }
            if (arg.equals("-n")) {
                mapProps.put("numberOfHosts", args[i + 1]);
                continue;
            }
            if (arg.equals("-t")) {
                mapProps.put("trafficType", args[i + 1]);
                continue;
            }
            if (arg.equals("-m")) {
                mapProps.put("metricsHostName", args[i + 1]);
                continue;
            }
            if (arg.equals("-c")) {
                mapProps.put("collectInterval", args[i + 1]);
                continue;
            }
            if (arg.equals("-s")) {
                mapProps.put("sendInterval", args[i + 1]);
                continue;
            }
            if (arg.equals("-M")) {
                mapProps.put("master", args[i + 1]);
                continue;
            }
            if (arg.equals("-d")) continue;
            MetricsLoadSimulator.printUsage();
            throw new RuntimeException("Unexpected argument, See usage message.");
        }
        LOG.info("Recognized options: baseHostName={} hosts#={} trafficMode={} metricsHostName={} collectIntervalMillis={} sendIntervalMillis={} simulateMaster={}", new Object[]{mapProps.get("hostName"), Integer.valueOf((String)mapProps.get("numberOfHosts")), mapProps.get("trafficType"), mapProps.get("metricsHostName"), Integer.valueOf((String)mapProps.get("collectInterval")), Integer.valueOf((String)mapProps.get("sendInterval")), Boolean.valueOf((String)mapProps.get("master"))});
        return mapProps;
    }

    public static void printUsage() {
        System.err.println("Usage: java MetricsLoadSimulator [OPTIONS]");
        System.err.println("Options: ");
        System.err.println("[-h hostName] [-n numberOfHosts] [-t trafficMode {burst, staggered}] [-m metricsHostName] [-c collectIntervalMillis {10 sec}] [-s sendIntervalMillis {60 sec}][-M simulateMaster {true, false}] ");
        System.err.println();
        System.err.println("When you select a master, then one simulated host will play");
        System.err.println("a role of a master, and the rest will be slaves. Otherwise");
        System.err.println("all simulation threads (single thread is for single host)");
        System.err.println("will be slave hosts");
    }
}

