/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ambari.metrics.core.loadsimulator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.ambari.metrics.core.loadsimulator.MetricsSenderWorker;
import org.apache.ambari.metrics.core.loadsimulator.data.AppID;
import org.apache.ambari.metrics.core.loadsimulator.data.ApplicationInstance;
import org.apache.ambari.metrics.core.loadsimulator.data.HostMetricsGenerator;
import org.apache.ambari.metrics.core.loadsimulator.data.MetricsGeneratorConfigurer;
import org.apache.ambari.metrics.core.loadsimulator.net.RestMetricsSender;
import org.apache.ambari.metrics.core.loadsimulator.util.TimeStampProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadRunner {
    private static final Logger LOG = LoggerFactory.getLogger(LoadRunner.class);
    private final ScheduledExecutorService timer;
    private final ExecutorService workersPool;
    private final Collection<Callable<String>> workers;
    private final long startTime = new Date().getTime();
    private final int collectIntervalMillis;
    private final int sendIntervalMillis;

    public LoadRunner(String hostName, int threadCount, String metricsHostName, int minHostIndex, int collectIntervalMillis, int sendIntervalMillis, boolean createMaster) {
        this.collectIntervalMillis = collectIntervalMillis;
        this.workersPool = Executors.newFixedThreadPool(threadCount);
        this.timer = Executors.newScheduledThreadPool(1);
        this.sendIntervalMillis = sendIntervalMillis;
        this.workers = this.prepareWorkers(hostName, threadCount, metricsHostName, createMaster, minHostIndex);
    }

    private Collection<Callable<String>> prepareWorkers(String hostName, int threadCount, String metricsHost, Boolean createMaster, int minHostIndex) {
        ArrayList<Callable<String>> senderWorkers = new ArrayList<Callable<String>>(threadCount);
        int startIndex = minHostIndex;
        if (createMaster.booleanValue()) {
            String simHost = hostName + startIndex;
            this.addMetricsWorkers(senderWorkers, simHost, metricsHost, AppID.MASTER_APPS);
            ++startIndex;
        }
        for (int i = startIndex; i < threadCount + minHostIndex; ++i) {
            String simHost = hostName + i;
            this.addMetricsWorkers(senderWorkers, simHost, metricsHost, AppID.SLAVE_APPS);
        }
        return senderWorkers;
    }

    private void addMetricsWorkers(Collection<Callable<String>> senderWorkers, String specificHostName, String metricsHostName, AppID[] apps) {
        for (AppID app : apps) {
            HostMetricsGenerator metricsGenerator = this.createApplicationMetrics(specificHostName, app);
            RestMetricsSender sender = new RestMetricsSender(metricsHostName);
            senderWorkers.add(new MetricsSenderWorker(sender, metricsGenerator));
        }
    }

    private HostMetricsGenerator createApplicationMetrics(String simHost, AppID host) {
        ApplicationInstance appInstance = new ApplicationInstance(simHost, host, "");
        TimeStampProvider timeStampProvider = new TimeStampProvider(this.startTime, this.collectIntervalMillis, this.sendIntervalMillis);
        return MetricsGeneratorConfigurer.createMetricsForHost(appInstance, timeStampProvider);
    }

    public void start() {
        this.timer.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    LoadRunner.this.runOnce();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }, 0L, this.sendIntervalMillis, TimeUnit.MILLISECONDS);
    }

    public void runOnce() throws InterruptedException {
        List<Future<String>> futures = this.workersPool.invokeAll(this.workers, this.sendIntervalMillis / 2, TimeUnit.MILLISECONDS);
        int done = 0;
        for (Future<String> future : futures) {
            done += future.isDone() ? 1 : 0;
        }
        LOG.info("Finished successfully " + done + " tasks ");
    }

    public void shutdown() {
        this.timer.shutdownNow();
        this.workersPool.shutdownNow();
    }

    public static void main(String[] args) {
        LoadRunner runner = new LoadRunner("local", 0, "metrics", 0, 10000, 20000, false);
        runner.start();
    }
}

