/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ambari.metrics;

import org.apache.ambari.metrics.core.timeline.HBaseTimelineMetricsService;
import org.apache.ambari.metrics.core.timeline.TimelineMetricConfiguration;
import org.apache.ambari.metrics.core.timeline.TimelineMetricStore;
import org.apache.ambari.metrics.webapp.AMSWebApp;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.http.HttpConfig;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.source.JvmMetrics;
import org.apache.hadoop.service.CompositeService;
import org.apache.hadoop.util.ExitUtil;
import org.apache.hadoop.util.ShutdownHookManager;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.YarnUncaughtExceptionHandler;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.webapp.WebApp;
import org.apache.hadoop.yarn.webapp.WebApps;

public class AMSApplicationServer
extends CompositeService {
    public static final int SHUTDOWN_HOOK_PRIORITY = 30;
    private static final Log LOG = LogFactory.getLog(AMSApplicationServer.class);
    TimelineMetricStore timelineMetricStore;
    private WebApp webApp;
    private TimelineMetricConfiguration metricConfiguration;

    public AMSApplicationServer() {
        super(AMSApplicationServer.class.getName());
    }

    protected void serviceInit(Configuration conf) throws Exception {
        this.metricConfiguration = TimelineMetricConfiguration.getInstance();
        this.metricConfiguration.initialize();
        this.timelineMetricStore = this.createTimelineMetricStore(conf);
        this.addIfService(this.timelineMetricStore);
        super.serviceInit(conf);
    }

    protected void serviceStart() throws Exception {
        DefaultMetricsSystem.initialize((String)"AmbariMetricsSystem");
        JvmMetrics.initSingleton((String)"AmbariMetricsSystem", null);
        this.startWebApp();
        super.serviceStart();
    }

    protected void serviceStop() throws Exception {
        if (this.webApp != null) {
            this.webApp.stop();
        }
        DefaultMetricsSystem.shutdown();
        super.serviceStop();
    }

    static AMSApplicationServer launchAMSApplicationServer(String[] args) {
        Thread.setDefaultUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new YarnUncaughtExceptionHandler());
        StringUtils.startupShutdownMessage(AMSApplicationServer.class, (String[])args, (Log)LOG);
        AMSApplicationServer amsApplicationServer = null;
        try {
            amsApplicationServer = new AMSApplicationServer();
            ShutdownHookManager.get().addShutdownHook((Runnable)new CompositeService.CompositeServiceShutdownHook((CompositeService)amsApplicationServer), 30);
            YarnConfiguration conf = new YarnConfiguration();
            amsApplicationServer.init((Configuration)conf);
            amsApplicationServer.start();
        }
        catch (Throwable t) {
            LOG.fatal((Object)"Error starting AMSApplicationServer", t);
            ExitUtil.terminate((int)-1, (String)"Error starting AMSApplicationServer");
        }
        return amsApplicationServer;
    }

    public static void main(String[] args) {
        AMSApplicationServer.launchAMSApplicationServer(args);
    }

    protected TimelineMetricStore createTimelineMetricStore(Configuration conf) {
        LOG.info((Object)"Creating metrics store.");
        return new HBaseTimelineMetricsService(this.metricConfiguration);
    }

    protected void startWebApp() {
        String bindAddress = null;
        try {
            bindAddress = this.metricConfiguration.getWebappAddress();
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError("Cannot find bind address");
        }
        LOG.info((Object)("Instantiating metrics collector at " + bindAddress));
        try {
            Configuration conf = this.metricConfiguration.getMetricsConf();
            conf.set("hadoop.http.max.threads", String.valueOf(this.metricConfiguration.getTimelineMetricsServiceHandlerThreadCount()));
            HttpConfig.Policy policy = HttpConfig.Policy.valueOf((String)conf.get("timeline.metrics.service.http.policy", HttpConfig.Policy.HTTP_ONLY.name()));
            this.webApp = WebApps.$for((String)"timeline", null, null, (String)"ws").withHttpPolicy(conf, policy).at(bindAddress).start((WebApp)new AMSWebApp(this.timelineMetricStore));
        }
        catch (Exception e) {
            String msg = "AHSWebApp failed to start.";
            LOG.error((Object)msg, (Throwable)e);
            throw new YarnRuntimeException(msg, (Throwable)e);
        }
    }
}

