/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ambari.view.filebrowser;

import org.apache.ambari.view.ClusterType;
import org.apache.ambari.view.ViewInstanceDefinition;
import org.apache.ambari.view.utils.ambari.ValidatorUtils;
import org.apache.ambari.view.validation.ValidationResult;
import org.apache.ambari.view.validation.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyValidator
implements Validator {
    protected static final Logger LOG = LoggerFactory.getLogger(PropertyValidator.class);
    public static final String WEBHDFS_URL = "webhdfs.url";

    public ValidationResult validateInstance(ViewInstanceDefinition viewInstanceDefinition, Validator.ValidationContext validationContext) {
        return null;
    }

    public ValidationResult validateProperty(String property, ViewInstanceDefinition viewInstanceDefinition, Validator.ValidationContext validationContext) {
        String webhdfsUrl;
        ClusterType clusterType = viewInstanceDefinition.getClusterType();
        if (clusterType == ClusterType.LOCAL_AMBARI || clusterType == ClusterType.REMOTE_AMBARI) {
            return ValidationResult.SUCCESS;
        }
        if (property.equals(WEBHDFS_URL) && !ValidatorUtils.validateHdfsURL((String)(webhdfsUrl = (String)viewInstanceDefinition.getPropertyMap().get(WEBHDFS_URL)))) {
            LOG.error("Invalid webhdfs.url = {}", (Object)webhdfsUrl);
            return new InvalidPropertyValidationResult(false, "Must be valid URL");
        }
        return ValidationResult.SUCCESS;
    }

    public static class InvalidPropertyValidationResult
    implements ValidationResult {
        private boolean valid;
        private String detail;

        public InvalidPropertyValidationResult(boolean valid, String detail) {
            this.valid = valid;
            this.detail = detail;
        }

        public boolean isValid() {
            return this.valid;
        }

        public String getDetail() {
            return this.detail;
        }
    }
}

