/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ambari.view.filebrowser;

import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Map;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.ambari.view.ViewContext;
import org.apache.ambari.view.commons.exceptions.NotFoundFormattedException;
import org.apache.ambari.view.commons.exceptions.ServiceFormattedException;
import org.apache.ambari.view.commons.hdfs.HdfsService;
import org.apache.ambari.view.utils.hdfs.HdfsApi;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.json.simple.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilePreviewService
extends HdfsService {
    protected static final Logger LOG = LoggerFactory.getLogger(FilePreviewService.class);
    private CompressionCodecFactory compressionCodecFactory;

    public FilePreviewService(ViewContext context) {
        super(context);
        this.initCompressionCodecFactory();
    }

    private void initCompressionCodecFactory() {
        Configuration conf = new Configuration();
        conf.set("io.compression.codecs", "org.apache.hadoop.io.compress.GzipCodec,org.apache.hadoop.io.compress.DefaultCodec,org.apache.hadoop.io.compress.SnappyCodec,org.apache.hadoop.io.compress.BZip2Codec");
        this.compressionCodecFactory = new CompressionCodecFactory(conf);
    }

    public FilePreviewService(ViewContext context, Map<String, String> viewConfigs) {
        super(context, viewConfigs);
        this.initCompressionCodecFactory();
    }

    @GET
    @Path(value="/file")
    @Produces(value={"application/json"})
    public Response previewFile(@QueryParam(value="path") String path, @QueryParam(value="start") int start, @QueryParam(value="end") int end) {
        LOG.info("previewing file {}, from start {}, till end {}", new Object[]{path, start, end});
        try {
            HdfsApi api = this.getApi();
            FileStatus status = api.getFileStatus(path);
            CompressionCodec codec = this.compressionCodecFactory.getCodec(status.getPath());
            FSDataInputStream stream = codec != null ? codec.createInputStream((InputStream)api.open(path)) : api.open(path);
            int length = end - start;
            byte[] bytes = new byte[length];
            if (start != 0) {
                IOUtils.skip((InputStream)stream, (long)start);
            }
            int readBytes = IOUtils.read((InputStream)stream, (byte[])bytes);
            boolean isFileEnd = false;
            if (readBytes < length) {
                isFileEnd = true;
            }
            JSONObject response = new JSONObject();
            response.put((Object)"data", (Object)new String(bytes));
            response.put((Object)"readbytes", (Object)readBytes);
            response.put((Object)"isFileEnd", (Object)isFileEnd);
            return Response.ok((Object)response).build();
        }
        catch (WebApplicationException ex) {
            LOG.error("Error occurred while previewing {} : ", (Object)path, (Object)ex);
            throw ex;
        }
        catch (FileNotFoundException ex) {
            LOG.error("Error occurred while previewing {} : ", (Object)path, (Object)ex);
            throw new NotFoundFormattedException(ex.getMessage(), (Throwable)ex);
        }
        catch (Exception ex) {
            LOG.error("Error occurred while previewing {} : ", (Object)path, (Object)ex);
            throw new ServiceFormattedException(ex.getMessage(), (Throwable)ex);
        }
    }
}

