/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ambari.view.filebrowser;

import com.google.common.base.Optional;
import com.google.inject.Inject;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.Path;
import org.apache.ambari.view.ViewContext;
import org.apache.ambari.view.commons.hdfs.FileOperationService;
import org.apache.ambari.view.commons.hdfs.UploadService;
import org.apache.ambari.view.commons.hdfs.UserService;
import org.apache.ambari.view.commons.hdfs.ViewPropertyHelper;
import org.apache.ambari.view.filebrowser.DownloadService;
import org.apache.ambari.view.filebrowser.FilePreviewService;
import org.apache.ambari.view.filebrowser.HelpService;

public class FileBrowserService {
    public static final String VIEW_CONF_KEYVALUES = "view.conf.keyvalues";
    @Inject
    ViewContext context;

    @Path(value="/download")
    public DownloadService download() {
        return new DownloadService(this.context, this.getViewConfigs());
    }

    private Map<String, String> getViewConfigs() {
        Optional props = ViewPropertyHelper.getViewConfigs((ViewContext)this.context, (String)VIEW_CONF_KEYVALUES);
        return props.isPresent() ? (Map)props.get() : new HashMap();
    }

    @Path(value="/upload")
    public UploadService upload() {
        return new UploadService(this.context, this.getViewConfigs());
    }

    @Path(value="/fileops")
    public FileOperationService fileOps() {
        return new FileOperationService(this.context, this.getViewConfigs());
    }

    @Path(value="/help")
    public HelpService help() {
        return new HelpService(this.context, this.getViewConfigs());
    }

    @Path(value="/user")
    public UserService userService() {
        return new UserService(this.context, this.getViewConfigs());
    }

    @Path(value="/preview")
    public FilePreviewService preview() {
        return new FilePreviewService(this.context, this.getViewConfigs());
    }
}

