/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ambari.view.filebrowser;

import com.google.gson.Gson;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.FileNameMap;
import java.net.URLConnection;
import java.util.LinkedList;
import java.util.Map;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import javax.ws.rs.core.UriInfo;
import javax.xml.bind.annotation.XmlElement;
import org.apache.ambari.view.ViewContext;
import org.apache.ambari.view.commons.exceptions.MisconfigurationFormattedException;
import org.apache.ambari.view.commons.exceptions.NotFoundFormattedException;
import org.apache.ambari.view.commons.exceptions.ServiceFormattedException;
import org.apache.ambari.view.commons.hdfs.HdfsService;
import org.apache.ambari.view.utils.hdfs.HdfsApi;
import org.apache.ambari.view.utils.hdfs.HdfsApiException;
import org.apache.ambari.view.utils.hdfs.HdfsUtil;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.security.AccessControlException;
import org.json.simple.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DownloadService
extends HdfsService {
    protected static final Logger LOG = LoggerFactory.getLogger(DownloadService.class);
    private Gson gson = new Gson();

    public DownloadService(ViewContext context) {
        super(context);
    }

    public DownloadService(ViewContext context, Map<String, String> customProperties) {
        super(context, customProperties);
    }

    @GET
    @Path(value="/browse")
    @Produces(value={"text/plain"})
    public Response browse(@QueryParam(value="path") String path, @QueryParam(value="download") boolean download, @QueryParam(value="checkperm") boolean checkperm, @Context HttpHeaders headers, @Context UriInfo ui) {
        LOG.debug("browsing path : {} with download : {}", (Object)path, (Object)download);
        try {
            HdfsApi api = this.getApi();
            FileStatus status = api.getFileStatus(path);
            FSDataInputStream fs = api.open(path);
            if (checkperm) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put((Object)"allowed", (Object)true);
                return Response.ok((Object)jsonObject).header("Content-Type", (Object)"application/json").build();
            }
            Response.ResponseBuilder result = Response.ok((Object)fs);
            if (download) {
                result.header("Content-Disposition", (Object)("attachment; filename=\"" + status.getPath().getName() + "\"")).type("application/octet-stream");
            } else {
                FileNameMap fileNameMap = URLConnection.getFileNameMap();
                String mimeType = fileNameMap.getContentTypeFor(status.getPath().getName());
                result.header("Content-Disposition", (Object)("filename=\"" + status.getPath().getName() + "\"")).type(mimeType);
            }
            return result.build();
        }
        catch (WebApplicationException ex) {
            LOG.error("Exception while browsing : {}", (Object)path, (Object)ex);
            throw ex;
        }
        catch (FileNotFoundException ex) {
            LOG.error("File not found while browsing : {}", (Object)path, (Object)ex);
            throw new NotFoundFormattedException(ex.getMessage(), (Throwable)ex);
        }
        catch (Exception ex) {
            LOG.error("Exception while browsing : {}", (Object)path, (Object)ex);
            throw new ServiceFormattedException(ex.getMessage(), (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zipFile(ZipOutputStream zip, String path) {
        try {
            FSDataInputStream in = this.getApi().open(path);
            zip.putNextEntry(new ZipEntry(path.substring(1)));
            byte[] chunk = new byte[1024];
            int readLen = 0;
            while (readLen != -1) {
                zip.write(chunk, 0, readLen);
                readLen = in.read(chunk);
            }
        }
        catch (IOException ex) {
            LOG.error("Error zipping file {}  (file ignored): ", (Object)path, (Object)ex);
        }
        catch (InterruptedException ex) {
            LOG.error("Error zipping file {} (file ignored): ", (Object)path, (Object)ex);
        }
        finally {
            try {
                zip.closeEntry();
            }
            catch (IOException ex) {
                LOG.error("Error closing entry {} (file ignored): ", (Object)path, (Object)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zipDirectory(ZipOutputStream zip, String path) {
        try {
            zip.putNextEntry(new ZipEntry(path.substring(1) + "/"));
        }
        catch (IOException ex) {
            LOG.error("Error zipping directory {} (directory ignored).", (Object)path, (Object)ex);
        }
        finally {
            try {
                zip.closeEntry();
            }
            catch (IOException ex) {
                LOG.error("Error zipping directory {} (directory ignored).", (Object)path, (Object)ex);
            }
        }
    }

    @POST
    @Path(value="/zip")
    @Consumes(value={"application/json"})
    @Produces(value={"application/octet-stream"})
    public Response downloadGZip(final DownloadRequest request) {
        LOG.debug("downloadGZip requested for : {} ", (Object[])request.entries);
        try {
            String name = "hdfs.zip";
            if (request.entries.length == 1) {
                name = new File(request.entries[0]).getName() + ".zip";
            }
            StreamingOutput result = new StreamingOutput(){

                public void write(OutputStream output) throws IOException, ServiceFormattedException {
                    try (ZipOutputStream zip = new ZipOutputStream(output);){
                        HdfsApi api = DownloadService.this.getApi();
                        LinkedList<String> files = new LinkedList<String>();
                        for (String file : request.entries) {
                            files.add(file);
                        }
                        while (!files.isEmpty()) {
                            String path = (String)files.poll();
                            FileStatus status = api.getFileStatus(path);
                            if (status.isDirectory()) {
                                FileStatus[] subdir;
                                try {
                                    subdir = api.listdir(path);
                                }
                                catch (AccessControlException ex) {
                                    LOG.error("Error zipping directory {}/ (directory ignored) : ", (Object)path.substring(1), (Object)ex);
                                    continue;
                                }
                                for (FileStatus file : subdir) {
                                    files.add(org.apache.hadoop.fs.Path.getPathWithoutSchemeAndAuthority((org.apache.hadoop.fs.Path)file.getPath()).toString());
                                }
                                DownloadService.this.zipDirectory(zip, path);
                                continue;
                            }
                            DownloadService.this.zipFile(zip, path);
                        }
                    }
                }
            };
            return Response.ok((Object)result).header("Content-Disposition", (Object)("inline; filename=\"" + name + "\"")).build();
        }
        catch (WebApplicationException ex) {
            LOG.error("Error occurred : ", (Throwable)ex);
            throw ex;
        }
        catch (Exception ex) {
            LOG.error("Error occurred : ", (Throwable)ex);
            throw new ServiceFormattedException(ex.getMessage(), (Throwable)ex);
        }
    }

    @POST
    @Path(value="/concat")
    @Consumes(value={"application/json"})
    @Produces(value={"application/octet-stream"})
    public Response concat(final DownloadRequest request) {
        LOG.info("Starting concat files.");
        try {
            StreamingOutput result = new StreamingOutput(){

                public void write(OutputStream output) throws IOException, ServiceFormattedException {
                    FSDataInputStream in = null;
                    for (String path : request.entries) {
                        try {
                            try {
                                in = DownloadService.this.getApi().open(path);
                            }
                            catch (AccessControlException ex) {
                                LOG.error("Error in opening file {}. Ignoring concat of this files.", (Object)path.substring(1), (Object)ex);
                                if (in == null) continue;
                                in.close();
                                continue;
                            }
                            long bytesCopied = IOUtils.copyLarge((InputStream)in, (OutputStream)output);
                            LOG.info("concated file : {}, total bytes added = {}", (Object)path, (Object)bytesCopied);
                        }
                        catch (Exception ex) {
                            LOG.error("Error occurred : ", (Throwable)ex);
                            throw new ServiceFormattedException(ex.getMessage(), (Throwable)ex);
                        }
                        finally {
                            if (in != null) {
                                in.close();
                            }
                        }
                    }
                }
            };
            Response.ResponseBuilder response = Response.ok((Object)result);
            if (request.download) {
                response.header("Content-Disposition", (Object)"attachment; filename=\"concatResult.txt\"").type("application/octet-stream");
            } else {
                response.header("Content-Disposition", (Object)"filename=\"concatResult.txt\"").type("text/plain");
            }
            return response.build();
        }
        catch (WebApplicationException ex) {
            LOG.error("Error occurred ", (Throwable)ex);
            throw ex;
        }
        catch (Exception ex) {
            LOG.error("Error occurred ", (Throwable)ex);
            throw new ServiceFormattedException(ex.getMessage(), (Throwable)ex);
        }
    }

    @GET
    @Path(value="/zip")
    @Consumes(value={"application/json"})
    @Produces(value={"application/zip"})
    public Response zipByRequestId(@QueryParam(value="requestId") String requestId) {
        LOG.info("Starting zip download requestId : {}", (Object)requestId);
        try {
            DownloadRequest request = this.getDownloadRequest(requestId);
            return this.downloadGZip(request);
        }
        catch (WebApplicationException ex) {
            LOG.error("Error occurred : ", (Throwable)ex);
            throw ex;
        }
        catch (Exception ex) {
            LOG.error("Error occurred : ", (Throwable)ex);
            throw new ServiceFormattedException(ex.getMessage(), (Throwable)ex);
        }
    }

    @POST
    @Path(value="/zip/generate-link")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response zipGenerateLink(DownloadRequest request) {
        LOG.info("starting generate-link");
        return this.generateLink(request);
    }

    @GET
    @Path(value="/concat")
    @Consumes(value={"application/json"})
    @Produces(value={"application/octet-stream"})
    public Response concatByRequestId(@QueryParam(value="requestId") String requestId) {
        LOG.info("Starting concat for requestId : {}", (Object)requestId);
        try {
            DownloadRequest request = this.getDownloadRequest(requestId);
            return this.concat(request);
        }
        catch (WebApplicationException ex) {
            LOG.error("Error occurred : ", (Throwable)ex);
            throw ex;
        }
        catch (Exception ex) {
            LOG.error("Error occurred : ", (Throwable)ex);
            throw new ServiceFormattedException(ex.getMessage(), (Throwable)ex);
        }
    }

    @POST
    @Path(value="/concat/generate-link")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response concatGenerateLink(DownloadRequest request) {
        LOG.info("Starting link generation for concat");
        return this.generateLink(request);
    }

    private Response generateLink(DownloadRequest request) {
        try {
            String requestId = this.generateUniqueIdentifer(request);
            LOG.info("returning generated requestId : {}", (Object)requestId);
            JSONObject json = new JSONObject();
            json.put((Object)"requestId", (Object)requestId);
            return Response.ok((Object)json).build();
        }
        catch (WebApplicationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ServiceFormattedException(ex.getMessage(), (Throwable)ex);
        }
    }

    private DownloadRequest getDownloadRequest(String requestId) throws HdfsApiException, IOException, InterruptedException {
        String fileName = this.getFileNameForRequestData(requestId);
        String json = HdfsUtil.readFile((HdfsApi)this.getApi(), (String)fileName);
        DownloadRequest request = (DownloadRequest)this.gson.fromJson(json, DownloadRequest.class);
        this.deleteFileFromHdfs(fileName);
        return request;
    }

    private String generateUniqueIdentifer(DownloadRequest request) {
        String uuid = UUID.randomUUID().toString().replaceAll("-", "");
        String json = this.gson.toJson((Object)request);
        this.writeToHdfs(uuid, json);
        return uuid;
    }

    private void writeToHdfs(String uuid, String json) {
        String fileName = this.getFileNameForRequestData(uuid);
        try {
            HdfsUtil.putStringToFile((HdfsApi)this.getApi(), (String)fileName, (String)json);
        }
        catch (HdfsApiException e) {
            LOG.error("Failed to write request data to HDFS", (Throwable)e);
            throw new ServiceFormattedException("Failed to write request data to HDFS", (Throwable)e);
        }
    }

    private String getFileNameForRequestData(String uuid) {
        String tmpPath = (String)this.context.getProperties().get("tmp.dir");
        if (tmpPath == null) {
            LOG.error("tmp.dir is not configured!");
            throw new MisconfigurationFormattedException("tmp.dir");
        }
        return String.format(tmpPath + "/%s.json", uuid);
    }

    private void deleteFileFromHdfs(String fileName) throws IOException, InterruptedException {
        this.getApi().delete(fileName, true);
    }

    public static class DownloadRequest {
        @XmlElement(nillable=false, required=true)
        public String[] entries;
        @XmlElement(required=false)
        public boolean download;
    }
}

