/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ambari.view.utils;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.ambari.view.ViewContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserLocal<T> {
    private static final Logger LOG = LoggerFactory.getLogger(UserLocal.class);
    private static final Map<Class, Map<String, Object>> viewSingletonObjects = new ConcurrentHashMap<Class, Map<String, Object>>();
    private final Class<? extends T> tClass;
    private static final Map<String, ReentrantLock> locks = new HashMap<String, ReentrantLock>();

    public UserLocal(Class<? extends T> tClass) {
        this.tClass = tClass;
    }

    protected synchronized T initialValue(ViewContext context) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ReentrantLock getLockFor(String key) {
        LOG.info("Finding lock for : {}", (Object)key);
        if (null == locks.get(key)) {
            LOG.info("Lock not found for {} ", (Object)key);
            Map<String, ReentrantLock> map = locks;
            synchronized (map) {
                if (null == locks.get(key)) {
                    LOG.info("Creating lock for {} ", (Object)key);
                    locks.put(key, new ReentrantLock());
                }
            }
        }
        return locks.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get(ViewContext context) {
        if (!viewSingletonObjects.containsKey(this.tClass)) {
            Map<Class, Map<String, Object>> map = viewSingletonObjects;
            synchronized (map) {
                if (!viewSingletonObjects.containsKey(this.tClass)) {
                    viewSingletonObjects.put(this.tClass, new ConcurrentHashMap());
                }
            }
        }
        Map<String, Object> instances = viewSingletonObjects.get(this.tClass);
        String key = this.getTagName(context);
        LOG.debug("looking for key : {}", (Object)key);
        if (!instances.containsKey(key)) {
            String lockKey = this.tClass.getName() + "_" + key;
            LOG.info("key {} not found. getting lock for {}", (Object)key, (Object)lockKey);
            ReentrantLock lock = UserLocal.getLockFor(lockKey);
            boolean gotLock = lock.tryLock();
            if (!gotLock) {
                LOG.error("Lock could not be obtained for {}. Throwing exception.", (Object)lockKey);
                throw new RuntimeException(String.format("Failed to initialize %s for %s. Try Again.", this.tClass.getName(), key));
            }
            try {
                if (!instances.containsKey(key)) {
                    T initValue = this.initialValue(context);
                    LOG.info("Obtained initial value : {} for key : {}", initValue, (Object)key);
                    instances.put(key, initValue);
                }
            }
            finally {
                lock.unlock();
            }
        }
        return (T)instances.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(T obj, ViewContext context) {
        if (!viewSingletonObjects.containsKey(this.tClass)) {
            Map<Class, Map<String, Object>> map = viewSingletonObjects;
            synchronized (map) {
                if (!viewSingletonObjects.containsKey(this.tClass)) {
                    viewSingletonObjects.put(this.tClass, new ConcurrentHashMap());
                }
            }
        }
        String key = this.getTagName(context);
        LOG.info("setting key : value {} : {}", (Object)key, obj);
        Map<String, Object> instances = viewSingletonObjects.get(this.tClass);
        instances.put(key, obj);
    }

    public void remove(ViewContext context) {
        String key = this.getTagName(context);
        LOG.info("removing key : {}", (Object)key);
        Map<String, Object> instances = viewSingletonObjects.get(this.tClass);
        if (null != instances) {
            instances.remove(key);
        }
    }

    private String getTagName(ViewContext context) {
        if (context == null) {
            return "<null>";
        }
        return String.format("%s:%s", context.getInstanceName(), context.getUsername());
    }

    public static void dropAllConnections(Class tClass) {
        LOG.info("removing all {} ", (Object)tClass.getName());
        Map<String, Object> instances = viewSingletonObjects.get(tClass);
        if (instances != null) {
            instances.clear();
        }
    }

    public static void dropAllConnections() {
        LOG.info("clearing all viewSingletonObjects.");
        viewSingletonObjects.clear();
    }

    public static void dropInstanceCache(String instanceName) {
        LOG.info("removing all the keys for instanceName : {}", (Object)instanceName);
        for (Map<String, Object> cache : viewSingletonObjects.values()) {
            Iterator<Map.Entry<String, Object>> it = cache.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, Object> entry = it.next();
                if (!entry.getKey().startsWith(instanceName + ":")) continue;
                LOG.debug("removing key : {} ", (Object)entry.getKey());
                it.remove();
            }
        }
    }
}

