/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ambari.view.commons.hdfs;

import java.io.FileNotFoundException;
import java.util.Map;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.ambari.view.ViewContext;
import org.apache.ambari.view.commons.exceptions.NotFoundFormattedException;
import org.apache.ambari.view.commons.exceptions.ServiceFormattedException;
import org.apache.ambari.view.commons.hdfs.HdfsService;
import org.apache.ambari.view.utils.hdfs.HdfsApi;

public class UserService
extends HdfsService {
    public UserService(ViewContext context) {
        super(context);
    }

    public UserService(ViewContext context, Map<String, String> customProperties) {
        super(context, customProperties);
    }

    @GET
    @Path(value="/home")
    @Produces(value={"application/json"})
    public Response homeDir() {
        try {
            HdfsApi api = this.getApi();
            return Response.ok((Object)this.getApi().fileStatusToJSON(api.getFileStatus(api.getHomeDir().toString()))).build();
        }
        catch (WebApplicationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ServiceFormattedException(ex.getMessage(), ex);
        }
    }

    @GET
    @Path(value="/trash/enabled")
    @Produces(value={"application/json"})
    public Response trashEnabled() {
        try {
            HdfsApi api = this.getApi();
            return Response.ok((Object)new HdfsService.FileOperationResult(api.trashEnabled())).build();
        }
        catch (WebApplicationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ServiceFormattedException(ex.getMessage(), ex);
        }
    }

    @GET
    @Path(value="/trashDir")
    @Produces(value={"application/json"})
    public Response trashdir() {
        try {
            HdfsApi api = this.getApi();
            return Response.ok((Object)this.getApi().fileStatusToJSON(api.getFileStatus(api.getTrashDir().toString()))).build();
        }
        catch (WebApplicationException ex) {
            throw ex;
        }
        catch (FileNotFoundException ex) {
            throw new NotFoundFormattedException(ex.getMessage(), ex);
        }
        catch (Exception ex) {
            throw new ServiceFormattedException(ex.getMessage(), ex);
        }
    }
}

