/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ambari.view.commons.hdfs;

import com.sun.jersey.core.header.FormDataContentDisposition;
import com.sun.jersey.multipart.FormDataParam;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.ws.rs.Consumes;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.ambari.view.ViewContext;
import org.apache.ambari.view.commons.exceptions.ServiceFormattedException;
import org.apache.ambari.view.commons.hdfs.HdfsService;
import org.apache.ambari.view.utils.hdfs.HdfsApi;
import org.apache.hadoop.fs.FSDataOutputStream;

public class UploadService
extends HdfsService {
    public UploadService(ViewContext context) {
        super(context);
    }

    public UploadService(ViewContext context, Map<String, String> customProperties) {
        super(context, customProperties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void uploadFile(String filePath, InputStream uploadedInputStream) throws IOException, InterruptedException {
        byte[] chunk = new byte[1024];
        try (FSDataOutputStream out = null;){
            int read;
            out = this.getApi().create(filePath, false);
            while ((read = uploadedInputStream.read(chunk)) != -1) {
                out.write(chunk, 0, read);
            }
        }
    }

    @PUT
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"application/json"})
    public Response uploadFile(@FormDataParam(value="file") InputStream uploadedInputStream, @FormDataParam(value="file") FormDataContentDisposition contentDisposition, @FormDataParam(value="path") String path) {
        try {
            if (!path.endsWith("/")) {
                path = path + "/";
            }
            String filePath = path + new String(contentDisposition.getFileName().getBytes("ISO8859-1"), "UTF-8");
            this.uploadFile(filePath, uploadedInputStream);
            return Response.ok((Object)this.getApi().fileStatusToJSON(this.getApi().getFileStatus(filePath))).build();
        }
        catch (WebApplicationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ServiceFormattedException(ex.getMessage(), ex);
        }
    }

    @PUT
    @Path(value="/zip")
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"application/json"})
    public Response uploadZip(@FormDataParam(value="file") InputStream uploadedInputStream, @FormDataParam(value="file") FormDataContentDisposition contentDisposition, @FormDataParam(value="path") String path) {
        try {
            if (!path.endsWith("/")) {
                path = path + "/";
            }
            ZipInputStream zip = new ZipInputStream(uploadedInputStream);
            ZipEntry ze = zip.getNextEntry();
            HdfsApi api = this.getApi();
            while (ze != null) {
                String filePath = path + ze.getName();
                if (ze.isDirectory()) {
                    api.mkdir(filePath);
                } else {
                    this.uploadFile(filePath, zip);
                }
                ze = zip.getNextEntry();
            }
            return Response.ok((Object)this.getApi().fileStatusToJSON(api.listdir(path))).build();
        }
        catch (WebApplicationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ServiceFormattedException(ex.getMessage(), ex);
        }
    }
}

