/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ambari.view.commons.hdfs;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.WebApplicationException;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.ambari.view.ViewContext;
import org.apache.ambari.view.commons.exceptions.ServiceFormattedException;
import org.apache.ambari.view.utils.hdfs.HdfsApi;
import org.apache.ambari.view.utils.hdfs.HdfsUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HdfsService {
    protected static final Logger logger = LoggerFactory.getLogger(HdfsService.class);
    protected final ViewContext context;
    private Map<String, String> customProperties;
    private HdfsApi _api = null;

    public HdfsService(ViewContext context) {
        this.context = context;
    }

    public HdfsService(ViewContext context, Map<String, String> customProperties) {
        this.context = context;
        this.customProperties = customProperties;
    }

    public HdfsApi getApi() {
        if (this._api == null) {
            try {
                this._api = this.customProperties != null ? HdfsUtil.connectToHDFSApi((ViewContext)this.context, this.customProperties) : HdfsUtil.connectToHDFSApi((ViewContext)this.context);
            }
            catch (Exception ex) {
                logger.error("Exception while connecting to hdfs : {}", (Object)ex.getMessage(), (Object)ex);
                throw new ServiceFormattedException("HdfsApi connection failed. Check \"webhdfs.url\" property", ex);
            }
        }
        return this._api;
    }

    private static Map<String, String> getHdfsAuthParams(ViewContext context) {
        String auth = (String)context.getProperties().get("webhdfs.auth");
        HashMap<String, String> params = new HashMap<String, String>();
        if (auth == null || auth.isEmpty()) {
            auth = "auth=SIMPLE";
        }
        for (String param : auth.split(";")) {
            String[] keyvalue = param.split("=");
            if (keyvalue.length != 2) {
                logger.error("Can not parse authentication param " + param + " in " + auth);
                continue;
            }
            params.put(keyvalue[0], keyvalue[1]);
        }
        return params;
    }

    public String getDoAsUsername(ViewContext context) {
        String username = (String)context.getProperties().get("webhdfs.username");
        if (username == null || username.isEmpty()) {
            username = context.getUsername();
        }
        return username;
    }

    public static void hdfsSmokeTest(ViewContext context) {
        try {
            HdfsApi api = HdfsUtil.connectToHDFSApi((ViewContext)context);
            api.getStatus();
        }
        catch (WebApplicationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ServiceFormattedException(ex.getMessage(), ex);
        }
    }

    public String getRealUsername(ViewContext context) {
        String username = (String)context.getProperties().get("webhdfs.proxyuser");
        if (username == null || username.isEmpty()) {
            try {
                username = UserGroupInformation.getCurrentUser().getShortUserName();
            }
            catch (IOException e) {
                throw new ServiceFormattedException("HdfsApi connection failed. Can't get current user", e);
            }
        }
        return username;
    }

    @XmlRootElement
    public static class FileOperationResult {
        public boolean success;
        public String message;
        public List<String> succeeded;
        public List<String> failed;
        public List<String> unprocessed;

        public FileOperationResult(boolean success) {
            this.success = success;
        }

        public FileOperationResult(boolean success, String message) {
            this(success);
            this.message = message;
        }

        public FileOperationResult(boolean success, String message, List<String> succeeded, List<String> failed, List<String> unprocessed) {
            this(success, message);
            this.succeeded = succeeded;
            this.failed = failed;
            this.unprocessed = unprocessed;
        }
    }
}

