/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ambari.view.commons.hdfs;

import com.google.common.base.Strings;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.ambari.view.ViewContext;
import org.apache.ambari.view.commons.exceptions.NotFoundFormattedException;
import org.apache.ambari.view.commons.exceptions.ServiceFormattedException;
import org.apache.ambari.view.commons.hdfs.HdfsService;
import org.apache.ambari.view.utils.hdfs.DirListInfo;
import org.apache.ambari.view.utils.hdfs.DirStatus;
import org.apache.ambari.view.utils.hdfs.HdfsApi;
import org.apache.ambari.view.utils.hdfs.HdfsApiException;
import org.json.simple.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileOperationService
extends HdfsService {
    private static final Logger LOG = LoggerFactory.getLogger(FileOperationService.class);
    private static final String FILES_VIEW_MAX_FILE_PER_PAGE = "views.files.max.files.per.page";
    private static final int DEFAULT_FILES_VIEW_MAX_FILE_PER_PAGE = 5000;
    private Integer maxFilesPerPage = 5000;

    public FileOperationService(ViewContext context) {
        super(context);
        this.setMaxFilesPerPage(context);
    }

    private void setMaxFilesPerPage(ViewContext context) {
        String maxFilesPerPageProperty = context.getAmbariProperty(FILES_VIEW_MAX_FILE_PER_PAGE);
        LOG.info("maxFilesPerPageProperty = {}", (Object)maxFilesPerPageProperty);
        if (!Strings.isNullOrEmpty((String)maxFilesPerPageProperty)) {
            try {
                this.maxFilesPerPage = Integer.parseInt(maxFilesPerPageProperty);
            }
            catch (Exception e) {
                LOG.error("{} should be integer, but it is {}, using default value of {}", new Object[]{FILES_VIEW_MAX_FILE_PER_PAGE, maxFilesPerPageProperty, 5000});
            }
        }
    }

    public FileOperationService(ViewContext context, Map<String, String> customProperties) {
        super(context, customProperties);
        this.setMaxFilesPerPage(context);
    }

    @GET
    @Path(value="/listdir")
    @Produces(value={"application/json"})
    public Response listdir(@QueryParam(value="path") String path, @QueryParam(value="nameFilter") String nameFilter) {
        try {
            JSONObject response = new JSONObject();
            Map parentInfo = this.getApi().fileStatusToJSON(this.getApi().getFileStatus(path));
            DirStatus dirStatus = this.getApi().listdir(path, nameFilter, this.maxFilesPerPage.intValue());
            DirListInfo dirListInfo = dirStatus.getDirListInfo();
            parentInfo.put("originalSize", dirListInfo.getOriginalSize());
            parentInfo.put("truncated", dirListInfo.isTruncated());
            parentInfo.put("finalSize", dirListInfo.getFinalSize());
            parentInfo.put("nameFilter", dirListInfo.getNameFilter());
            response.put((Object)"files", (Object)this.getApi().fileStatusToJSON(dirStatus.getFileStatuses()));
            response.put((Object)"meta", (Object)parentInfo);
            return Response.ok((Object)response).build();
        }
        catch (WebApplicationException ex) {
            throw ex;
        }
        catch (FileNotFoundException ex) {
            throw new NotFoundFormattedException(ex.getMessage(), ex);
        }
        catch (Exception ex) {
            throw new ServiceFormattedException(ex.getMessage(), ex);
        }
    }

    @POST
    @Path(value="/rename")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response rename(SrcDstFileRequest request) {
        try {
            HdfsApi api = this.getApi();
            Response.ResponseBuilder result = api.rename(request.src, request.dst) ? Response.ok((Object)this.getApi().fileStatusToJSON(api.getFileStatus(request.dst))) : Response.ok((Object)new HdfsService.FileOperationResult(false, "Can't move '" + request.src + "' to '" + request.dst + "'")).status(422);
            return result.build();
        }
        catch (WebApplicationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ServiceFormattedException(ex.getMessage(), ex);
        }
    }

    @POST
    @Path(value="/chmod")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response chmod(ChmodRequest request) {
        try {
            HdfsApi api = this.getApi();
            Response.ResponseBuilder result = api.chmod(request.path, request.mode) ? Response.ok((Object)this.getApi().fileStatusToJSON(api.getFileStatus(request.path))) : Response.ok((Object)new HdfsService.FileOperationResult(false, "Can't chmod '" + request.path + "'")).status(422);
            return result.build();
        }
        catch (WebApplicationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ServiceFormattedException(ex.getMessage(), ex);
        }
    }

    @POST
    @Path(value="/move")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response move(MultiSrcDstFileRequest request, @Context HttpHeaders headers, @Context UriInfo ui) {
        try {
            Response.ResponseBuilder result;
            HdfsApi api = this.getApi();
            String message = "";
            List<String> sources = request.sourcePaths;
            String destination = request.destinationPath;
            if (sources.isEmpty()) {
                Response.ResponseBuilder result2 = Response.ok((Object)new HdfsService.FileOperationResult(false, "Can't move 0 file/folder to '" + destination + "'")).status(422);
                return result2.build();
            }
            int index = 0;
            for (String src : sources) {
                String fileName = this.getFileName(src);
                String finalDestination = this.getDestination(destination, fileName);
                try {
                    if (api.rename(src, finalDestination)) {
                        ++index;
                        continue;
                    }
                    message = "Failed to move '" + src + "' to '" + finalDestination + "'";
                }
                catch (IOException exception) {
                    message = exception.getMessage();
                    logger.error("Failed to move '{}' to '{}'. Exception: {}", new Object[]{src, finalDestination, exception.getMessage()});
                }
                break;
            }
            if (index == sources.size()) {
                result = Response.ok((Object)new HdfsService.FileOperationResult(true)).status(200);
            } else {
                HdfsService.FileOperationResult errorResult = this.getFailureFileOperationResult(sources, index, message);
                result = Response.ok((Object)errorResult).status(422);
            }
            return result.build();
        }
        catch (Exception ex) {
            throw new ServiceFormattedException(ex.getMessage(), ex);
        }
    }

    @POST
    @Path(value="/copy")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response copy(MultiSrcDstFileRequest request, @Context HttpHeaders headers, @Context UriInfo ui) {
        try {
            Response.ResponseBuilder result;
            HdfsApi api = this.getApi();
            String message = "";
            List<String> sources = request.sourcePaths;
            String destination = request.destinationPath;
            if (sources.isEmpty()) {
                Response.ResponseBuilder result2 = Response.ok((Object)new HdfsService.FileOperationResult(false, "Can't copy 0 file/folder to '" + destination + "'")).status(422);
                return result2.build();
            }
            int index = 0;
            for (String src : sources) {
                String fileName = this.getFileName(src);
                String finalDestination = this.getDestination(destination, fileName);
                try {
                    api.copy(src, finalDestination);
                    ++index;
                }
                catch (IOException | HdfsApiException exception) {
                    message = exception.getMessage();
                    logger.error("Failed to copy '{}' to '{}'. Exception: {}", new Object[]{src, finalDestination, exception.getMessage()});
                    break;
                }
            }
            if (index == sources.size()) {
                result = Response.ok((Object)new HdfsService.FileOperationResult(true)).status(200);
            } else {
                HdfsService.FileOperationResult errorResult = this.getFailureFileOperationResult(sources, index, message);
                result = Response.ok((Object)errorResult).status(422);
            }
            return result.build();
        }
        catch (Exception ex) {
            throw new ServiceFormattedException(ex.getMessage(), ex);
        }
    }

    @PUT
    @Path(value="/mkdir")
    @Produces(value={"application/json"})
    public Response mkdir(MkdirRequest request) {
        try {
            HdfsApi api = this.getApi();
            Response.ResponseBuilder result = api.mkdir(request.path) ? Response.ok((Object)this.getApi().fileStatusToJSON(api.getFileStatus(request.path))) : Response.ok((Object)new HdfsService.FileOperationResult(false, "Can't create dir '" + request.path + "'")).status(422);
            return result.build();
        }
        catch (WebApplicationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ServiceFormattedException(ex.getMessage(), ex);
        }
    }

    @DELETE
    @Path(value="/trash/emptyTrash")
    @Produces(value={"application/json"})
    public Response emptyTrash() {
        try {
            HdfsApi api = this.getApi();
            api.emptyTrash();
            return Response.ok((Object)new HdfsService.FileOperationResult(true)).build();
        }
        catch (WebApplicationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ServiceFormattedException(ex.getMessage(), ex);
        }
    }

    @POST
    @Path(value="/moveToTrash")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response moveToTrash(MultiRemoveRequest request) {
        try {
            Response.ResponseBuilder result;
            HdfsApi api = this.getApi();
            String trash = api.getTrashDirPath();
            String message = "";
            if (request.paths.size() == 0) {
                result = Response.ok((Object)new HdfsService.FileOperationResult(false, "No path entries provided.")).status(422);
            } else {
                if (!api.exists(trash) && !api.mkdir(trash)) {
                    Response.ResponseBuilder result2 = Response.ok((Object)new HdfsService.FileOperationResult(false, "Trash dir does not exists. Can't create dir for trash '" + trash + "'")).status(422);
                    return result2.build();
                }
                int index = 0;
                for (MultiRemoveRequest.PathEntry entry : request.paths) {
                    String trashFilePath = api.getTrashDirPath(entry.path);
                    try {
                        if (api.rename(entry.path, trashFilePath)) {
                            ++index;
                            continue;
                        }
                        message = "Failed to move '" + entry.path + "' to '" + trashFilePath + "'";
                    }
                    catch (IOException exception) {
                        message = exception.getMessage();
                        logger.error("Failed to move '{}' to '{}'. Exception: {}", new Object[]{entry.path, trashFilePath, exception.getMessage()});
                    }
                    break;
                }
                if (index == request.paths.size()) {
                    result = Response.ok((Object)new HdfsService.FileOperationResult(true)).status(200);
                } else {
                    HdfsService.FileOperationResult errorResult = this.getFailureFileOperationResult(this.getPathsFromPathsEntries(request.paths), index, message);
                    result = Response.ok((Object)errorResult).status(422);
                }
            }
            return result.build();
        }
        catch (Exception ex) {
            throw new ServiceFormattedException(ex.getMessage(), ex);
        }
    }

    @POST
    @Path(value="/remove")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response remove(MultiRemoveRequest request, @Context HttpHeaders headers, @Context UriInfo ui) {
        try {
            Response.ResponseBuilder result;
            HdfsApi api = this.getApi();
            String message = "";
            if (request.paths.size() == 0) {
                result = Response.ok((Object)new HdfsService.FileOperationResult(false, "No path entries provided."));
            } else {
                int index = 0;
                for (MultiRemoveRequest.PathEntry entry : request.paths) {
                    try {
                        if (api.delete(entry.path, entry.recursive)) {
                            ++index;
                            continue;
                        }
                        message = "Failed to remove '" + entry.path + "'";
                    }
                    catch (IOException exception) {
                        message = exception.getMessage();
                        logger.error("Failed to remove '{}'. Exception: {}", (Object)entry.path, (Object)exception.getMessage());
                    }
                    break;
                }
                if (index == request.paths.size()) {
                    result = Response.ok((Object)new HdfsService.FileOperationResult(true)).status(200);
                } else {
                    HdfsService.FileOperationResult errorResult = this.getFailureFileOperationResult(this.getPathsFromPathsEntries(request.paths), index, message);
                    result = Response.ok((Object)errorResult).status(422);
                }
            }
            return result.build();
        }
        catch (Exception ex) {
            throw new ServiceFormattedException(ex.getMessage(), ex);
        }
    }

    private List<String> getPathsFromPathsEntries(List<MultiRemoveRequest.PathEntry> paths) {
        ArrayList<String> entries = new ArrayList<String>();
        for (MultiRemoveRequest.PathEntry path : paths) {
            entries.add(path.path);
        }
        return entries;
    }

    private HdfsService.FileOperationResult getFailureFileOperationResult(List<String> paths, int failedIndex, String message) {
        ArrayList<String> succeeded = new ArrayList<String>();
        ArrayList<String> unprocessed = new ArrayList<String>();
        ArrayList<String> failed = new ArrayList<String>();
        ListIterator<String> iter = paths.listIterator();
        while (iter.hasNext()) {
            int index = iter.nextIndex();
            String path = iter.next();
            if (index < failedIndex) {
                succeeded.add(path);
                continue;
            }
            if (index == failedIndex) {
                failed.add(path);
                continue;
            }
            unprocessed.add(path);
        }
        return new HdfsService.FileOperationResult(false, message, succeeded, failed, unprocessed);
    }

    private String getDestination(String baseDestination, String fileName) {
        if (baseDestination.endsWith("/")) {
            return baseDestination + fileName;
        }
        return baseDestination + "/" + fileName;
    }

    private String getFileName(String srcPath) {
        return srcPath.substring(srcPath.lastIndexOf(47) + 1);
    }

    @XmlRootElement
    public static class MultiRemoveRequest {
        @XmlElement(nillable=false, required=true)
        public List<PathEntry> paths = new ArrayList<PathEntry>();

        public static class PathEntry {
            @XmlElement(nillable=false, required=true)
            public String path;
            public boolean recursive;
        }
    }

    @XmlRootElement
    public static class MultiSrcDstFileRequest {
        @XmlElement(nillable=false, required=true)
        public List<String> sourcePaths = new ArrayList<String>();
        @XmlElement(nillable=false, required=true)
        public String destinationPath;
    }

    @XmlRootElement
    public static class SrcDstFileRequest {
        @XmlElement(nillable=false, required=true)
        public String src;
        @XmlElement(nillable=false, required=true)
        public String dst;
    }

    @XmlRootElement
    public static class ChmodRequest {
        @XmlElement(nillable=false, required=true)
        public String path;
        @XmlElement(nillable=false, required=true)
        public String mode;
    }

    @XmlRootElement
    public static class MkdirRequest {
        @XmlElement(nillable=false, required=true)
        public String path;
    }
}

