/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ambari.view.commons.exceptions;

import java.security.AccessControlException;
import java.util.HashMap;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.json.simple.JSONObject;

public class ServiceFormattedException
extends WebApplicationException {
    public ServiceFormattedException(String message, Throwable exception) {
        super(ServiceFormattedException.errorEntity(message, exception, ServiceFormattedException.suggestStatus(exception)));
    }

    public ServiceFormattedException(String message, Throwable exception, int status) {
        super(ServiceFormattedException.errorEntity(message, exception, status));
    }

    private static int suggestStatus(Throwable exception) {
        int status = 500;
        if (exception instanceof AccessControlException) {
            status = 403;
        }
        return status;
    }

    protected static Response errorEntity(String message, Throwable e, int status) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        response.put("message", message);
        String trace = null;
        if (e != null) {
            trace = ExceptionUtils.getStackTrace((Throwable)e);
        }
        response.put("trace", trace);
        response.put("status", status);
        return Response.status((int)status).entity((Object)new JSONObject(response)).type("application/json").build();
    }
}

