/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.sink.kafka;

import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Counter;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Metered;
import com.yammer.metrics.core.Metric;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.MetricProcessor;
import com.yammer.metrics.core.MetricsRegistry;
import com.yammer.metrics.core.Summarizable;
import com.yammer.metrics.core.Timer;
import com.yammer.metrics.stats.Snapshot;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kafka.metrics.KafkaMetricsConfig;
import kafka.metrics.KafkaMetricsReporter;
import kafka.utils.VerifiableProperties;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.ClassUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.metrics2.sink.kafka.JvmMetricSet;
import org.apache.hadoop.metrics2.sink.kafka.KafkaTimelineMetricsReporterMBean;
import org.apache.hadoop.metrics2.sink.kafka.ScheduledReporter;
import org.apache.hadoop.metrics2.sink.timeline.AbstractTimelineMetricsSink;
import org.apache.hadoop.metrics2.sink.timeline.TimelineMetric;
import org.apache.hadoop.metrics2.sink.timeline.TimelineMetricMetadata;
import org.apache.hadoop.metrics2.sink.timeline.TimelineMetrics;
import org.apache.hadoop.metrics2.sink.timeline.cache.TimelineMetricsCache;

public class KafkaTimelineMetricsReporter
extends AbstractTimelineMetricsSink
implements KafkaMetricsReporter,
KafkaTimelineMetricsReporterMBean {
    private static final Log LOG = LogFactory.getLog(KafkaTimelineMetricsReporter.class);
    private static final String TIMELINE_METRICS_KAFKA_PREFIX = "kafka.timeline.metrics.";
    private static final String TIMELINE_METRICS_SEND_INTERVAL_PROPERTY = "sendInterval";
    private static final String TIMELINE_METRICS_MAX_ROW_CACHE_SIZE_PROPERTY = "kafka.timeline.metrics.maxRowCacheSize";
    private static final String TIMELINE_HOSTS_PROPERTY = "kafka.timeline.metrics.hosts";
    private static final String TIMELINE_PORT_PROPERTY = "kafka.timeline.metrics.port";
    private static final String TIMELINE_PROTOCOL_PROPERTY = "kafka.timeline.metrics.protocol";
    private static final String TIMELINE_REPORTER_ENABLED_PROPERTY = "kafka.timeline.metrics.reporter.enabled";
    private static final String TIMELINE_METRICS_SSL_KEYSTORE_PATH_PROPERTY = "kafka.timeline.metrics.truststore.path";
    private static final String TIMELINE_METRICS_SSL_KEYSTORE_TYPE_PROPERTY = "kafka.timeline.metrics.truststore.type";
    private static final String TIMELINE_METRICS_SSL_KEYSTORE_PASSWORD_PROPERTY = "kafka.timeline.metrics.truststore.password";
    private static final String TIMELINE_METRICS_KAFKA_INSTANCE_ID_PROPERTY = "kafka.timeline.metrics.instanceId";
    private static final String TIMELINE_METRICS_KAFKA_SET_INSTANCE_ID_PROPERTY = "kafka.timeline.metrics.set.instanceId";
    private static final String TIMELINE_METRICS_KAFKA_HOST_IN_MEMORY_AGGREGATION_ENABLED_PROPERTY = "kafka.timeline.metrics.host_in_memory_aggregation";
    private static final String TIMELINE_METRICS_KAFKA_HOST_IN_MEMORY_AGGREGATION_PORT_PROPERTY = "kafka.timeline.metrics.host_in_memory_aggregation_port";
    private static final String TIMELINE_METRICS_KAFKA_HOST_IN_MEMORY_AGGREGATION_PROTOCOL_PROPERTY = "kafka.timeline.metrics.host_in_memory_aggregation_protocol";
    private static final String TIMELINE_DEFAULT_HOST = "localhost";
    private static final String TIMELINE_DEFAULT_PORT = "6188";
    private static final String TIMELINE_DEFAULT_PROTOCOL = "http";
    private static final String EXCLUDED_METRICS_PROPERTY = "external.kafka.metrics.exclude.prefix";
    private static final String INCLUDED_METRICS_PROPERTY = "external.kafka.metrics.include.prefix";
    private volatile boolean initialized = false;
    private boolean running = false;
    private final Object lock = new Object();
    private String hostname;
    private String metricCollectorPort;
    private Collection<String> collectorHosts;
    private String metricCollectorProtocol;
    private TimelineScheduledReporter reporter;
    private TimelineMetricsCache metricsCache;
    private int timeoutSeconds = 10;
    private String zookeeperQuorum = null;
    private boolean setInstanceId;
    private String instanceId;
    private String[] excludedMetricsPrefixes;
    private String[] includedMetricsPrefixes;
    private Set<String> excludedMetrics = new HashSet<String>();
    private boolean hostInMemoryAggregationEnabled;
    private int hostInMemoryAggregationPort;
    private String hostInMemoryAggregationProtocol;

    protected String getCollectorUri(String host) {
        return this.constructTimelineMetricUri(this.metricCollectorProtocol, host, this.metricCollectorPort);
    }

    protected String getCollectorProtocol() {
        return this.metricCollectorProtocol;
    }

    protected String getCollectorPort() {
        return this.metricCollectorPort;
    }

    protected int getTimeoutSeconds() {
        return this.timeoutSeconds;
    }

    protected String getZookeeperQuorum() {
        return this.zookeeperQuorum;
    }

    protected Collection<String> getConfiguredCollectorHosts() {
        return this.collectorHosts;
    }

    protected String getHostname() {
        return this.hostname;
    }

    protected boolean isHostInMemoryAggregationEnabled() {
        return this.hostInMemoryAggregationEnabled;
    }

    protected int getHostInMemoryAggregationPort() {
        return this.hostInMemoryAggregationPort;
    }

    protected String getHostInMemoryAggregationProtocol() {
        return this.hostInMemoryAggregationProtocol;
    }

    public void setMetricsCache(TimelineMetricsCache metricsCache) {
        this.metricsCache = metricsCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(VerifiableProperties props) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.initialized) {
                String includedMetricsStr;
                String excludedMetricsStr;
                LOG.info((Object)"Initializing Kafka Timeline Metrics Sink");
                try {
                    this.hostname = InetAddress.getLocalHost().getHostName();
                    if (this.hostname == null || !this.hostname.contains(".")) {
                        this.hostname = InetAddress.getLocalHost().getCanonicalHostName();
                    }
                }
                catch (UnknownHostException e) {
                    LOG.error((Object)"Could not identify hostname.");
                    throw new RuntimeException("Could not identify hostname.", e);
                }
                super.init();
                KafkaMetricsConfig metricsConfig = new KafkaMetricsConfig(props);
                this.timeoutSeconds = props.getInt("timeout", 10);
                int metricsSendInterval = props.getInt(TIMELINE_METRICS_SEND_INTERVAL_PROPERTY, 59000);
                int maxRowCacheSize = props.getInt(TIMELINE_METRICS_MAX_ROW_CACHE_SIZE_PROPERTY, 10000);
                this.zookeeperQuorum = props.containsKey("metrics.zookeeper.quorum") ? props.getString("metrics.zookeeper.quorum") : props.getString("zookeeper.connect");
                this.metricCollectorPort = props.getString(TIMELINE_PORT_PROPERTY, TIMELINE_DEFAULT_PORT);
                this.collectorHosts = this.parseHostsStringIntoCollection(props.getString(TIMELINE_HOSTS_PROPERTY, TIMELINE_DEFAULT_HOST));
                this.metricCollectorProtocol = props.getString(TIMELINE_PROTOCOL_PROPERTY, TIMELINE_DEFAULT_PROTOCOL);
                this.instanceId = props.getString(TIMELINE_METRICS_KAFKA_INSTANCE_ID_PROPERTY, null);
                this.setInstanceId = props.getBoolean(TIMELINE_METRICS_KAFKA_SET_INSTANCE_ID_PROPERTY, false);
                this.hostInMemoryAggregationEnabled = props.getBoolean(TIMELINE_METRICS_KAFKA_HOST_IN_MEMORY_AGGREGATION_ENABLED_PROPERTY, false);
                this.hostInMemoryAggregationPort = props.getInt(TIMELINE_METRICS_KAFKA_HOST_IN_MEMORY_AGGREGATION_PORT_PROPERTY, 61888);
                this.hostInMemoryAggregationProtocol = props.getString(TIMELINE_METRICS_KAFKA_HOST_IN_MEMORY_AGGREGATION_PROTOCOL_PROPERTY, TIMELINE_DEFAULT_PROTOCOL);
                this.setMetricsCache(new TimelineMetricsCache(maxRowCacheSize, metricsSendInterval));
                if (this.metricCollectorProtocol.contains("https") || this.hostInMemoryAggregationProtocol.contains("https")) {
                    String trustStorePath = props.getString(TIMELINE_METRICS_SSL_KEYSTORE_PATH_PROPERTY).trim();
                    String trustStoreType = props.getString(TIMELINE_METRICS_SSL_KEYSTORE_TYPE_PROPERTY).trim();
                    String trustStorePwd = props.getString(TIMELINE_METRICS_SSL_KEYSTORE_PASSWORD_PROPERTY).trim();
                    this.loadTruststore(trustStorePath, trustStoreType, trustStorePwd);
                }
                if (!StringUtils.isEmpty((String)(excludedMetricsStr = props.getString(EXCLUDED_METRICS_PROPERTY, "")).trim())) {
                    this.excludedMetricsPrefixes = excludedMetricsStr.trim().split(",");
                }
                if (!StringUtils.isEmpty((String)(includedMetricsStr = props.getString(INCLUDED_METRICS_PROPERTY, "")).trim())) {
                    this.includedMetricsPrefixes = includedMetricsStr.trim().split(",");
                }
                this.initializeReporter();
                if (props.getBoolean(TIMELINE_REPORTER_ENABLED_PROPERTY, false)) {
                    this.startReporter(metricsConfig.pollingIntervalSecs());
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("MetricsSendInterval = " + metricsSendInterval));
                    LOG.debug((Object)("MaxRowCacheSize = " + maxRowCacheSize));
                    LOG.debug((Object)("Excluded metrics prefixes = " + excludedMetricsStr));
                    LOG.debug((Object)("Included metrics prefixes = " + includedMetricsStr));
                }
            }
        }
    }

    public String getMBeanName() {
        return "kafka:type=org.apache.hadoop.metrics2.sink.kafka.KafkaTimelineMetricsReporter";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void startReporter(long period) {
        Object object = this.lock;
        synchronized (object) {
            if (this.initialized && !this.running) {
                this.reporter.start(period, TimeUnit.SECONDS);
                this.running = true;
                LOG.info((Object)String.format("Started Kafka Timeline metrics reporter with polling period %d seconds", period));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stopReporter() {
        Object object = this.lock;
        synchronized (object) {
            if (this.initialized && this.running) {
                this.reporter.stop();
                this.running = false;
                LOG.info((Object)"Stopped Kafka Timeline metrics reporter");
                this.initializeReporter();
            }
        }
    }

    private void initializeReporter() {
        this.reporter = new TimelineScheduledReporter(Metrics.defaultRegistry(), "timeline-scheduled-reporter", TimeUnit.SECONDS, TimeUnit.MILLISECONDS);
        this.initialized = true;
    }

    protected boolean isExcludedMetric(String metricName) {
        if (this.excludedMetrics.contains(metricName)) {
            return true;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("metricName => " + metricName + ", exclude: " + StringUtils.startsWithAny((String)metricName, (String[])this.excludedMetricsPrefixes) + ", include: " + StringUtils.startsWithAny((String)metricName, (String[])this.includedMetricsPrefixes)));
        }
        if (StringUtils.startsWithAny((String)metricName, (String[])this.excludedMetricsPrefixes) && !StringUtils.startsWithAny((String)metricName, (String[])this.includedMetricsPrefixes)) {
            this.excludedMetrics.add(metricName);
            return true;
        }
        return false;
    }

    class TimelineScheduledReporter
    extends ScheduledReporter
    implements MetricProcessor<Context> {
        private static final String APP_ID = "kafka_broker";
        private static final String COUNT_SUFIX = ".count";
        private static final String ONE_MINUTE_RATE_SUFIX = ".1MinuteRate";
        private static final String MEAN_SUFIX = ".mean";
        private static final String MEAN_RATE_SUFIX = ".meanRate";
        private static final String FIVE_MINUTE_RATE_SUFIX = ".5MinuteRate";
        private static final String FIFTEEN_MINUTE_RATE_SUFIX = ".15MinuteRate";
        private static final String MIN_SUFIX = ".min";
        private static final String MAX_SUFIX = ".max";
        private static final String MEDIAN_SUFIX = ".median";
        private static final String STD_DEV_SUFIX = "stddev";
        private static final String SEVENTY_FIFTH_PERCENTILE_SUFIX = ".75percentile";
        private static final String NINETY_FIFTH_PERCENTILE_SUFIX = ".95percentile";
        private static final String NINETY_EIGHTH_PERCENTILE_SUFIX = ".98percentile";
        private static final String NINETY_NINTH_PERCENTILE_SUFIX = ".99percentile";
        private static final String NINETY_NINE_POINT_NINE_PERCENTILE_SUFIX = ".999percentile";

        protected TimelineScheduledReporter(MetricsRegistry registry, String name, TimeUnit rateUnit, TimeUnit durationUnit) {
            super(registry, name, rateUnit, durationUnit);
            JvmMetricSet.getInstance().getJvmMetrics().forEach((arg_0, arg_1) -> ((MetricsRegistry)registry).newGauge(arg_0, arg_1));
        }

        @Override
        public void report(Set<Map.Entry<MetricName, Metric>> metrics) {
            final ArrayList metricsList = new ArrayList();
            try {
                for (Map.Entry<MetricName, Metric> entry : metrics) {
                    MetricName metricName = entry.getKey();
                    Metric metric = entry.getValue();
                    Context context = new Context(){

                        @Override
                        public List<TimelineMetric> getTimelineMetricList() {
                            return metricsList;
                        }
                    };
                    metric.processWith((MetricProcessor)this, metricName, (Object)context);
                }
            }
            catch (Throwable t) {
                LOG.error((Object)"Exception processing Kafka metric", t);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Metrics List size: " + metricsList.size()));
                LOG.debug((Object)("Metics Set size: " + metrics.size()));
                LOG.debug((Object)("Excluded metrics set: " + KafkaTimelineMetricsReporter.this.excludedMetrics));
            }
            if (!metricsList.isEmpty()) {
                TimelineMetrics timelineMetrics = new TimelineMetrics();
                timelineMetrics.setMetrics(metricsList);
                try {
                    KafkaTimelineMetricsReporter.this.emitMetrics(timelineMetrics);
                }
                catch (Throwable t) {
                    LOG.error((Object)"Exception emitting metrics", t);
                }
            }
        }

        private TimelineMetric createTimelineMetric(long currentTimeMillis, String component, String attributeName, Number attributeValue) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Creating timeline metric: " + attributeName + " = " + attributeValue + " time = " + currentTimeMillis + " app_id = " + component));
            }
            TimelineMetric timelineMetric = new TimelineMetric();
            timelineMetric.setMetricName(attributeName);
            timelineMetric.setHostName(KafkaTimelineMetricsReporter.this.hostname);
            if (KafkaTimelineMetricsReporter.this.setInstanceId) {
                timelineMetric.setInstanceId(KafkaTimelineMetricsReporter.this.instanceId);
            }
            timelineMetric.setAppId(component);
            timelineMetric.setStartTime(currentTimeMillis);
            timelineMetric.setType(ClassUtils.getShortCanonicalName((Object)attributeValue, (String)"Number"));
            timelineMetric.getMetricValues().put(currentTimeMillis, attributeValue.doubleValue());
            return timelineMetric;
        }

        public void processMeter(MetricName name, Metered meter, Context context) throws Exception {
            long currentTimeMillis = System.currentTimeMillis();
            String sanitizedName = this.sanitizeName(name);
            String[] metricNames = this.cacheKafkaMetered(currentTimeMillis, sanitizedName, meter);
            this.populateMetricsList(context, TimelineMetricMetadata.MetricType.GAUGE, metricNames);
        }

        public void processCounter(MetricName name, Counter counter, Context context) throws Exception {
            long currentTimeMillis = System.currentTimeMillis();
            String sanitizedName = this.sanitizeName(name);
            String metricCountName = this.cacheSanitizedTimelineMetric(currentTimeMillis, sanitizedName, COUNT_SUFIX, counter.count());
            this.populateMetricsList(context, TimelineMetricMetadata.MetricType.COUNTER, metricCountName);
        }

        public void processHistogram(MetricName name, Histogram histogram, Context context) throws Exception {
            long currentTimeMillis = System.currentTimeMillis();
            Snapshot snapshot = histogram.getSnapshot();
            String sanitizedName = this.sanitizeName(name);
            Object[] metricHNames = this.cacheKafkaSummarizable(currentTimeMillis, sanitizedName, (Summarizable)histogram);
            Object[] metricSNames = this.cacheKafkaSnapshot(currentTimeMillis, sanitizedName, snapshot);
            String[] metricNames = (String[])ArrayUtils.addAll((Object[])metricHNames, (Object[])metricSNames);
            this.populateMetricsList(context, TimelineMetricMetadata.MetricType.GAUGE, metricNames);
        }

        public void processTimer(MetricName name, Timer timer, Context context) throws Exception {
            long currentTimeMillis = System.currentTimeMillis();
            Snapshot snapshot = timer.getSnapshot();
            String sanitizedName = this.sanitizeName(name);
            Object[] metricMNames = this.cacheKafkaMetered(currentTimeMillis, sanitizedName, (Metered)timer);
            Object[] metricTNames = this.cacheKafkaSummarizable(currentTimeMillis, sanitizedName, (Summarizable)timer);
            Object[] metricSNames = this.cacheKafkaSnapshot(currentTimeMillis, sanitizedName, snapshot);
            Object[] metricNames = (String[])ArrayUtils.addAll((Object[])metricMNames, (Object[])metricTNames);
            metricNames = (String[])ArrayUtils.addAll((Object[])metricNames, (Object[])metricSNames);
            this.populateMetricsList(context, TimelineMetricMetadata.MetricType.GAUGE, (String[])metricNames);
        }

        public void processGauge(MetricName name, Gauge<?> gauge, Context context) throws Exception {
            long currentTimeMillis = System.currentTimeMillis();
            String sanitizedName = this.sanitizeName(name);
            try {
                if (!KafkaTimelineMetricsReporter.this.isExcludedMetric(sanitizedName)) {
                    this.cacheSanitizedTimelineMetric(currentTimeMillis, sanitizedName, "", Double.parseDouble(String.valueOf(gauge.value())));
                    this.populateMetricsList(context, TimelineMetricMetadata.MetricType.GAUGE, sanitizedName);
                }
            }
            catch (NumberFormatException ex) {
                LOG.debug((Object)ex.getMessage());
            }
        }

        private String[] cacheKafkaMetered(long currentTimeMillis, String sanitizedName, Metered meter) {
            String meterCountName = this.cacheSanitizedTimelineMetric(currentTimeMillis, sanitizedName, COUNT_SUFIX, meter.count());
            String meterOneMinuteRateName = this.cacheSanitizedTimelineMetric(currentTimeMillis, sanitizedName, ONE_MINUTE_RATE_SUFIX, meter.oneMinuteRate());
            String meterMeanRateName = this.cacheSanitizedTimelineMetric(currentTimeMillis, sanitizedName, MEAN_RATE_SUFIX, meter.meanRate());
            String meterFiveMinuteRateName = this.cacheSanitizedTimelineMetric(currentTimeMillis, sanitizedName, FIVE_MINUTE_RATE_SUFIX, meter.fiveMinuteRate());
            String meterFifteenMinuteRateName = this.cacheSanitizedTimelineMetric(currentTimeMillis, sanitizedName, FIFTEEN_MINUTE_RATE_SUFIX, meter.fifteenMinuteRate());
            return new String[]{meterCountName, meterOneMinuteRateName, meterMeanRateName, meterFiveMinuteRateName, meterFifteenMinuteRateName};
        }

        private String[] cacheKafkaSummarizable(long currentTimeMillis, String sanitizedName, Summarizable summarizable) {
            String minName = this.cacheSanitizedTimelineMetric(currentTimeMillis, sanitizedName, MIN_SUFIX, summarizable.min());
            String maxName = this.cacheSanitizedTimelineMetric(currentTimeMillis, sanitizedName, MAX_SUFIX, summarizable.max());
            String meanName = this.cacheSanitizedTimelineMetric(currentTimeMillis, sanitizedName, MEAN_SUFIX, summarizable.mean());
            String stdDevName = this.cacheSanitizedTimelineMetric(currentTimeMillis, sanitizedName, STD_DEV_SUFIX, summarizable.stdDev());
            return new String[]{maxName, meanName, minName, stdDevName};
        }

        private String[] cacheKafkaSnapshot(long currentTimeMillis, String sanitizedName, Snapshot snapshot) {
            String medianName = this.cacheSanitizedTimelineMetric(currentTimeMillis, sanitizedName, MEDIAN_SUFIX, snapshot.getMedian());
            String seventyFifthPercentileName = this.cacheSanitizedTimelineMetric(currentTimeMillis, sanitizedName, SEVENTY_FIFTH_PERCENTILE_SUFIX, snapshot.get75thPercentile());
            String ninetyFifthPercentileName = this.cacheSanitizedTimelineMetric(currentTimeMillis, sanitizedName, NINETY_FIFTH_PERCENTILE_SUFIX, snapshot.get95thPercentile());
            String ninetyEighthPercentileName = this.cacheSanitizedTimelineMetric(currentTimeMillis, sanitizedName, NINETY_EIGHTH_PERCENTILE_SUFIX, snapshot.get98thPercentile());
            String ninetyNinthPercentileName = this.cacheSanitizedTimelineMetric(currentTimeMillis, sanitizedName, NINETY_NINTH_PERCENTILE_SUFIX, snapshot.get99thPercentile());
            String ninetyNinePointNinePercentileName = this.cacheSanitizedTimelineMetric(currentTimeMillis, sanitizedName, NINETY_NINE_POINT_NINE_PERCENTILE_SUFIX, snapshot.get999thPercentile());
            return new String[]{medianName, ninetyEighthPercentileName, ninetyFifthPercentileName, ninetyNinePointNinePercentileName, ninetyNinthPercentileName, seventyFifthPercentileName};
        }

        private String cacheSanitizedTimelineMetric(long currentTimeMillis, String sanitizedName, String suffix, Number metricValue) {
            String meterName = sanitizedName + suffix;
            TimelineMetric metric = this.createTimelineMetric(currentTimeMillis, APP_ID, meterName, metricValue);
            if (!KafkaTimelineMetricsReporter.this.isExcludedMetric(meterName)) {
                KafkaTimelineMetricsReporter.this.metricsCache.putTimelineMetric(metric);
            }
            return meterName;
        }

        private void populateMetricsList(Context context, TimelineMetricMetadata.MetricType type, String ... metricNames) {
            for (String metricName : metricNames) {
                TimelineMetric cachedMetric = KafkaTimelineMetricsReporter.this.metricsCache.getTimelineMetric(metricName);
                if (cachedMetric == null) continue;
                cachedMetric.setType(type.name());
                context.getTimelineMetricList().add(cachedMetric);
            }
        }

        protected String sanitizeName(MetricName name) {
            if (name == null) {
                return "";
            }
            String qualifiedTypeName = name.getGroup() + "." + name.getType() + "." + name.getName();
            String metricName = name.hasScope() ? qualifiedTypeName + '.' + name.getScope() : qualifiedTypeName;
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < metricName.length(); ++i) {
                char p = metricName.charAt(i);
                if (!(p >= 'A' && p <= 'Z' || p >= 'a' && p <= 'z' || p >= '0' && p <= '9' || p == '_' || p == '-' || p == '.' || p == '\u0000')) {
                    sb.append('_');
                    continue;
                }
                sb.append(p);
            }
            return sb.toString();
        }
    }

    static interface Context {
        public List<TimelineMetric> getTimelineMetricList();
    }
}

