/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.sink.kafka;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.util.RatioGauge;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.apache.hadoop.metrics2.sink.kafka.MetricNameBuilder;

public class JvmMetricSet {
    private static final String MEMORY = "memory";
    private static final String THREADS = "threads";
    private static final String RUNTIME = "runtime";
    private static final JvmMetricSet INSTANCE = new JvmMetricSet();
    private final MemoryMXBean memoryMXBean;
    private final ThreadMXBean threadMXBean;
    private final RuntimeMXBean runtimeMXBean;

    public static JvmMetricSet getInstance() {
        return INSTANCE;
    }

    private JvmMetricSet() {
        this(ManagementFactory.getMemoryMXBean(), ManagementFactory.getThreadMXBean(), ManagementFactory.getRuntimeMXBean());
    }

    private JvmMetricSet(MemoryMXBean memoryMXBean, ThreadMXBean threadMXBean, RuntimeMXBean runtimeMXBean) {
        this.memoryMXBean = memoryMXBean;
        this.threadMXBean = threadMXBean;
        this.runtimeMXBean = runtimeMXBean;
    }

    public Map<MetricName, Gauge<?>> getJvmMetrics() {
        return Stream.concat(this.getMemoryUsageMetrics().stream(), Stream.concat(this.getThreadMetrics().stream(), Stream.of(this.getRuntimeMetrics()))).collect(Collectors.toMap(JvmMetric::getMetricName, JvmMetric::getMetric));
    }

    private List<JvmMetric> getMemoryUsageMetrics() {
        return Stream.of(new AbstractMap.SimpleEntry<String, MemoryUsage>("heap_usage", this.memoryMXBean.getHeapMemoryUsage()), new AbstractMap.SimpleEntry<String, MemoryUsage>("non_heap_usage", this.memoryMXBean.getNonHeapMemoryUsage())).map(entry -> new JvmMetric(MetricNameBuilder.builder().type(MEMORY).name((String)entry.getKey()).build(), (Gauge<?>)new RatioGauge((AbstractMap.SimpleEntry)entry){
            final /* synthetic */ AbstractMap.SimpleEntry val$entry;
            {
                this.val$entry = simpleEntry;
            }

            protected double getNumerator() {
                return ((MemoryUsage)this.val$entry.getValue()).getUsed();
            }

            protected double getDenominator() {
                return ((MemoryUsage)this.val$entry.getValue()).getMax();
            }
        })).collect(Collectors.toList());
    }

    private List<JvmMetric> getThreadMetrics() {
        return Stream.concat(Stream.of(new JvmMetric(MetricNameBuilder.builder().type(THREADS).name("thread_count").build(), new Gauge<Integer>(){

            public Integer value() {
                return JvmMetricSet.this.threadMXBean.getThreadCount();
            }
        }), new JvmMetric(MetricNameBuilder.builder().type(THREADS).name("daemon_thread_count").build(), new Gauge<Integer>(){

            public Integer value() {
                return JvmMetricSet.this.threadMXBean.getDaemonThreadCount();
            }
        })), Stream.of(Thread.State.RUNNABLE, Thread.State.BLOCKED, Thread.State.TIMED_WAITING, Thread.State.TERMINATED).map(state -> new JvmMetric(MetricNameBuilder.builder().type(THREADS).name(this.getThreadMetricNameByState((Thread.State)((Object)state))).build(), new Gauge<Long>(){

            public Long value() {
                return JvmMetricSet.this.getThreadCountByState(state);
            }
        }))).collect(Collectors.toList());
    }

    private String getThreadMetricNameByState(@Nonnull Thread.State state) {
        return String.format("thread-states.%s", state.name().toLowerCase());
    }

    private long getThreadCountByState(@Nonnull Thread.State state) {
        return Arrays.stream(this.threadMXBean.getThreadInfo(this.threadMXBean.getAllThreadIds(), 0)).filter(threadInfo -> threadInfo.getThreadState().equals((Object)state)).count();
    }

    private JvmMetric getRuntimeMetrics() {
        return new JvmMetric(MetricNameBuilder.builder().type(RUNTIME).name("uptime").build(), new Gauge<Long>(){

            public Long value() {
                return JvmMetricSet.this.runtimeMXBean.getUptime();
            }
        });
    }

    private static class JvmMetric {
        private final MetricName metricName;
        private final Gauge<?> metric;

        JvmMetric(MetricName metricName, Gauge<?> metric) {
            this.metricName = metricName;
            this.metric = metric;
        }

        MetricName getMetricName() {
            return this.metricName;
        }

        Gauge<?> getMetric() {
            return this.metric;
        }
    }
}

