/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.sink.kafka;

import com.yammer.metrics.core.MetricName;
import java.util.Optional;
import java.util.regex.Pattern;

public class MetricNameBuilder {
    private static final Pattern WHITESPACE = Pattern.compile("[\\s]+");
    private String group = "jvm";
    private String type;
    private String name;
    private final String replacement;

    static MetricNameBuilder builder() {
        return new MetricNameBuilder();
    }

    MetricNameBuilder() {
        this(null);
    }

    MetricNameBuilder(String replacement) {
        this.replacement = Optional.ofNullable(replacement).orElse("_");
    }

    public MetricNameBuilder group(String group) {
        this.group = group;
        return this;
    }

    public MetricNameBuilder type(String type) {
        this.type = this.replaceWhiteSpaces(type);
        return this;
    }

    public MetricNameBuilder name(String name) {
        this.name = Optional.ofNullable(this.name).orElse("") + this.replaceWhiteSpaces(name);
        return this;
    }

    private String replaceWhiteSpaces(String value) {
        return Optional.ofNullable(value).map(val -> WHITESPACE.matcher((CharSequence)val).replaceAll(this.replacement)).orElse("");
    }

    public MetricName build() {
        return new MetricName(this.group, this.type, this.name, null, this.createMBeanName());
    }

    private String createMBeanName() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.group);
        builder.append(":type=");
        builder.append(this.type);
        if (this.name.length() > 0) {
            builder.append(",name=");
            builder.append(this.name);
        }
        return builder.toString();
    }
}

