/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.sink.timeline.availability;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.metrics2.sink.timeline.availability.MetricSinkWriteShardStrategy;

public class MetricSinkWriteShardHostnameHashingStrategy
implements MetricSinkWriteShardStrategy {
    private final String hostname;
    private final long hostnameHash;
    private static final Log LOG = LogFactory.getLog(MetricSinkWriteShardHostnameHashingStrategy.class);

    public MetricSinkWriteShardHostnameHashingStrategy(String hostname) {
        this.hostname = hostname;
        this.hostnameHash = hostname != null ? this.computeHash(hostname) : 1000L;
    }

    @Override
    public String findCollectorShard(List<String> collectorHosts) {
        if (collectorHosts.isEmpty()) {
            return null;
        }
        long index = this.hostnameHash % (long)collectorHosts.size();
        index = index < 0L ? index + (long)collectorHosts.size() : index;
        String collectorHost = collectorHosts.get((int)index);
        LOG.info(String.format("Calculated collector shard %s based on hostname: %s", collectorHost, this.hostname));
        return collectorHost;
    }

    long computeHash(String hostname) {
        long h = 11987L;
        int len = hostname.length();
        for (int i = 0; i < len; ++i) {
            h = 31L * h + (long)hostname.charAt(i);
        }
        return h;
    }
}

